/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.FunctionCallback;
import com.parse.NoObjectsEncodingStrategy;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseUser;
import com.parse.Task;
import java.util.Map;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseCloud {
    private static ParseCommand constructCallCommand(String name, Map<String, ?> params) {
        ParseCommand command = new ParseCommand("client_function", ParseUser.getCurrentSessionToken());
        command.put("data", (JSONObject)Parse.encode(params, NoObjectsEncodingStrategy.get()));
        command.put("function", name);
        return command;
    }

    private static Object convertCloudResponse(Object result) {
        ParseDecoder decoder = new ParseDecoder();
        Object finalResult = decoder.decode(result);
        if (finalResult == null) {
            return result;
        }
        return finalResult;
    }

    private static <T> Task<T> callFunctionAsync(String name, Map<String, ?> params) {
        return ParseCloud.constructCallCommand(name, params).performAsync().onSuccess(new Continuation<Object, T>(){

            @Override
            public T then(Task<Object> task) throws Exception {
                Object result = ParseCloud.convertCloudResponse(task.getResult());
                return result;
            }
        });
    }

    public static <T> T callFunction(String name, Map<String, ?> params) throws ParseException {
        return Parse.waitForTask(ParseCloud.callFunctionAsync(name, params));
    }

    public static <T> void callFunctionInBackground(String name, Map<String, ?> params, FunctionCallback<T> callback) {
        Parse.callbackOnMainThreadAsync(ParseCloud.callFunctionAsync(name, params), callback);
    }
}

