/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Pair;
import com.parse.Capture;
import com.parse.Continuation;
import com.parse.OfflineDatabase;
import com.parse.OfflineQueryLogic;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseQuery;
import com.parse.ParseTraverser;
import com.parse.ParseUser;
import com.parse.Task;
import com.parse.WeakValueHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OfflineStore {
    private static Object defaultInstanceLock = new Object();
    private static OfflineStore defaultInstance = null;
    private final Object lock = new Object();
    private final OfflineDatabase sqlite;
    private final WeakValueHashMap<String, ParseObject> uuidToObjectMap = new WeakValueHashMap();
    private final WeakValueHashMap<Pair<String, String>, ParseObject> classNameAndObjectIdToObjectMap = new WeakValueHashMap();
    private final WeakHashMap<ParseObject, Task<String>> objectToUuidMap = new WeakHashMap();
    private final WeakHashMap<ParseObject, Task<Void>> fetchedObjects = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableOfflineStore(Context context) {
        Object object = defaultInstanceLock;
        synchronized (object) {
            if (defaultInstance != null) {
                throw new RuntimeException("enableOfflineStore() called multiple times.");
            }
            defaultInstance = new OfflineStore(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableOfflineStore() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            defaultInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OfflineStore getCurrent() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            return defaultInstance;
        }
    }

    private OfflineStore(Context context) {
        this.sqlite = new OfflineDatabase(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<String> getOrCreateUUIDAsync(ParseObject object, OfflineDatabase.Session db) {
        final String newUUID = UUID.randomUUID().toString();
        final Task.TaskCompletionSource tcs = Task.create();
        Object object2 = this.lock;
        synchronized (object2) {
            Task<String> uuidTask = this.objectToUuidMap.get(object);
            if (uuidTask != null) {
                return uuidTask;
            }
            this.objectToUuidMap.put(object, tcs.getTask());
            this.uuidToObjectMap.put(newUUID, object);
            this.fetchedObjects.put(object, tcs.getTask().makeVoid());
        }
        ContentValues values = new ContentValues();
        values.put("uuid", newUUID);
        values.put("className", object.getClassName());
        db.insertAsync("ParseObjects", values).continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                tcs.setResult(newUUID);
                return null;
            }
        });
        return tcs.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ParseObject> Task<T> getPointerAsync(final String uuid, OfflineDatabase.Session db) {
        Object object = this.lock;
        synchronized (object) {
            ParseObject existing = this.uuidToObjectMap.get(uuid);
            if (existing != null) {
                return Task.forResult(existing);
            }
        }
        String[] select = new String[]{"className", "objectId"};
        String where = "uuid = ?";
        String[] args = new String[]{uuid};
        return db.queryAsync("ParseObjects", select, where, args).onSuccess(new Continuation<Cursor, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T then(Task<Cursor> task) throws Exception {
                Cursor cursor = task.getResult();
                cursor.moveToFirst();
                if (cursor.isAfterLast()) {
                    throw new IllegalStateException("Attempted to find non-existent uuid " + uuid);
                }
                Object object = OfflineStore.this.lock;
                synchronized (object) {
                    ParseObject existing = (ParseObject)OfflineStore.this.uuidToObjectMap.get(uuid);
                    if (existing != null) {
                        return existing;
                    }
                    String className = cursor.getString(0);
                    String objectId = cursor.getString(1);
                    ParseObject pointer = ParseObject.createWithoutData(className, objectId);
                    if (objectId == null) {
                        OfflineStore.this.uuidToObjectMap.put(uuid, pointer);
                        OfflineStore.this.objectToUuidMap.put(pointer, Task.forResult(uuid));
                    }
                    return pointer;
                }
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(ParseQuery<T> query) {
        return this.findAsync(query, false);
    }

    <T extends ParseObject> Task<Integer> countAsync(ParseQuery<T> query) {
        return this.findAsync(query, true).onSuccess(new Continuation<List<T>, Integer>(){

            @Override
            public Integer then(Task<List<T>> task) throws Exception {
                return task.getResult().size();
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(final ParseQuery<T> query, final boolean isCount, final OfflineDatabase.Session db) {
        ParseUser user = ParseUser.getCurrentUser();
        final String userObjectId = user != null ? user.getObjectId() : null;
        String[] select = new String[]{"uuid"};
        String where = "className = ?";
        String[] args = new String[]{query.getClassName()};
        final OfflineQueryLogic queryLogic = new OfflineQueryLogic(this);
        return db.queryAsync("ParseObjects", select, where, args).onSuccessTask(new Continuation<Cursor, Task<ArrayList<T>>>(){

            @Override
            public Task<ArrayList<T>> then(Task<Cursor> task) throws Exception {
                final Cursor cursor = task.getResult();
                final OfflineQueryLogic.ConstraintMatcher matcher = queryLogic.createMatcher(query, userObjectId);
                final ArrayList results = new ArrayList();
                Task<Object> checkedAllObjects = Task.forResult(null);
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    final String uuid = cursor.getString(0);
                    checkedAllObjects = checkedAllObjects.onSuccessTask(new Continuation<Void, Task<T>>(){

                        @Override
                        public Task<T> then(Task<Void> task) throws Exception {
                            return OfflineStore.this.getPointerAsync(uuid, db);
                        }
                    }).onSuccessTask(new Continuation<T, Task<T>>(){

                        @Override
                        public Task<T> then(Task<T> task) throws Exception {
                            ParseObject object = (ParseObject)task.getResult();
                            return OfflineStore.this.fetchAsync(object, db).onSuccessValue(object);
                        }
                    }).onSuccessTask(new Continuation<T, Task<Void>>(){

                        @Override
                        public Task<Void> then(Task<T> task) throws Exception {
                            final ParseObject object = (ParseObject)task.getResult();
                            if (object.isDataAvailable()) {
                                return matcher.matches(object).onSuccess(new Continuation<Boolean, Void>(){

                                    @Override
                                    public Void then(Task<Boolean> task) {
                                        if (task.getResult().booleanValue()) {
                                            results.add(object);
                                        }
                                        return null;
                                    }
                                });
                            }
                            return Task.forResult(null);
                        }
                    });
                    cursor.moveToNext();
                }
                return checkedAllObjects.continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        cursor.close();
                        return task;
                    }
                }).onSuccessValue(results);
            }
        }).onSuccessTask(new Continuation<ArrayList<T>, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<ArrayList<T>> task) throws Exception {
                ArrayList results = task.getResult();
                queryLogic.sort(results, query);
                List<Object> trimmedResults = results;
                if (!isCount) {
                    int skip = Math.min(query.getSkip(), trimmedResults.size());
                    trimmedResults = trimmedResults.subList(skip, trimmedResults.size());
                }
                int limit = query.getLimit();
                if (!isCount && limit >= 0 && trimmedResults.size() > limit) {
                    trimmedResults = trimmedResults.subList(0, limit);
                }
                Task<Object> fetchedIncludes = Task.forResult(null);
                for (final ParseObject parseObject : trimmedResults) {
                    fetchedIncludes = fetchedIncludes.onSuccessTask(new Continuation<Void, Task<Void>>(){

                        @Override
                        public Task<Void> then(Task<Void> task) throws Exception {
                            return queryLogic.fetchIncludes(parseObject, query);
                        }
                    });
                }
                return fetchedIncludes.onSuccessValue(trimmedResults);
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(ParseQuery<T> query, boolean isCount) {
        final OfflineDatabase.Session db = this.sqlite.getSession();
        return this.findAsync(query, isCount, db).continueWithTask(new Continuation<List<T>, Task<List<T>>>(){

            @Override
            public Task<List<T>> then(Task<List<T>> task) throws Exception {
                db.close();
                return task;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<ParseObject, Boolean> getOrCreateObjectWithoutData(String className, String objectId) {
        if (objectId == null) {
            throw new IllegalStateException("objectId cannot be null.");
        }
        Pair classNameAndObjectId = Pair.create((Object)className, (Object)objectId);
        Object object = this.lock;
        synchronized (object) {
            ParseObject object2 = this.classNameAndObjectIdToObjectMap.get((Pair<String, String>)classNameAndObjectId);
            if (object2 != null) {
                return Pair.create((Object)object2, (Object)false);
            }
            return Pair.create((Object)ParseObject.create(className), (Object)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObjectId(ParseObject object, String oldObjectId, String newObjectId) {
        if (oldObjectId != null) {
            if (oldObjectId.equals(newObjectId)) {
                return;
            }
            throw new RuntimeException("objectIds cannot be changed in offline mode.");
        }
        String className = object.getClassName();
        Pair classNameAndNewObjectId = Pair.create((Object)className, (Object)newObjectId);
        Object object2 = this.lock;
        synchronized (object2) {
            ParseObject existing = this.classNameAndObjectIdToObjectMap.get((Pair<String, String>)classNameAndNewObjectId);
            if (existing != null && existing != object) {
                throw new RuntimeException("Attempted to change an objectId to one that's already known to the Offline Store.");
            }
            this.classNameAndObjectIdToObjectMap.put((Pair<String, String>)classNameAndNewObjectId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> fetchAsync(final ParseObject object, final OfflineDatabase.Session db) {
        final Task.TaskCompletionSource tcs = Task.create();
        Task<String> uuidTask = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.fetchedObjects.containsKey(object)) {
                return this.fetchedObjects.get(object);
            }
            this.fetchedObjects.put(object, tcs.getTask());
            uuidTask = this.objectToUuidMap.get(object);
        }
        String className = object.getClassName();
        String objectId = object.getObjectId();
        Task<Object> jsonStringTask = Task.forResult(null);
        if (objectId == null) {
            if (uuidTask != null) {
                final String[] select = new String[]{"json"};
                String where = "uuid = ?";
                final Capture uuid = new Capture();
                jsonStringTask = uuidTask.onSuccessTask(new Continuation<String, Task<Cursor>>(){

                    @Override
                    public Task<Cursor> then(Task<String> task) throws Exception {
                        uuid.set(task.getResult());
                        String[] args = new String[]{(String)uuid.get()};
                        return db.queryAsync("ParseObjects", select, "uuid = ?", args);
                    }
                }).onSuccess(new Continuation<Cursor, String>(){

                    @Override
                    public String then(Task<Cursor> task) throws Exception {
                        Cursor cursor = task.getResult();
                        cursor.moveToFirst();
                        if (cursor.isAfterLast()) {
                            throw new RuntimeException("Attempted to find non-existent uuid " + (String)uuid.get());
                        }
                        return cursor.getString(0);
                    }
                });
            }
        } else {
            if (uuidTask != null) {
                tcs.setError(new IllegalStateException("This object must have already been fetched from the offline store, but isn't marked as fetched."));
                Object select = this.lock;
                synchronized (select) {
                    this.fetchedObjects.remove(tcs);
                }
                return tcs.getTask();
            }
            String[] select = new String[]{"json", "uuid"};
            String where = String.format("%s = ? AND %s = ?", "className", "objectId");
            String[] args = new String[]{className, objectId};
            jsonStringTask = db.queryAsync("ParseObjects", select, where, args).onSuccess(new Continuation<Cursor, String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String then(Task<Cursor> task) throws Exception {
                    Cursor cursor = task.getResult();
                    cursor.moveToFirst();
                    if (cursor.isAfterLast()) {
                        throw new ParseException(120, "This object is not available in the offline cache.");
                    }
                    String jsonString = cursor.getString(0);
                    String newUUID = cursor.getString(1);
                    Object object2 = OfflineStore.this.lock;
                    synchronized (object2) {
                        OfflineStore.this.objectToUuidMap.put(object, Task.forResult(newUUID));
                        OfflineStore.this.uuidToObjectMap.put(newUUID, object);
                    }
                    return jsonString;
                }
            });
        }
        return jsonStringTask.onSuccessTask(new Continuation<String, Task<Void>>(){

            @Override
            public Task<Void> then(Task<String> task) throws Exception {
                String jsonString = task.getResult();
                if (jsonString == null) {
                    return Task.forError(new ParseException(120, "Attempted to fetch an object offline which was never saved to the offline cache."));
                }
                JSONObject jsonTemp = null;
                try {
                    jsonTemp = new JSONObject(jsonString);
                }
                catch (JSONException e) {
                    return Task.forError((Exception)((Object)e));
                }
                final JSONObject json = jsonTemp;
                final HashMap offlineObjects = new HashMap();
                new ParseTraverser(){

                    protected boolean visit(Object object) {
                        if (object instanceof JSONObject && ((JSONObject)object).optString("__type").equals("OfflineObject")) {
                            String uuid = ((JSONObject)object).optString("uuid");
                            offlineObjects.put(uuid, OfflineStore.this.getPointerAsync(uuid, db));
                        }
                        return true;
                    }
                }.setTraverseParseObjects(false).setYieldRoot(false).traverse(json);
                return Task.whenAll(offlineObjects.values()).onSuccess(new Continuation<Void, Void>(){

                    @Override
                    public Void then(Task<Void> task) throws Exception {
                        object.mergeREST(json, new OfflineDecoder(offlineObjects));
                        return null;
                    }
                });
            }
        }).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.setCancelled();
                } else if (task.isFaulted()) {
                    tcs.setError(task.getError());
                } else {
                    tcs.setResult(task.getResult());
                }
                return task;
            }
        });
    }

    Task<Void> fetchAsync(ParseObject object) {
        final OfflineDatabase.Session db = this.sqlite.getSession();
        return this.fetchAsync(object, db).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                db.close();
                return task;
            }
        });
    }

    private Task<String> pinAsync(final ParseObject object, final OfflineDatabase.Session db) {
        if (object.getObjectId() != null && !object.isDataAvailable() && !object.hasChanges()) {
            return Task.forResult(null);
        }
        final Capture uuid = new Capture();
        final Capture encoded = new Capture();
        return Task.forResult(null).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return OfflineStore.this.fetchAsync(object, db).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 120) {
                            return Task.forResult(null);
                        }
                        return task;
                    }
                });
            }
        }).onSuccessTask(new Continuation<Void, Task<String>>(){

            @Override
            public Task<String> then(Task<Void> task) throws Exception {
                return OfflineStore.this.getOrCreateUUIDAsync(object, db);
            }
        }).onSuccessTask(new Continuation<String, Task<Void>>(){

            @Override
            public Task<Void> then(Task<String> task) throws Exception {
                uuid.set(task.getResult());
                OfflineEncodingStrategy encoder = new OfflineEncodingStrategy(db);
                encoded.set(object.toRest(encoder));
                return encoder.whenFinished();
            }
        }).onSuccessTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                String className = object.getClassName();
                String objectId = object.getObjectId();
                String json = encoded.get().toString();
                ContentValues values = new ContentValues();
                values.put("className", className);
                values.put("json", json);
                if (objectId != null) {
                    values.put("objectId", objectId);
                }
                String where = "uuid = ?";
                String[] args = new String[]{(String)uuid.get()};
                return db.updateAsync("ParseObjects", values, where, args);
            }
        }).onSuccessTask(new Continuation<Void, Task<String>>(){

            @Override
            public Task<String> then(Task<Void> task) throws Exception {
                return Task.forResult((String)uuid.get());
            }
        });
    }

    Task<String> pinAsync(final ParseObject object, final boolean includeAllChildren) {
        final OfflineDatabase.Session db = this.sqlite.getSession();
        return Task.forResult(null).continueWithTask(new Continuation<Void, Task<String>>(){

            @Override
            public Task<String> then(Task<Void> task) throws Exception {
                if (!includeAllChildren) {
                    return OfflineStore.this.pinAsync(object, db);
                }
                final HashSet objectsToSave = new HashSet();
                new ParseTraverser(){

                    protected boolean visit(Object object) {
                        if (object instanceof ParseObject) {
                            objectsToSave.add((ParseObject)object);
                        }
                        return true;
                    }
                }.setYieldRoot(true).setTraverseParseObjects(true).traverse(object);
                final ArrayList<Task> tasks = new ArrayList<Task>();
                for (ParseObject obj : objectsToSave) {
                    tasks.add(OfflineStore.this.pinAsync(obj, db));
                }
                return Task.whenAll(tasks).continueWithTask(new Continuation<Void, Task<String>>(){

                    @Override
                    public Task<String> then(Task<Void> ignored) throws Exception {
                        for (Task task : tasks) {
                            if (!task.isFaulted() && !task.isCancelled()) continue;
                            return task;
                        }
                        return Task.forResult(null);
                    }
                });
            }
        }).continueWithTask(new Continuation<String, Task<String>>(){

            @Override
            public Task<String> then(Task<String> task) throws Exception {
                db.close();
                return task;
            }
        });
    }

    void registerNewObject(ParseObject object) {
        String objectId = object.getObjectId();
        if (objectId != null) {
            String className = object.getClassName();
            Pair classNameAndObjectId = Pair.create((Object)className, (Object)objectId);
            this.classNameAndObjectIdToObjectMap.put((Pair<String, String>)classNameAndObjectId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> updateDataForObjectAsync(final ParseObject object) {
        final Capture uuid = new Capture();
        final Capture jsonObject = new Capture();
        Task<Void> fetched = null;
        Object object2 = this.lock;
        synchronized (object2) {
            fetched = this.fetchedObjects.get(object);
            if (fetched == null) {
                return Task.forError(new IllegalStateException("An object cannot be updated if it wasn't fetched."));
            }
        }
        return fetched.onSuccessTask(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task<Void> then(Task<Void> ignored) throws Exception {
                Task uuidTask = null;
                Object object2 = OfflineStore.this.lock;
                synchronized (object2) {
                    uuidTask = (Task)OfflineStore.this.objectToUuidMap.get(object);
                    if (uuidTask == null) {
                        return Task.forResult(null);
                    }
                }
                final OfflineDatabase.Session db = OfflineStore.this.sqlite.getSession();
                return uuidTask.onSuccessTask(new Continuation<String, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<String> task) throws Exception {
                        uuid.set(task.getResult());
                        OfflineEncodingStrategy encoder = new OfflineEncodingStrategy(db);
                        jsonObject.set(object.toRest(encoder));
                        return encoder.whenFinished();
                    }
                }).onSuccessTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        String className = object.getClassName();
                        String objectId = object.getObjectId();
                        String json = jsonObject.get().toString();
                        ContentValues values = new ContentValues();
                        values.put("className", className);
                        values.put("json", json);
                        if (objectId != null) {
                            values.put("objectId", objectId);
                        }
                        String where = "uuid = ?";
                        String[] args = new String[]{(String)uuid.get()};
                        return db.updateAsync("ParseObjects", values, where, args);
                    }
                }).continueWithTask(new Continuation<Void, Task<Void>>(){

                    @Override
                    public Task<Void> then(Task<Void> task) throws Exception {
                        db.close();
                        return task;
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void simulateReboot() {
        Object object = this.lock;
        synchronized (object) {
            this.uuidToObjectMap.clear();
            this.objectToUuidMap.clear();
            this.classNameAndObjectIdToObjectMap.clear();
            this.fetchedObjects.clear();
        }
    }

    void clearDatabase() {
        this.sqlite.clearDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OfflineDecoder
    extends ParseDecoder {
        private Map<String, Task<ParseObject>> offlineObjects;

        private OfflineDecoder(Map<String, Task<ParseObject>> offlineObjects) {
            this.offlineObjects = offlineObjects;
        }

        @Override
        public Object decode(Object object) {
            if (object instanceof JSONObject && ((JSONObject)object).optString("__type").equals("OfflineObject")) {
                String uuid = ((JSONObject)object).optString("uuid");
                return this.offlineObjects.get(uuid).getResult();
            }
            return super.decode(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OfflineEncodingStrategy
    implements ParseObjectEncodingStrategy {
        private OfflineDatabase.Session db;
        private ArrayList<Task<Void>> tasks = new ArrayList();

        public OfflineEncodingStrategy(OfflineDatabase.Session db) {
            this.db = db;
        }

        public Task<Void> whenFinished() {
            return Task.whenAll(this.tasks).continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> ignore) throws Exception {
                    for (Task task : OfflineEncodingStrategy.this.tasks) {
                        if (!task.isFaulted() && !task.isCancelled()) continue;
                        return task;
                    }
                    return Task.forResult(null);
                }
            });
        }

        @Override
        public JSONObject encodeRelatedObject(ParseObject object) {
            try {
                if (object.getObjectId() != null) {
                    JSONObject result = new JSONObject();
                    result.put("__type", (Object)"Pointer");
                    result.put("objectId", (Object)object.getObjectId());
                    result.put("className", (Object)object.getClassName());
                    return result;
                }
                final JSONObject result = new JSONObject();
                result.put("__type", (Object)"OfflineObject");
                this.tasks.add(OfflineStore.this.getOrCreateUUIDAsync(object, this.db).onSuccess(new Continuation<String, Void>(){

                    @Override
                    public Void then(Task<String> task) throws Exception {
                        result.put("uuid", (Object)task.getResult());
                        return null;
                    }
                }));
                return result;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

