/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.parse.Task;
import java.util.concurrent.Callable;

class OfflineDatabase {
    static final String TABLE_OBJECTS = "ParseObjects";
    static final String KEY_UUID = "uuid";
    static final String KEY_CLASS_NAME = "className";
    static final String KEY_OBJECT_ID = "objectId";
    static final String KEY_JSON = "json";
    private static final String DATABASE_NAME = "ParseOfflineStore";
    private final Object sessionLock = new Object();
    private int sessionCount = 0;
    private SQLiteDatabase db;
    private final OfflineStoreSQLiteOpenHelper sqlite;

    public OfflineDatabase(Context context) {
        this.sqlite = new OfflineStoreSQLiteOpenHelper(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            ++this.sessionCount;
            if (this.db == null) {
                this.db = this.sqlite.getWritableDatabase();
            }
        }
        return new Session();
    }

    public void clearDatabase() {
        this.sqlite.clearDatabase();
    }

    private static class OfflineStoreSQLiteOpenHelper
    extends SQLiteOpenHelper {
        private static final int VERSION = 1;

        public OfflineStoreSQLiteOpenHelper(Context context) {
            super(context, OfflineDatabase.DATABASE_NAME, null, 1);
        }

        private void createSchema(SQLiteDatabase db) {
            String sql = String.format("CREATE TABLE %s (%s TEXT PRIMARY KEY, %s TEXT NOT NULL, %s TEXT, %s TEXT, UNIQUE(%s, %s));", OfflineDatabase.TABLE_OBJECTS, OfflineDatabase.KEY_UUID, OfflineDatabase.KEY_CLASS_NAME, OfflineDatabase.KEY_OBJECT_ID, OfflineDatabase.KEY_JSON, OfflineDatabase.KEY_CLASS_NAME, OfflineDatabase.KEY_OBJECT_ID);
            db.execSQL(sql);
        }

        private void dropSchema(SQLiteDatabase db) {
            try {
                db.execSQL(String.format("DROP TABLE %s;", OfflineDatabase.TABLE_OBJECTS));
            }
            catch (SQLiteException sQLiteException) {
                // empty catch block
            }
        }

        public void onCreate(SQLiteDatabase db) {
            this.createSchema(db);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }

        public void clearDatabase() {
            SQLiteDatabase db = this.getWritableDatabase();
            this.dropSchema(db);
            this.createSchema(db);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Session {
        Session() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = OfflineDatabase.this.sessionLock;
            synchronized (object) {
                OfflineDatabase offlineDatabase = OfflineDatabase.this;
                offlineDatabase.sessionCount = offlineDatabase.sessionCount - 1;
                if (OfflineDatabase.this.sessionCount == 0) {
                    OfflineDatabase.this.db.close();
                    OfflineDatabase.this.db = null;
                }
            }
        }

        public Task<Cursor> queryAsync(String table, final String[] select, final String where, final String[] args) {
            return Task.callInBackground(new Callable<Cursor>(){

                @Override
                public Cursor call() throws Exception {
                    return OfflineDatabase.this.db.query(OfflineDatabase.TABLE_OBJECTS, select, where, args, null, null, null);
                }
            });
        }

        public Task<Void> insertAsync(final String table, final ContentValues values) {
            return Task.callInBackground(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return OfflineDatabase.this.db.insert(table, null, values);
                }
            }).makeVoid();
        }

        public Task<Void> updateAsync(final String table, final ContentValues values, final String where, final String[] args) {
            return Task.callInBackground(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return OfflineDatabase.this.db.update(table, values, where, args);
                }
            }).makeVoid();
        }
    }
}

