/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.parse.BackgroundTask;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.PushCallback;
import com.parse.PushService;
import com.parse.SaveCallback;
import com.parse.StandardPushCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParsePushRouter {
    private static final String TAG = "com.parse.ParsePushRouter";
    private static final Pattern CHANNEL_PATTERN = Pattern.compile("^$|^[a-zA-Z][A-Za-z0-9_-]*$");
    static Map<String, CallbackFactory> channelRoutes = null;
    static CallbackFactory defaultRoute = null;
    static Set<String> channels = new HashSet<String>();
    static String lastTime = null;
    static String ignoreAfter = null;
    static JSONObject history = null;
    static int maxHistory = 10;
    private static boolean hasLoadedStateFromDisk = false;
    private static final String LEGACY_ROUTE_LOCATION = "persistentCallbacks";
    private static final String STATE_LOCATION = "pushState";

    ParsePushRouter() {
    }

    private static void saveEventually(final Context context, final ParseInstallation installation) {
        installation.saveEventually(new SaveCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(ParseException e) {
                if (e != null) {
                    Parse.logE(ParsePushRouter.TAG, "Failed to save installation eventually", e);
                    return;
                }
                ParsePushRouter.ensureStateIsLoaded(context);
                Class<ParsePushRouter> clazz = ParsePushRouter.class;
                synchronized (ParsePushRouter.class) {
                    channels.clear();
                    List fromInstallation = installation.getList("channels");
                    channels.addAll(fromInstallation);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    if (!ParsePushRouter.hasRoutes(context)) {
                        Parse.logD(ParsePushRouter.TAG, "Shutting down push service. No remaining channels");
                        context.stopService(new Intent(context, PushService.class));
                    }
                    new BackgroundTask<Void>(null){

                        @Override
                        public Void run() throws ParseException {
                            ParsePushRouter.saveStateToDisk(context);
                            return null;
                        }
                    }.execute(new Void[0]);
                    return;
                }
            }
        });
    }

    public static synchronized boolean hasRoutes(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        return defaultRoute != null || channelRoutes != null && !channelRoutes.isEmpty() || !ParsePushRouter.getSubscriptions(context).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void ensureStateIsLoaded(Context context) {
        if (hasLoadedStateFromDisk) {
            return;
        }
        hasLoadedStateFromDisk = true;
        defaultRoute = null;
        channelRoutes = new HashMap<String, CallbackFactory>();
        history = new JSONObject();
        JSONObject jsonData = ParseObject.getDiskObject(context, LEGACY_ROUTE_LOCATION);
        if (jsonData != null) {
            Parse.logD(TAG, "Loading legacy route map: " + jsonData.toString());
            ParsePushRouter.parseChannelRoutes(jsonData);
            channels.clear();
            channels.addAll(channelRoutes.keySet());
            ParseInstallation installation = ParseObject.create(ParseInstallation.class);
            installation.addAllUnique("channels", channelRoutes.keySet());
            ParsePushRouter.saveEventually(context, installation);
            ParseObject.deleteDiskObject(context, LEGACY_ROUTE_LOCATION);
        }
        if ((jsonData = ParseObject.getDiskObject(context, STATE_LOCATION)) != null) {
            JSONArray removed;
            ParseInstallation installation;
            ParsePushRouter.parseChannelRoutes(jsonData.optJSONObject("routes"));
            JSONObject defaultDefinition = jsonData.optJSONObject("defaultRoute");
            try {
                defaultRoute = defaultDefinition != null ? new CallbackFactory(defaultDefinition) : null;
            }
            catch (ClassNotFoundException e) {
                Parse.logE(TAG, "Default route references undefined class: " + e.getMessage());
            }
            catch (ClassCastException e) {
                Parse.logE(TAG, "Default route references class which is not a PushCallback: " + e.getMessage());
            }
            lastTime = jsonData.optString("lastTime", null);
            ignoreAfter = jsonData.optString("ignoreAfter", null);
            JSONArray added = jsonData.optJSONArray("addChannels");
            if (added != null) {
                ArrayList<String> channels = new ArrayList<String>();
                int i = 0;
                while (i < added.length()) {
                    channels.add(added.optString(i));
                    ++i;
                }
                installation = ParseObject.create(ParseInstallation.class);
                installation.addUnique("channels", channels);
                ParsePushRouter.saveEventually(context, installation);
            }
            if ((removed = jsonData.optJSONArray("removeChannels")) != null) {
                ArrayList<String> channels = new ArrayList<String>();
                int i = 0;
                while (i < removed.length()) {
                    channels.add(removed.optString(i));
                    ++i;
                }
                ParseInstallation installation2 = ParseObject.create(ParseInstallation.class);
                installation2.removeAll("channels", channels);
                ParsePushRouter.saveEventually(context, installation2);
            }
            if (jsonData.has("installation")) {
                installation = ParseObject.create(ParseInstallation.class);
                ParseDecoder decoder = new ParseDecoder();
                installation.mergeAfterFetch(jsonData.optJSONObject("installation"), decoder, true);
                List fromJSON = installation.getList("channels");
                if (fromJSON != null) {
                    Set<String> set = channels;
                    synchronized (set) {
                        channels.clear();
                        channels.addAll(fromJSON);
                    }
                }
            } else if (jsonData.has("channels")) {
                JSONArray channelsArray = jsonData.optJSONArray("channels");
                Set<String> set = channels;
                synchronized (set) {
                    int i = 0;
                    while (i < channelsArray.length()) {
                        channels.add(channelsArray.optString(i));
                        ++i;
                    }
                }
            }
            if (jsonData.has("history")) {
                history = jsonData.optJSONObject("history");
            }
        }
    }

    private static void parseChannelRoutes(JSONObject channelMap) {
        if (channelMap == null) {
            return;
        }
        channelRoutes.clear();
        Iterator channels = channelMap.keys();
        while (channels.hasNext()) {
            String channel = (String)channels.next();
            JSONObject definition = null;
            try {
                definition = channelMap.getJSONObject(channel);
                channelRoutes.put(channel, new CallbackFactory(definition));
            }
            catch (JSONException e) {
                Parse.logE(TAG, "Failed to parse push route " + definition);
            }
            catch (ClassNotFoundException e) {
                Parse.logE(TAG, "Route references missing class: " + e.getMessage());
            }
            catch (ClassCastException e) {
                Parse.logE(TAG, "Route references class which is not a PushCallback: " + e.getMessage());
            }
        }
    }

    private static synchronized void saveStateToDisk(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        try {
            JSONObject serializedData = new JSONObject();
            serializedData.put("version", 3);
            if (defaultRoute != null) {
                serializedData.putOpt("defaultRoute", (Object)defaultRoute.toJSON());
            }
            JSONObject channelMap = new JSONObject();
            for (String channel : channelRoutes.keySet()) {
                channelMap.putOpt(channel, (Object)channelRoutes.get(channel).toJSON());
            }
            serializedData.putOpt("routes", (Object)channelMap);
            serializedData.put("channels", (Object)new JSONArray(channels));
            serializedData.putOpt("lastTime", (Object)lastTime);
            serializedData.putOpt("history", (Object)history);
            serializedData.putOpt("ignoreAfter", (Object)ignoreAfter);
            ParseObject.saveDiskObject(context, STATE_LOCATION, serializedData);
        }
        catch (JSONException e) {
            Parse.logE(TAG, "Failed to save push routes to disk" + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    static synchronized void insertIntoHistory(String newId, String newTimestamp) {
        try {
            ParsePushRouter.history.putOpt(newId, (Object)newTimestamp);
        }
        catch (JSONException var2_2) {
            // empty catch block
        }
        youngestCut = null;
        if (ParsePushRouter.$assertionsDisabled || ParsePushRouter.maxHistory > 0) ** GOTO lbl23
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            itr = ParsePushRouter.history.keys();
            oldestId = (String)itr.next();
            oldestTime = ParsePushRouter.history.optString(oldestId);
            while (itr.hasNext()) {
                id = (String)itr.next();
                time = ParsePushRouter.history.optString(id);
                if (time.compareTo(oldestTime) >= 0) continue;
                oldestId = id;
                oldestTime = time;
            }
            ParsePushRouter.history.remove(oldestId);
            youngestCut = oldestTime;
lbl23:
            // 2 sources

            ** while (ParsePushRouter.history.length() > ParsePushRouter.maxHistory)
        }
lbl24:
        // 1 sources

        if (youngestCut != null) {
            ParsePushRouter.ignoreAfter = youngestCut;
        }
    }

    static synchronized boolean addChannelRoute(Context context, String channel, JSONObject localData, Class<? extends PushCallback> clazz) {
        ParsePushRouter.ensureStateIsLoaded(context);
        try {
            boolean isNew;
            JSONObject localDataCopy = new JSONObject(localData.toString());
            boolean bl = isNew = channelRoutes.put(channel, new CallbackFactory(clazz, localDataCopy)) == null;
            if (isNew) {
                ParseInstallation installation = ParseObject.create(ParseInstallation.class);
                installation.addUnique("channels", channel);
                ParsePushRouter.saveEventually(context, installation);
            }
            return isNew;
        }
        catch (JSONException e) {
            Parse.logE(TAG, "Impossible exception when deserializing a serialized JSON string: " + e.getMessage());
            return false;
        }
    }

    static boolean addChannelRoute(Context context, String channel, Class<? extends Activity> clazz, int icon) {
        if (channel == null) {
            throw new NullPointerException("invalid channel: you cannot subscribe to null");
        }
        if (!CHANNEL_PATTERN.matcher(channel).matches()) {
            throw new IllegalArgumentException("invalid channel name: " + channel);
        }
        JSONObject localData = ParsePushRouter.dataForActivity(context, clazz, icon);
        if (localData == null) {
            return false;
        }
        return ParsePushRouter.addChannelRoute(context, channel, localData, StandardPushCallback.class);
    }

    static JSONObject dataForActivity(Context context, Class<? extends Activity> clazz, int icon) {
        ApplicationInfo info;
        ParsePushRouter.getApplicationId(context);
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return null;
        }
        CharSequence appChars = info.loadLabel(pm);
        String appName = appChars != null ? appChars.toString() : null;
        ComponentName componentName = new ComponentName(context, clazz);
        String activityClass = componentName.getClassName();
        String activityPackage = componentName.getPackageName();
        JSONObject localData = new JSONObject();
        try {
            localData.put("icon", icon);
            localData.put("appName", (Object)appName);
            localData.put("activityClass", (Object)activityClass);
            localData.put("activityPackage", (Object)activityPackage);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        return localData;
    }

    static void setDefaultRoute(Context context, Class<? extends Activity> clazz, int icon) {
        ParsePushRouter.ensureStateIsLoaded(context);
        if (clazz == null) {
            defaultRoute = null;
        } else {
            JSONObject localData = ParsePushRouter.dataForActivity(context, clazz, icon);
            if (localData == null) {
                localData = new JSONObject();
            }
            defaultRoute = new CallbackFactory(StandardPushCallback.class, localData);
        }
        ParsePushRouter.saveStateToDisk(context);
    }

    static synchronized boolean removeChannelRoute(Context context, String channel) {
        ParsePushRouter.ensureStateIsLoaded(context);
        if (channelRoutes.remove(channel) != null) {
            ParseInstallation installation = ParseObject.create(ParseInstallation.class);
            installation.removeAll("channels", Arrays.asList(channel));
            ParsePushRouter.saveEventually(context, installation);
            return true;
        }
        return false;
    }

    static synchronized Set<String> getSubscriptions(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        return Collections.unmodifiableSet(channels);
    }

    static synchronized String getApplicationId(Context context) {
        String cached;
        JSONObject oauth = ParseObject.getDiskObject(context, "oauth");
        if (oauth == null) {
            oauth = new JSONObject();
        }
        if ((cached = oauth.optString("key")) != "") {
            return cached;
        }
        String applicationId = ParseObject.getApplicationId();
        try {
            oauth.put("key", (Object)applicationId);
        }
        catch (JSONException e) {
            Parse.logE(TAG, "JSONException in getApplicationId()", e);
        }
        ParseObject.saveDiskObject(context, "oauth", oauth);
        return applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePushData(Service service, String channel, JSONObject pushData) {
        PushCallback callback = null;
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            CallbackFactory factory = channelRoutes.get(channel);
            if (factory == null) {
                if (defaultRoute == null) {
                    Parse.logW(TAG, "Received push " + pushData.toString() + " that has no handler");
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                factory = defaultRoute;
            }
            try {
                callback = factory.newCallback();
            }
            catch (IllegalAccessException e) {
                Parse.logE(TAG, "illegal access to " + factory.clazz.getCanonicalName(), e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            catch (InstantiationException e) {
                Parse.logE(TAG, "could not instantiate " + factory.clazz.getCanonicalName(), e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            Parse.logD(TAG, "received push on channel " + channel);
            callback.setService(service);
            callback.setPushData(pushData);
            callback.setChannel(channel);
            callback.run();
            return;
        }
    }

    static void routePush(final Service service, final JSONObject message) {
        boolean dirty = false;
        final String channel = message.optString("channel", null);
        try {
            if (message.has("time")) {
                if (lastTime == null || message.optString("time").compareTo(lastTime) > 0) {
                    lastTime = message.optString("time");
                    dirty = true;
                }
                if (ignoreAfter != null && message.optString("time").compareTo(ignoreAfter) <= 0) {
                    Parse.logD(TAG, "Ignoring very old push " + message.toString());
                    return;
                }
            }
            if (channel != null && !ParsePushRouter.isSubscribedToChannel((Context)service, channel)) {
                ParseCallback<Boolean> maybeResubmit = new ParseCallback<Boolean>(){

                    @Override
                    void internalDone(Boolean returnValue, ParseException e) {
                        if (returnValue != null && returnValue.booleanValue()) {
                            ParsePushRouter.saveStateToDisk((Context)service);
                            ParsePushRouter.routePush(service, message);
                        }
                    }
                };
                new BackgroundTask<Boolean>((ParseCallback)maybeResubmit){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean run() throws ParseException {
                        ParseInstallation installation = ParseObject.create(ParseInstallation.class);
                        Parse.logI(ParsePushRouter.TAG, "refetching installation to check for out of sync channel subscription in channel " + channel);
                        installation.fetch();
                        List fromInstallation = installation.getList("channels");
                        Class<ParsePushRouter> clazz = ParsePushRouter.class;
                        synchronized (ParsePushRouter.class) {
                            channels.clear();
                            channels.addAll(fromInstallation);
                            ParsePushRouter.saveStateToDisk((Context)service);
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return ParsePushRouter.isSubscribedToChannel((Context)service, channel);
                        }
                    }
                }.execute(new Void[0]);
                return;
            }
            if (message.has("push_id")) {
                String id2 = message.optString("push_id");
                if (history.has(id2)) {
                    Parse.logD(TAG, "Ignoring redundant push " + message.toString());
                    return;
                }
                ParsePushRouter.insertIntoHistory(id2, message.optString("time"));
                dirty = true;
            } else if (message.has("time") && (lastTime == null || message.optString("time").compareTo(lastTime) > 0)) {
                lastTime = message.optString("time");
                dirty = true;
            }
        }
        finally {
            if (dirty) {
                ParsePushRouter.saveStateToDisk((Context)service);
            }
        }
        JSONObject pushData = message.optJSONObject("data");
        ParsePushRouter.handlePushData(service, channel, pushData);
    }

    private static synchronized boolean isSubscribedToChannel(Context context, String channel) {
        if (channels.contains(channel)) {
            return true;
        }
        CallbackFactory factory = channelRoutes.get(channel);
        return factory != null && !factory.requiresSubscription();
    }

    static void addSingletonRoute(Context context, String channel, PushCallback callback) {
        ParsePushRouter.ensureStateIsLoaded(context);
        if (channel != null) {
            channelRoutes.put(channel, new SingletonFactory(callback));
        } else {
            defaultRoute = new SingletonFactory(callback);
        }
    }

    static synchronized JSONObject getPushRequestJSON(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        JSONObject request = new JSONObject();
        try {
            request.put("installation_id", (Object)ParseInstallation.getCurrentInstallation().getInstallationId());
            request.put("oauth_key", (Object)ParsePushRouter.getApplicationId(context));
            request.put("v", (Object)"a1.3.7");
            if (lastTime == null) {
                request.put("last", JSONObject.NULL);
            } else {
                request.put("last", (Object)lastTime);
            }
            if (history.length() != 0) {
                JSONArray knownIds = new JSONArray();
                Iterator itr = history.keys();
                while (itr.hasNext()) {
                    knownIds.put(itr.next());
                }
                request.put("last_seen", (Object)knownIds);
            }
            request.putOpt("ignore_after", (Object)ignoreAfter);
        }
        catch (JSONException e) {
            Parse.logE(TAG, "unexpected JSONException", e);
            return null;
        }
        return request;
    }

    static void clearStateFromMemory() {
        hasLoadedStateFromDisk = false;
        channelRoutes = null;
        defaultRoute = null;
        lastTime = null;
        channels = new HashSet<String>();
        history = null;
    }

    static void clearStateFromDisk(Context context) {
        ParsePushRouter.clearStateFromMemory();
        ParseObject.deleteDiskObject(context, LEGACY_ROUTE_LOCATION);
        ParseObject.deleteDiskObject(context, STATE_LOCATION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CallbackFactory {
        Class<? extends PushCallback> clazz;
        JSONObject contextData;

        CallbackFactory(JSONObject definition) throws ClassNotFoundException {
            Parse.logD(ParsePushRouter.TAG, "Creating factory for class " + definition.optString("name"));
            this.clazz = Class.forName(definition.optString("name"));
            if (this.clazz == null) {
                throw new ClassNotFoundException("Missing class definition in " + definition);
            }
            this.contextData = definition.optJSONObject("data");
        }

        CallbackFactory(Class<? extends PushCallback> aClass, JSONObject aContextData) {
            this.clazz = aClass;
            this.contextData = aContextData;
        }

        PushCallback newCallback() throws IllegalAccessException, InstantiationException {
            PushCallback callback = this.clazz.newInstance();
            callback.setLocalData(this.contextData);
            return callback;
        }

        JSONObject toJSON() {
            try {
                JSONObject object = new JSONObject();
                object.put("name", (Object)this.clazz.getCanonicalName());
                object.putOpt("data", (Object)this.contextData);
                return object;
            }
            catch (JSONException e) {
                Parse.logE(ParsePushRouter.TAG, "Failed to encode route: " + e.getMessage());
                return null;
            }
        }

        protected CallbackFactory() {
        }

        boolean requiresSubscription() {
            return true;
        }
    }

    static class SingletonFactory
    extends CallbackFactory {
        PushCallback singleton;

        SingletonFactory(PushCallback callback) {
            this.singleton = callback;
        }

        JSONObject toJSON() {
            return null;
        }

        PushCallback newCallback() {
            return this.singleton;
        }

        boolean requiresSubscription() {
            return false;
        }
    }
}

