/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import com.parse.Capture;
import com.parse.Continuation;
import com.parse.Parse;
import com.parse.ParsePushRouter;
import com.parse.PushConnection;
import com.parse.Task;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    private static final String START_ACTION = "com.parse.PushService.start";
    private static final String START_IF_REQUIRED_ACTION = "com.parse.PushService.startIfRequired";
    private static SocketAddress address = new InetSocketAddress("push.parse.com", 8253);
    private static AtomicBoolean hasWakeLockPermission = new AtomicBoolean(true);
    private PushConnection connection;

    @SuppressLint(value={"Wakelock"})
    static PowerManager.WakeLock acquireNewWakeLock(Context context, int type, String reason, long timeout) {
        PowerManager.WakeLock wl = null;
        if (hasWakeLockPermission.get()) {
            try {
                PowerManager pm = (PowerManager)context.getApplicationContext().getSystemService("power");
                if (pm != null && (wl = pm.newWakeLock(type, reason)) != null) {
                    wl.setReferenceCounted(false);
                    if (timeout == 0L) {
                        wl.acquire();
                    } else {
                        wl.acquire(timeout);
                    }
                }
            }
            catch (SecurityException e) {
                if (hasWakeLockPermission.compareAndSet(true, false)) {
                    Parse.logE(TAG, "Failed to acquire a PowerManager.WakeLock. This isnecessary for reliable handling of pushes. Please add this to your Manifest.xml: <uses-permission android:name=\"android.permission.WAKE_LOCK\" /> ");
                }
                wl = null;
            }
        }
        return wl;
    }

    private static synchronized void startService(Context context, boolean force) {
        Parse.logD(TAG, "ensuring push service is started");
        Intent intent = new Intent(force ? START_ACTION : START_IF_REQUIRED_ACTION);
        intent.setClass(context, PushService.class);
        ComponentName name = context.startService(intent);
        if (name == null) {
            Parse.logE(TAG, "Could not start the push service. Make sure that the XML tag <service android:name=\"com.parse.PushService\" /> is in your AndroidManifest.xml as a child of the <application> element.");
        }
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startService(context, false);
    }

    public static void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        PushService.subscribe(context, channel, cls, context.getApplicationInfo().icon);
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls, int icon) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Can't subscribe to channel with null activity class.");
        }
        if (icon == 0) {
            throw new IllegalArgumentException("Must subscribe to channel with a valid icon identifier.");
        }
        ParsePushRouter.subscribeAsync(channel, cls, icon).onSuccess(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) {
                PushService.startServiceIfRequired(Parse.applicationContext);
                return null;
            }
        });
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        ParsePushRouter.unsubscribeAsync(channel);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        PushService.setDefaultPushCallback(context, cls, context.getApplicationInfo().icon);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls, int icon) {
        if (icon == 0) {
            throw new IllegalArgumentException("Must subscribe to channel with a valid icon identifier.");
        }
        if (cls == null) {
            ParsePushRouter.unsubscribeAsync(null).onSuccessTask(new Continuation<Void, Task<Set<String>>>(){

                @Override
                public Task<Set<String>> then(Task<Void> task) {
                    return ParsePushRouter.getSubscriptionsAsync();
                }
            }).onSuccess(new Continuation<Set<String>, Void>(){

                @Override
                public Void then(Task<Set<String>> task) {
                    if (task.getResult().size() == 0) {
                        Context context = Parse.applicationContext;
                        context.stopService(new Intent(context, PushService.class));
                    }
                    return null;
                }
            });
        } else {
            ParsePushRouter.subscribeAsync(null, cls, icon).onSuccess(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    PushService.startServiceIfRequired(Parse.applicationContext);
                    return null;
                }
            });
        }
    }

    public static Set<String> getSubscriptions(Context context) {
        final Capture capture = new Capture();
        ParsePushRouter.getSubscriptionsAsync().continueWith(new Continuation<Set<String>, Void>(){

            @Override
            public Void then(Task<Set<String>> task) {
                Set<String> subscriptions = task.getResult();
                capture.set(subscriptions != null ? subscriptions : Collections.emptySet());
                return null;
            }
        });
        return (Set)capture.get();
    }

    static void useServer(SocketAddress addr) {
        address = addr;
    }

    public void onCreate() {
        super.onCreate();
        if (Parse.applicationContext == null) {
            Parse.logE(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.stopSelf();
            return;
        }
        this.connection = new PushConnection(this, address);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        final PushConnection conn = this.connection;
        if (intent == null || intent.getAction() == null || intent.getAction().equals(START_IF_REQUIRED_ACTION)) {
            Parse.logI(TAG, "Received request to start service if required");
            ParsePushRouter.getSubscriptionsAsync().continueWith(new Continuation<Set<String>, Void>(){

                @Override
                public Void then(Task<Set<String>> task) {
                    Set<String> subscriptions = task.getResult();
                    if (subscriptions == null || subscriptions.size() == 0) {
                        PushService.this.stopSelf();
                    } else {
                        conn.start();
                    }
                    return null;
                }
            });
        } else if (intent.getAction().equals(START_ACTION)) {
            Parse.logI(TAG, "Received request to start service unconditionally");
            this.connection.start();
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    public void onDestroy() {
        if (this.connection != null) {
            this.connection.stop();
        }
        super.onDestroy();
    }
}

