/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import com.parse.Parse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PushRoutes {
    private static final String TAG = "com.parse.PushRoutes";
    private static final Pattern CHANNEL_PATTERN = Pattern.compile("^$|^[a-zA-Z][A-Za-z0-9_-]*$");
    private final HashMap<String, Route> channels = new HashMap();

    PushRoutes() {
    }

    public static PushRoutes newFromJSON(JSONObject json) {
        PushRoutes routes = new PushRoutes();
        if (json != null) {
            Route route;
            JSONObject defaultRoute;
            JSONObject jsonRoutes = json.optJSONObject("routes");
            if (jsonRoutes != null) {
                Iterator it = jsonRoutes.keys();
                while (it.hasNext()) {
                    String channel = (String)it.next();
                    Route route2 = Route.newFromJSON(jsonRoutes.optJSONObject(channel));
                    if (channel == null || route2 == null) continue;
                    routes.put(channel, route2);
                }
            }
            if ((defaultRoute = json.optJSONObject("default")) != null && (route = Route.newFromJSON(defaultRoute)) != null) {
                routes.put(null, route);
            }
        }
        return routes;
    }

    public synchronized JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        JSONObject namedRoutes = new JSONObject();
        for (Map.Entry<String, Route> channelRoute : this.channels.entrySet()) {
            String channel = channelRoute.getKey();
            Route route = channelRoute.getValue();
            if (channel == null) {
                json.put("default", (Object)route.toJSON());
                continue;
            }
            namedRoutes.put(channel, (Object)route.toJSON());
        }
        json.put("routes", (Object)namedRoutes);
        return json;
    }

    public synchronized Set<String> getChannels() {
        return Collections.unmodifiableSet(this.channels.keySet());
    }

    public synchronized Route get(String channel) {
        return this.channels.get(channel);
    }

    public synchronized Route put(String channel, Route route) {
        if (route == null) {
            throw new IllegalArgumentException("Can't insert null route");
        }
        if (channel != null && !CHANNEL_PATTERN.matcher(channel).matches()) {
            throw new IllegalArgumentException("invalid channel name: " + channel);
        }
        return this.channels.put(channel, route);
    }

    public synchronized Route remove(String channel) {
        return this.channels.remove(channel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Route {
        private final String activityClassName;
        private final int iconId;

        public static Route newFromJSON(JSONObject json) {
            JSONObject data;
            Route route = null;
            String activityClassName = null;
            int iconId = 0;
            if (json != null && (data = json.optJSONObject("data")) != null) {
                activityClassName = json.optString("activityClass", null);
                iconId = json.optInt("icon", 0);
            }
            if (activityClassName != null && iconId != 0) {
                route = new Route(activityClassName, iconId);
            }
            return route;
        }

        public Route(String activityClassName, int iconId) {
            if (activityClassName == null) {
                throw new IllegalArgumentException("activityClassName can't be null");
            }
            this.activityClassName = activityClassName;
            this.iconId = iconId;
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other != null && other instanceof Route) {
                Route that = (Route)other;
                result = this.activityClassName.equals(that.activityClassName) && this.iconId == that.iconId;
            }
            return result;
        }

        public int hashCode() {
            return 31 * (31 + this.activityClassName.hashCode()) + this.iconId;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " (activityClassName: " + this.activityClassName + " iconId: " + this.iconId + ")";
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("appName", (Object)Parse.getApplicationDisplayName());
            data.put("activityPackage", (Object)Parse.applicationContext.getPackageName());
            data.put("activityClass", (Object)this.activityClassName);
            data.put("icon", this.iconId);
            json.put("data", (Object)data);
            json.put("name", (Object)"StandardPushCallback");
            return json;
        }

        public Class<? extends Activity> getActivityClass() {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.activityClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null && !Activity.class.isAssignableFrom(clazz)) {
                clazz = null;
            }
            if (clazz == null) {
                Parse.logE(PushRoutes.TAG, "Activity class " + this.activityClassName + " registered to handle push no " + "longer exists. Call PushService.subscribe with an activity class that does exist.");
            }
            return clazz;
        }

        public int getIconId() {
            int actualIconId = 0;
            Context context = Parse.applicationContext;
            Resources resources = context.getResources();
            Drawable drawable2 = null;
            try {
                drawable2 = resources.getDrawable(this.iconId);
            }
            catch (Resources.NotFoundException e) {
                Parse.logD(PushRoutes.TAG, "Icon id " + this.iconId + " for " + this.activityClassName + " is not a drawable. " + "Using default activity icon instead.");
            }
            actualIconId = drawable2 != null ? this.iconId : Parse.getApplicationIconId();
            if (actualIconId == 0) {
                Parse.logE(PushRoutes.TAG, "Could not find valid icon id for this application. This is required to create a Notification object to show in the status bar in response to a push. Make sure that the <application> in your Manifest.xml has a valid android:icon attribute.");
            }
            return actualIconId;
        }
    }
}

