/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushHistory {
    private static final String TAG = "com.parse.PushHistory";
    private static final int HISTORY_LENGTH = 10;
    private final PriorityQueue<Entry> entries = new PriorityQueue(10);
    private final HashSet<String> pushIds = new HashSet(10);
    private String cutoff = null;
    private String lastTime = null;

    PushHistory() {
    }

    public static PushHistory newFromJSON(JSONObject json) {
        PushHistory history = new PushHistory();
        if (json != null) {
            history.setCutoffTimestamp(json.optString("ignoreAfter", null));
            history.setLastReceivedTimestamp(json.optString("lastTime", null));
            JSONObject jsonHistory = json.optJSONObject("history");
            if (jsonHistory != null) {
                Iterator it = jsonHistory.keys();
                while (it.hasNext()) {
                    String pushId = (String)it.next();
                    String timestamp = jsonHistory.optString(pushId, null);
                    if (pushId == null || timestamp == null) continue;
                    history.tryInsertPush(pushId, timestamp);
                }
            }
        }
        return history;
    }

    public synchronized JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        for (Entry e : this.entries) {
            json.put(e.pushId, (Object)e.timestamp);
        }
        if (this.cutoff != null) {
            json.put("ignoreAfter", (Object)this.cutoff);
        }
        if (this.lastTime != null) {
            json.put("lastTime", (Object)this.lastTime);
        }
        return json;
    }

    public synchronized String getCutoffTimestamp() {
        return this.cutoff;
    }

    public synchronized void setCutoffTimestamp(String cutoff) {
        this.cutoff = cutoff;
    }

    public synchronized String getLastReceivedTimestamp() {
        return this.lastTime;
    }

    public synchronized void setLastReceivedTimestamp(String lastTime) {
        this.lastTime = lastTime;
    }

    public synchronized Set<String> getPushIds() {
        return Collections.unmodifiableSet(this.pushIds);
    }

    public synchronized boolean tryInsertPush(String pushId, String timestamp) {
        if (pushId == null || timestamp == null) {
            throw new IllegalArgumentException("Can't insert null pushId or timestamp into history");
        }
        if (this.lastTime == null || timestamp.compareTo(this.lastTime) > 0) {
            this.lastTime = timestamp;
        }
        if (this.cutoff != null && timestamp.compareTo(this.cutoff) < 0) {
            Parse.logE(TAG, "Ignored old push " + pushId + " at " + timestamp + " before cutoff " + this.cutoff);
            return false;
        }
        if (this.pushIds.contains(pushId)) {
            Parse.logE(TAG, "Ignored duplicate push " + pushId);
            return false;
        }
        if (this.entries.size() == 10) {
            Entry head = (Entry)this.entries.remove();
            this.pushIds.remove(head.pushId);
            this.cutoff = head.timestamp;
        }
        this.entries.add(new Entry(pushId, timestamp));
        this.pushIds.add(pushId);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        public String pushId;
        public String timestamp;

        public Entry(String pushId, String timestamp) {
            this.pushId = pushId;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Entry other) {
            return this.timestamp.compareTo(other.timestamp);
        }
    }
}

