/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.parse.Continuation;
import com.parse.Parse;
import com.parse.ParseInstallation;
import com.parse.ParseNotificationManager;
import com.parse.ParseObject;
import com.parse.PushHistory;
import com.parse.PushRoutes;
import com.parse.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParsePushRouter {
    private static final String TAG = "com.parse.ParsePushRouter";
    private static final String LEGACY_ROUTE_LOCATION = "persistentCallbacks";
    private static final String STATE_LOCATION = "pushState";
    private static Task<Void> lastTask;
    private static PushListener pushListener;

    ParsePushRouter() {
    }

    private static synchronized Task<Void> getLastTask() {
        if (lastTask == null) {
            lastTask = Task.forResult(null).makeVoid();
        }
        return lastTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> subscribeAsync(final String channel, final Class<? extends Activity> cls, final int icon) {
        Task<Void> subscribeTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            subscribeTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    Router.getInstance().subscribe(channel, cls, icon);
                    return null;
                }
            });
            lastTask = subscribeTask;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return subscribeTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> unsubscribeAsync(final String channel) {
        Task<Void> unsubscribeTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            unsubscribeTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    Router.getInstance().unsubscribe(channel);
                    return null;
                }
            });
            lastTask = unsubscribeTask;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return unsubscribeTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Set<String>> getSubscriptionsAsync() {
        Task<Set<String>> getSubscriptionsTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            getSubscriptionsTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, Set<String>>(){

                @Override
                public Set<String> then(Task<Void> task) {
                    return Router.getInstance().getSubscriptions();
                }
            });
            lastTask = getSubscriptionsTask.makeVoid();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getSubscriptionsTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<JSONObject> getPushRequestJSONAsync() {
        Task<JSONObject> getPushRequestTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            getPushRequestTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, JSONObject>(){

                @Override
                public JSONObject then(Task<Void> task) {
                    return Router.getInstance().getPushRequestJSON();
                }
            });
            lastTask = getPushRequestTask.makeVoid();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getPushRequestTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Task<Void> handlePpnsPushAsync(final JSONObject pushData) {
        Task<Void> receivedPushTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            receivedPushTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    Router.getInstance().handlePpnsPush(pushData);
                    return null;
                }
            });
            lastTask = receivedPushTask;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return receivedPushTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Task<Void> reloadFromDiskAsync(final boolean removeExistingState) {
        Task<Void> reloadTask = null;
        Class<ParsePushRouter> clazz = ParsePushRouter.class;
        synchronized (ParsePushRouter.class) {
            reloadTask = ParsePushRouter.getLastTask().continueWith(new Continuation<Void, Void>(){

                @Override
                public Void then(Task<Void> task) {
                    Router.reloadInstance(removeExistingState);
                    return null;
                }
            });
            lastTask = reloadTask;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return reloadTask;
        }
    }

    static synchronized void setGlobalPushListener(PushListener listener) {
        pushListener = listener;
    }

    static interface PushListener {
        public void onPushRouted(JSONObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Router {
        private static Router instance;
        private final String stateLocation;
        private final PushRoutes routes;
        private final PushHistory history;

        private static Router getInstance() {
            if (instance == null) {
                Router.migrateVersion1to2();
                Router.migrateVersion2to3();
                instance = new Router(ParsePushRouter.STATE_LOCATION);
            }
            return instance;
        }

        private static Router reloadInstance(boolean removeExistingState) {
            ParseObject.deleteDiskObject(Parse.applicationContext, ParsePushRouter.STATE_LOCATION);
            ParseObject.deleteDiskObject(Parse.applicationContext, ParsePushRouter.LEGACY_ROUTE_LOCATION);
            instance = null;
            return Router.getInstance();
        }

        Router(String stateLocation) {
            JSONObject json = ParseObject.getDiskObject(Parse.applicationContext, stateLocation);
            this.stateLocation = stateLocation;
            this.routes = PushRoutes.newFromJSON(json);
            this.history = PushHistory.newFromJSON(json);
        }

        private static void migrateVersion1to2() {
            JSONObject legacyJSON = ParseObject.getDiskObject(Parse.applicationContext, ParsePushRouter.LEGACY_ROUTE_LOCATION);
            if (legacyJSON != null) {
                Parse.logD(ParsePushRouter.TAG, "Migrating push state from V1 to V3: " + legacyJSON);
                ArrayList<String> channels = new ArrayList<String>();
                Iterator keys = legacyJSON.keys();
                while (keys.hasNext()) {
                    channels.add((String)keys.next());
                }
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                installation.addAllUnique("channels", channels);
                installation.saveEventually();
                try {
                    JSONObject json = new JSONObject();
                    json.put("version", 3);
                    json.put("routes", (Object)legacyJSON);
                    json.put("channels", (Object)ParseInstallation.currentInstallation.getJSONArray("channels"));
                    ParseObject.saveDiskObject(Parse.applicationContext, ParsePushRouter.STATE_LOCATION, json);
                }
                catch (JSONException e) {
                    Parse.logE(ParsePushRouter.TAG, "Unexpected JSONException when serializing upgraded v1 push state: ", e);
                }
                ParseObject.deleteDiskObject(Parse.applicationContext, ParsePushRouter.LEGACY_ROUTE_LOCATION);
            }
        }

        private static void migrateVersion2to3() {
            JSONObject json = ParseObject.getDiskObject(Parse.applicationContext, ParsePushRouter.STATE_LOCATION);
            if (json != null && json.optInt("version") == 2) {
                JSONArray removeChannels;
                Parse.logD(ParsePushRouter.TAG, "Migrating push state from V2 to V3: " + json);
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                JSONArray addChannels = json.optJSONArray("addChannels");
                if (addChannels != null) {
                    ArrayList<String> toAdd = new ArrayList<String>();
                    int i = 0;
                    while (i < addChannels.length()) {
                        toAdd.add(addChannels.optString(i));
                        ++i;
                    }
                    installation.addAllUnique("channels", toAdd);
                }
                if ((removeChannels = json.optJSONArray("removeChannels")) != null) {
                    ArrayList<String> toRemove = new ArrayList<String>();
                    int i = 0;
                    while (i < removeChannels.length()) {
                        toRemove.add(removeChannels.optString(i));
                        ++i;
                    }
                    installation.removeAll("channels", toRemove);
                }
                if (json.has("installation")) {
                    installation.mergeAfterFetch(json.optJSONObject("installation"), true);
                }
                installation.saveEventually();
                try {
                    json.put("version", 3);
                    json.remove("addChannels");
                    json.remove("removeChannels");
                    json.remove("installation");
                    json.put("channels", (Object)ParseInstallation.currentInstallation.getJSONArray("channels"));
                    ParseObject.saveDiskObject(Parse.applicationContext, ParsePushRouter.STATE_LOCATION, json);
                }
                catch (JSONException e) {
                    Parse.logE(ParsePushRouter.TAG, "Unexpected JSONException when serializing upgraded v2 push state: ", e);
                }
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = Router.merge(this.routes.toJSON(), this.history.toJSON());
            json.put("version", 3);
            json.put("channels", (Object)ParseInstallation.getCurrentInstallation().getJSONArray("channels"));
            return json;
        }

        public boolean saveStateToDisk() {
            boolean success = false;
            try {
                JSONObject json = this.toJSON();
                ParseObject.saveDiskObject(Parse.applicationContext, this.stateLocation, json);
                success = true;
            }
            catch (JSONException e) {
                Parse.logE(ParsePushRouter.TAG, "Error serializing push state to json", e);
            }
            return success;
        }

        private static JSONObject merge(JSONObject ... objects) throws JSONException {
            JSONObject merged = new JSONObject();
            JSONObject[] jSONObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                JSONObject object = jSONObjectArray[n2];
                Iterator it = object.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = object.get(key);
                    merged.put(key, value);
                }
                ++n2;
            }
            return merged;
        }

        public JSONObject getPushRequestJSON() {
            JSONObject request = new JSONObject();
            ParseInstallation installation = ParseInstallation.getCurrentInstallation();
            try {
                request.put("installation_id", (Object)installation.getInstallationId());
                request.put("oauth_key", (Object)ParseObject.getApplicationId());
                request.put("v", (Object)"a1.3.5");
                String lastReceivedTimestamp = this.history.getLastReceivedTimestamp();
                request.put("last", lastReceivedTimestamp != null ? lastReceivedTimestamp : JSONObject.NULL);
                Set<String> pushIds = this.history.getPushIds();
                if (pushIds.size() > 0) {
                    request.put("last_seen", (Object)new JSONArray(pushIds));
                }
                request.putOpt("ignore_after", (Object)this.history.getCutoffTimestamp());
            }
            catch (JSONException e) {
                Parse.logE(ParsePushRouter.TAG, "Unexpected JSONException serializing push handshake", e);
                return null;
            }
            return request;
        }

        public void subscribe(String channel, Class<? extends Activity> cls, int icon) {
            PushRoutes.Route oldRoute;
            PushRoutes.Route route = new PushRoutes.Route(cls.getName(), icon);
            if (!route.equals(oldRoute = this.routes.put(channel, route))) {
                this.saveStateToDisk();
            }
            if (channel != null) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                installation.addUnique("channels", channel);
                installation.saveEventually();
            }
        }

        public void unsubscribe(String channel) {
            PushRoutes.Route oldRoute = this.routes.remove(channel);
            if (oldRoute != null) {
                this.saveStateToDisk();
            }
            if (channel != null) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                installation.removeAll("channels", Arrays.asList(channel));
                installation.saveEventually();
            }
        }

        public Set<String> getSubscriptions() {
            HashSet<String> subscriptions = new HashSet<String>();
            JSONArray channels = ParseInstallation.getCurrentInstallation().getJSONArray("channels");
            int i = 0;
            while (i < channels.length()) {
                subscriptions.add(channels.optString(i, null));
                ++i;
            }
            subscriptions.addAll(this.routes.getChannels());
            subscriptions.remove(null);
            return Collections.unmodifiableSet(subscriptions);
        }

        public void handlePpnsPush(JSONObject pushData) {
            String pushId = pushData.optString("push_id", null);
            String timestamp = pushData.optString("time", null);
            if (pushId == null) {
                Parse.logE(ParsePushRouter.TAG, "Ignoring PPNS push missing pushId");
            } else if (timestamp == null) {
                Parse.logE(ParsePushRouter.TAG, "Ignoring PPNS push missing timestamp");
            } else if (this.history.tryInsertPush(pushId, timestamp)) {
                this.handlePush(pushData);
                this.saveStateToDisk();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handlePush(JSONObject pushData) {
            PushRoutes.Route route;
            String channel = pushData.optString("channel", null);
            Bundle extras = new Bundle();
            extras.putString("com.parse.Data", pushData.toString());
            extras.putString("com.parse.Channel", channel);
            if (pushData.has("action")) {
                Intent broadcastIntent = new Intent();
                broadcastIntent.putExtras(extras);
                broadcastIntent.setAction(pushData.optString("action"));
                Parse.applicationContext.sendBroadcast(broadcastIntent);
                if (!pushData.has("alert") && !pushData.has("title")) {
                    return;
                }
            }
            if ((route = this.routes.get(channel)) == null && channel != null) {
                route = this.routes.get(null);
            }
            if (route == null) {
                Parse.logW(ParsePushRouter.TAG, "Received push that has no handler. Did you call PushService.setDefaultPushCallback or PushService.subscribe? Push data: " + pushData);
                return;
            }
            Class<? extends Activity> cls = route.getActivityClass();
            int iconId = route.getIconId();
            String title = pushData.optString("title", Parse.getApplicationDisplayName());
            String body = pushData.optString("alert", "Notification received.");
            if (iconId == 0) {
                Parse.logE(ParsePushRouter.TAG, "Ignoring push associated with route " + route + " because iconId is invalid.");
                return;
            }
            if (title == null) {
                Parse.logE(ParsePushRouter.TAG, "Ignoring push " + pushData + " because no title could be found.");
                return;
            }
            Context context = Parse.applicationContext;
            ParseNotificationManager.showNotification(context, title, body, extras, cls, iconId);
            Class<ParsePushRouter> clazz = ParsePushRouter.class;
            synchronized (ParsePushRouter.class) {
                if (pushListener == null) return;
                pushListener.onPushRouted(pushData);
                // ** MonitorExit[var10_10] (shouldn't be in output)
                return;
            }
        }
    }
}

