/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.parse.Parse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseNotificationManager {
    public static final String TAG = "com.parse.ParseNotificationManager";
    public static boolean ENABLE_NOTIFICATIONS = true;

    ParseNotificationManager() {
    }

    public static Notification newNotification(Context context, String title, String body, Bundle extras, Class<? extends Activity> cls, int iconId) {
        Notification notification = null;
        if (context == null || title == null || body == null || cls == null || iconId == 0) {
            Parse.logE(TAG, "Must specify non-zero iconId and non-null pushData, title, body, and activity class to show notification.");
        } else {
            long when = System.currentTimeMillis();
            ComponentName name = new ComponentName(context, cls);
            Intent intent = new Intent();
            intent.setComponent(name);
            intent.setFlags(0x10000000);
            if (extras != null) {
                intent.putExtras(extras);
            }
            PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)((int)when), (Intent)intent, (int)0);
            notification = new Notification(iconId, (CharSequence)body, when);
            notification.flags |= 0x10;
            notification.defaults |= 0xFFFFFFFF;
            notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)body, contentIntent);
        }
        return notification;
    }

    public static void showNotification(Context context, Notification notification) {
        if (ENABLE_NOTIFICATIONS && context != null && notification != null) {
            NotificationManager nm = (NotificationManager)context.getSystemService("notification");
            int notificationId = (int)System.currentTimeMillis();
            try {
                nm.notify(notificationId, notification);
            }
            catch (SecurityException e) {
                notification.defaults = 5;
                nm.notify(notificationId, notification);
            }
        }
    }

    public static void showNotification(Context context, String title, String body, Bundle extras, Class<? extends Activity> cls, int iconId) {
        ParseNotificationManager.showNotification(context, ParseNotificationManager.newNotification(context, title, body, extras, cls, iconId));
    }
}

