/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseUser;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";

    public static void trackAppOpened(Intent intent) {
        String parseData = null;
        if (intent != null && intent.getExtras() != null) {
            parseData = intent.getExtras().getString("com.parse.Data");
        }
        ParseAnalytics.trackAppOpened(parseData);
    }

    public static void trackEvent(String name) {
        ParseAnalytics.trackEvent(name, null);
    }

    public static void trackEvent(String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("A name for the custom event must be provided.");
        }
        ParseCommand command = new ParseCommand("client_events", ParseUser.getCurrentSessionToken());
        command.put("at", Parse.dateToObject(new Date()));
        command.put("name", name);
        if (dimensions != null) {
            JSONObject jsonDimensions = Parse.encodeJSONObject(dimensions, false);
            command.put("dimensions", jsonDimensions);
        }
        Parse.getCommandCache().runEventuallyAsync(command, null);
    }

    private static void trackAppOpened(String pushData) {
        ParseCommand command = new ParseCommand("client_app_opened", ParseUser.getCurrentSessionToken());
        command.put("at", Parse.dateToObject(new Date()));
        if (pushData != null) {
            try {
                JSONObject payload = new JSONObject(pushData);
                String pushHash = payload.optString("push_hash");
                if (pushHash.length() > 0) {
                    command.put("push_hash", pushHash);
                }
            }
            catch (JSONException e) {
                Parse.logE(TAG, "Failed to parse push data: " + e.getMessage());
            }
        }
        Parse.getCommandCache().runEventuallyAsync(command, null);
    }
}

