/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.parse.PushCallback;
import org.json.JSONObject;

public class StandardPushCallback
extends PushCallback {
    static int totalNotifications = 0;
    static boolean disableNotifications = false;

    private Bundle makeBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("com.parse.Data", this.pushData.toString());
        bundle.putString("com.parse.Channel", this.channel);
        return bundle;
    }

    public void run() {
        ++totalNotifications;
        if (disableNotifications) {
            return;
        }
        if (this.pushData == null) {
            this.pushData = new JSONObject();
        }
        if (this.pushData.has("action")) {
            Intent broadcastIntent = new Intent();
            broadcastIntent.putExtras(this.makeBundle());
            broadcastIntent.setAction(this.pushData.optString("action"));
            this.service.getBaseContext().sendBroadcast(broadcastIntent);
            if (!this.pushData.has("alert") && !this.pushData.has("title")) {
                return;
            }
        }
        String text = this.pushData.optString("alert", "Notification received.");
        String title = this.pushData.optString("title", this.localData.optString("appName"));
        long when = System.currentTimeMillis();
        ComponentName componentName = new ComponentName(this.localData.optString("activityPackage"), this.localData.optString("activityClass"));
        Intent intent = new Intent();
        intent.setComponent(componentName);
        intent.setFlags(0x10000000);
        intent.putExtras(this.makeBundle());
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.service, (int)((int)when), (Intent)intent, (int)0);
        Notification notif = new Notification(this.localData.optInt("icon"), (CharSequence)text, when);
        notif.flags |= 0x10;
        notif.defaults |= 0xFFFFFFFF;
        notif.setLatestEventInfo((Context)this.service, (CharSequence)title, (CharSequence)text, contentIntent);
        NotificationManager nm = (NotificationManager)this.service.getSystemService("notification");
        int notificationId = (int)when;
        try {
            nm.notify(notificationId, notif);
        }
        catch (SecurityException e) {
            notif.defaults = 5;
            nm.notify(notificationId, notif);
        }
    }
}

