/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ProgressCallback;
import com.parse.Task;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseRequestRetryer {
    private HttpClient client;
    private HttpUriRequest request;
    private long delay;
    private int maxAttempts;
    private int attemptsMade = 0;
    public static HttpClient testClient = null;

    public ParseRequestRetryer(HttpUriRequest newRequest, long initialDelay, int newMaxAttempts) {
        if (testClient != null) {
            this.client = testClient;
            initialDelay = 1L;
        } else {
            this.client = new DefaultHttpClient();
            this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        }
        this.request = newRequest;
        this.maxAttempts = newMaxAttempts;
        this.delay = initialDelay + (long)((double)initialDelay * Math.random());
    }

    private Task<byte[]> sendOneRequestAsync(final ProgressCallback progressCallback) {
        return Task.call(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                HttpResponse response;
                try {
                    response = ParseRequestRetryer.this.client.execute(ParseRequestRetryer.this.request);
                    if (ParseRequestRetryer.this.request.getMethod().equals("GET")) {
                        int nRead;
                        int totalSize = -1;
                        Header[] contentLengthHeader = response.getHeaders("Content-Length");
                        if (contentLengthHeader.length > 0) {
                            totalSize = Integer.parseInt(contentLengthHeader[0].getValue());
                        }
                        int downloadedSize = 0;
                        InputStream responseStream = response.getEntity().getContent();
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[32768];
                        while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, nRead);
                            downloadedSize += nRead;
                            if (progressCallback == null || totalSize == -1) continue;
                            int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                            Parse.callbackOnMainThreadAsync(Task.forResult(progressToReport), progressCallback);
                        }
                        buffer.flush();
                        return buffer.toByteArray();
                    }
                }
                catch (ClientProtocolException e) {
                    ParseRequestRetryer.this.client.getConnectionManager().shutdown();
                    throw ParseRequestRetryer.this.connectionFailed("bad protocol", (Exception)((Object)e));
                }
                catch (IOException e) {
                    ParseRequestRetryer.this.client.getConnectionManager().shutdown();
                    throw ParseRequestRetryer.this.connectionFailed("i/o failure", e);
                }
                if (response.getStatusLine().getStatusCode() / 100 != 2) {
                    throw new ParseException(100, String.format("Upload to S3 failed. %s", response.getStatusLine().getReasonPhrase()));
                }
                return null;
            }
        }, ParseCommand.networkThreadPool);
    }

    public Task<byte[]> goAsync(final ProgressCallback progressCallback) {
        return this.sendOneRequestAsync(progressCallback).continueWithTask(new Continuation<byte[], Task<byte[]>>(){

            @Override
            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                if (task.isFaulted() && task.getError() instanceof ParseException) {
                    ParseRequestRetryer.this.attemptsMade++;
                    if (ParseRequestRetryer.this.attemptsMade < ParseRequestRetryer.this.maxAttempts) {
                        Parse.logI("com.parse.ParseRequestRetryer", "Request failed. Waiting " + ParseRequestRetryer.this.delay + " milliseconds before attempt #" + (ParseRequestRetryer.this.attemptsMade + 1));
                        final Task.TaskCompletionSource retryTask = Task.create();
                        ParseCommand.networkThreadPool.schedule(new Runnable(){

                            public void run() {
                                ParseRequestRetryer.this.delay *= 2L;
                                ParseRequestRetryer.this.goAsync(progressCallback).continueWithTask(new Continuation<byte[], Task<Void>>(){

                                    @Override
                                    public Task<Void> then(Task<byte[]> task) throws Exception {
                                        if (task.isCancelled()) {
                                            retryTask.setCancelled();
                                        } else if (task.isFaulted()) {
                                            retryTask.setError(task.getError());
                                        } else {
                                            retryTask.setResult(task.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }, ParseRequestRetryer.this.delay, TimeUnit.MILLISECONDS);
                        return retryTask.getTask();
                    }
                    if (!ParseRequestRetryer.this.request.isAborted()) {
                        Parse.logI("com.parse.ParseRequestRetryer", "Request failed. Giving up.");
                    }
                }
                return task;
            }
        });
    }

    ParseException connectionFailed(String message, Exception e) {
        return new ParseException(100, message + ": " + e.getClass().getName() + ": " + e.getMessage());
    }
}

