/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.parse.Continuation;
import com.parse.Parse;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.SaveCallback;
import com.parse.Task;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseInstallation
extends ParseObject {
    private static final String TAG = "com.parse.ParseInstallation";
    static final String CLASS_NAME = "_Installation";
    static ParseInstallation currentInstallation = null;
    private static final String STORAGE_LOCATION = "currentInstallation";
    private static final List<String> readonlyFields = Arrays.asList("deviceType", "installationId", "deviceToken", "timeZone", "appVersion", "appName", "parseVersion");

    ParseInstallation(boolean isPointer) {
        super(CLASS_NAME, isPointer);
        if (!isPointer) {
            super.put("deviceType", "android");
            super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
        }
    }

    ParseInstallation() {
        this(false);
    }

    public static synchronized ParseInstallation getCurrentInstallation() {
        if (currentInstallation != null) {
            return currentInstallation;
        }
        ParseObject installation = ParseInstallation.getFromDisk(Parse.applicationContext, STORAGE_LOCATION);
        if (installation == null) {
            currentInstallation = new ParseInstallation();
        } else {
            currentInstallation = (ParseInstallation)installation;
            Parse.logV(TAG, "Successfully deserialized Installation object");
        }
        return currentInstallation;
    }

    public static ParseQuery getQuery() {
        return new ParseQuery(CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getOrCreateCurrentInstallationId() {
        String string2;
        if (currentInstallation != null) {
            return currentInstallation.getInstallationId();
        }
        File installationIdFile = new File(Parse.getParseDir(), "installationId");
        RandomAccessFile f = null;
        try {
            if (!installationIdFile.exists()) {
                String uuid = UUID.randomUUID().toString();
                f = new RandomAccessFile(installationIdFile, "rw");
                f.writeBytes(uuid);
                f.close();
                String string3 = uuid;
                return string3;
            }
            Parse.logV(TAG, "Reading legacy file for installation ID");
            f = new RandomAccessFile(installationIdFile, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            string2 = new String(bytes);
        }
        catch (IOException e) {
            String string4 = UUID.randomUUID().toString();
            return string4;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
        return string2;
    }

    public String getInstallationId() {
        return this.getString("installationId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkKeyIsMutable(String key) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            if (readonlyFields.contains(key)) {
                throw new IllegalArgumentException("Cannot change " + key + " property of an installation object.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkKeyIsMutable(key);
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkKeyIsMutable(key);
            super.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<Void> saveAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTimezone();
            this.updateVersionInfo();
            super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
            super.put("deviceType", "android");
            return super.saveAsync(toAwait).onSuccessTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseInstallation.maybeFlushToDisk(ParseInstallation.this);
                    return task;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEventually(SaveCallback callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTimezone();
            this.updateVersionInfo();
            super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
            super.put("deviceType", "android");
            super.saveEventually(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<ParseObject> fetchAsync(final Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Object> result = this.getObjectId() == null ? this.saveAsync(toAwait) : Task.forResult(null);
            return result.onSuccessTask(new Continuation<Void, Task<ParseObject>>(){

                @Override
                public Task<ParseObject> then(Task<Void> task) throws Exception {
                    return ParseInstallation.super.fetchAsync(toAwait);
                }
            }).continueWithTask(new Continuation<ParseObject, Task<ParseObject>>(){

                @Override
                public Task<ParseObject> then(Task<ParseObject> task) throws Exception {
                    ParseInstallation.maybeFlushToDisk(ParseInstallation.this);
                    return task;
                }
            });
        }
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if ((zone.indexOf(47) > 0 || zone.equals("GMT")) && !zone.equals(this.get("timeZone"))) {
            super.put("timeZone", zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionInfo() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                String packageName = Parse.applicationContext.getPackageName();
                PackageManager pm = Parse.applicationContext.getPackageManager();
                PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                String appVersion = pkgInfo.versionName;
                String appName = ((Object)pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0))).toString();
                if (appName != null && !appName.equals(this.get("appName"))) {
                    super.put("appName", appName);
                }
                if (appVersion != null & !appVersion.equals(this.get("appVersion"))) {
                    super.put("appVersion", appVersion);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Parse.logW(TAG, "Cannot load package info; will not be saved to installation");
            }
            if (!"1.2.4".equals(this.get("parseVersion"))) {
                super.put("parseVersion", "1.2.4");
            }
        }
    }

    private static synchronized void maybeFlushToDisk(ParseInstallation installation) {
        if (currentInstallation == installation) {
            installation.saveToDisk(Parse.applicationContext, STORAGE_LOCATION);
        }
    }

    static synchronized void clearCurrentInstallationFromDisk(Context context) {
        currentInstallation = null;
        ParseObject.deleteDiskObject(context, STORAGE_LOCATION);
    }
}

