/*
 * Decompiled with CFR 0.152.
 */
package com.parse.signpost.commonshttp;

import com.parse.signpost.http.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestAdapter
implements HttpRequest {
    private HttpUriRequest request;
    private HttpEntity entity;

    public HttpRequestAdapter(HttpUriRequest request) {
        this.request = request;
        if (request instanceof HttpEntityEnclosingRequest) {
            this.entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
    }

    @Override
    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    @Override
    public String getRequestUrl() {
        return this.request.getURI().toString();
    }

    @Override
    public void setRequestUrl(String url) {
        throw new RuntimeException(new UnsupportedOperationException());
    }

    @Override
    public String getHeader(String name) {
        Header header = this.request.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        Header[] origHeaders = this.request.getAllHeaders();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header h : origHeaders) {
            headers.put(h.getName(), h.getValue());
        }
        return headers;
    }

    @Override
    public String getContentType() {
        if (this.entity == null) {
            return null;
        }
        Header header = this.entity.getContentType();
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public InputStream getMessagePayload() throws IOException {
        if (this.entity == null) {
            return null;
        }
        return this.entity.getContent();
    }

    @Override
    public Object unwrap() {
        return this.request;
    }
}

