/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import com.parse.BackgroundTask;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParsePushRouter;
import com.parse.PushConnection;
import com.parse.os.ParseAsyncTask;
import java.io.IOException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    private static String pushServer = "push.parse.com";
    private static int defaultPushPort = 8253;
    static PushConnection connection;
    private ParseAsyncTask<Void, Void, String> task;
    private static int delaySeconds;
    private ServiceState state = ServiceState.STOPPED;
    private Timer keepAliveTimer = null;
    static int consecutiveFailures;
    static Semaphore sleepSemaphore;

    private static synchronized void startService(Context context) {
        Parse.logD(TAG, "ensuring push service is started");
        ComponentName name = context.startService(new Intent(context, PushService.class));
        if (name == null) {
            Parse.logE(TAG, "Could not start the push service. Make sure that the XML tag <service android:name=\"com.parse.PushService\" /> is in your AndroidManifest.xml as a child of the <application> element.");
        }
    }

    public static void startServiceIfRequired(final Context context) {
        new BackgroundTask<Void>(null){

            @Override
            public Void run() throws ParseException {
                if (!ParsePushRouter.hasRoutes(context)) {
                    Parse.logW(PushService.TAG, "No known push routes; will not start push service");
                } else {
                    PushService.startService(context);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    public static void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.subscribe(context, channel, cls, info.icon);
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls, int icon) {
        PushService.startService(context);
        ParsePushRouter.addChannelRoute(context, channel, cls, icon);
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        ParsePushRouter.removeChannelRoute(context, channel);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.setDefaultPushCallback(context, cls, info.icon);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls, int icon) {
        ParsePushRouter.setDefaultRoute(context, cls, icon);
        if (cls != null) {
            PushService.startService(context);
        } else if (!ParsePushRouter.hasRoutes(context)) {
            Parse.logD(TAG, "Shutting down push service. No remaining channels");
            context.stopService(new Intent(context, PushService.class));
        }
    }

    public static synchronized Set<String> getSubscriptions(Context context) {
        return ParsePushRouter.getSubscriptions(context);
    }

    static void sleep(int millis) throws InterruptedException {
        Semaphore semaphore = sleepSemaphore;
        if (semaphore == null) {
            Thread.sleep(millis);
        } else {
            while (millis > 100) {
                semaphore.acquire(100);
                millis -= 100;
            }
            semaphore.acquire(millis);
        }
    }

    static void useServer(String newServer) {
        pushServer = newServer;
    }

    static void usePort(int newPort) {
        defaultPushPort = newPort;
    }

    static void resetDelay() {
        delaySeconds = 0;
        consecutiveFailures = 0;
    }

    private void increaseDelay() {
        ++consecutiveFailures;
        delaySeconds = (int)((double)delaySeconds * (1.5 + Math.random() / 2.0));
        delaySeconds = Math.max(15, delaySeconds);
        delaySeconds = Math.min(delaySeconds, 300);
    }

    public void onCreate() {
        super.onCreate();
        if (Parse.applicationContext == null) {
            Parse.logE(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.state = ServiceState.ABORTING;
            this.stopSelf();
            return;
        }
        this.state = ServiceState.RUNNING;
        Parse.logD(TAG, "creating push service");
        Timer newTimer = new Timer("com.parse.PushService.keepAliveTimer", true);
        long msKeepAlive = 1200000L;
        newTimer.schedule(new TimerTask(){

            public void run() {
                PushService.this.sendKeepAlive();
            }
        }, msKeepAlive, msKeepAlive);
        this.keepAliveTimer = newTimer;
        PushService.resetDelay();
        connection = new PushConnection((Context)this);
        this.readInBackground(true);
    }

    static boolean sendMessage(String message) {
        return connection.trySend(message);
    }

    private static boolean sendSubscriptionInformation(Context context) {
        JSONObject request = ParsePushRouter.getPushRequestJSON(context);
        return PushService.sendMessage(request.toString());
    }

    private void sendKeepAlive() {
        PushService.sendMessage("{}");
    }

    private void readInBackground(final boolean forceReconnect) {
        final PushService finalService = this;
        if (this.state == ServiceState.DESTRUCTING) {
            return;
        }
        this.task = new ParseAsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... v) {
                if (forceReconnect) {
                    if (delaySeconds > 0) {
                        try {
                            Parse.logI(PushService.TAG, "sleeping for " + delaySeconds + " seconds");
                            PushService.sleep(delaySeconds * 1000);
                        }
                        catch (InterruptedException e) {
                            Parse.logV(PushService.TAG, "Push backoff sleep interrupted", e);
                            return null;
                        }
                    }
                    PushService.this.increaseDelay();
                }
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    return null;
                }
                connection.connect(pushServer, defaultPushPort, forceReconnect);
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    return null;
                }
                if (forceReconnect && !PushService.sendSubscriptionInformation((Context)finalService)) {
                    return null;
                }
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    return null;
                }
                try {
                    Parse.logD(PushService.TAG, "waiting for a push");
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    String line = connection.readLine();
                    PushService.resetDelay();
                    return line;
                }
                catch (IOException e) {
                    Parse.logV(PushService.TAG, "Network disconnect; will reconnect to the push service shortly.", e);
                    return null;
                }
            }

            @Override
            protected void onPostExecute(String line) {
                JSONObject message;
                Parse.logV(PushService.TAG, "Post execute: " + line);
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    PushService.this.state = ServiceState.STOPPED;
                    return;
                }
                if (line == null) {
                    PushService.this.readInBackground(true);
                    return;
                }
                JSONTokener tokener = new JSONTokener(line);
                try {
                    message = new JSONObject(tokener);
                }
                catch (JSONException e) {
                    Parse.logE(PushService.TAG, "bad json: " + line, e);
                    PushService.this.readInBackground(false);
                    return;
                }
                ParsePushRouter.routePush(finalService, message);
                PushService.this.readInBackground(false);
            }
        };
        this.task.execute((Void[])new Void[0]);
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    public void onDestroy() {
        super.onDestroy();
        Parse.logD(TAG, "destroying push service");
        if (this.state == ServiceState.ABORTING) {
            this.state = ServiceState.STOPPED;
            return;
        }
        this.task.cancel(true);
        this.keepAliveTimer.cancel();
        this.state = ServiceState.DESTRUCTING;
        connection.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServiceState {
        STOPPED,
        ABORTING,
        DESTRUCTING,
        RUNNING;

    }
}

