/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.LocalIdManager;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseUser;
import com.parse.Task;
import com.parse.codec.digest.DigestUtils;
import com.parse.signpost.commonshttp.CommonsHttpOAuthConsumer;
import com.parse.signpost.exception.OAuthCommunicationException;
import com.parse.signpost.exception.OAuthExpectationFailedException;
import com.parse.signpost.exception.OAuthMessageSignerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseCommand {
    static final ScheduledExecutorService networkThreadPool = Executors.newScheduledThreadPool(5);
    String op;
    JSONObject params;
    private String localId;
    private final String sessionToken;
    private HttpClient client;
    private HttpPost post;
    private boolean retryEnabled = false;
    private int attemptsMade = 0;
    private long delay = 0L;
    private AtomicReference<Task.TaskCompletionSource> currentTask = new AtomicReference();
    private static int SOCKET_TIMEOUT = 10000;
    private static int CONNECTION_TIMEOUT = 10000;
    private static int INITIAL_DELAY = 1000;

    ParseCommand(String theOp, HttpClient httpClient, String sessionToken) {
        this.op = theOp;
        this.params = new JSONObject();
        this.client = httpClient;
        this.sessionToken = sessionToken;
        this.maybeSetupHttpProxy();
    }

    ParseCommand(String theOp, String sessionToken) {
        this.op = theOp;
        this.params = new JSONObject();
        this.sessionToken = sessionToken;
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)CONNECTION_TIMEOUT);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)SOCKET_TIMEOUT);
        this.client = new DefaultHttpClient((HttpParams)httpParameters);
        this.maybeSetupHttpProxy();
    }

    ParseCommand(JSONObject json) throws JSONException {
        this.op = json.getString("op");
        this.params = json.getJSONObject("params");
        this.localId = json.optString("localId", null);
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)CONNECTION_TIMEOUT);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)SOCKET_TIMEOUT);
        this.client = new DefaultHttpClient((HttpParams)httpParameters);
        this.maybeSetupHttpProxy();
        this.sessionToken = json.has("session_token") ? json.getString("session_token") : ParseUser.getCurrentSessionToken();
    }

    void put(String key, String value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, int value) {
        try {
            this.params.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, long value) {
        try {
            this.params.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, JSONArray value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, JSONObject value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void setOp(String theOp) {
        this.op = theOp;
    }

    String getLocalId() {
        return this.localId;
    }

    void setLocalId(String theLocalId) {
        this.localId = theLocalId;
    }

    JSONObject toJSONObject() {
        try {
            JSONObject answer = new JSONObject();
            answer.put("op", (Object)this.op);
            answer.put("params", (Object)this.params);
            if (this.localId != null) {
                answer.put("localId", (Object)this.localId);
            }
            answer.put("session_token", this.sessionToken != null ? this.sessionToken : JSONObject.NULL);
            return answer;
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    String getCacheKey() {
        String json;
        try {
            json = ParseCommand.toDeterministicString(this.params);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.sessionToken != null) {
            json = json + this.sessionToken;
        }
        return "ParseCommand." + this.op + "." + "2" + "." + DigestUtils.md5Hex(json);
    }

    static String toDeterministicString(Object o) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        ParseCommand.addToStringer(stringer, o);
        return stringer.toString();
    }

    static void addToStringer(JSONStringer stringer, Object o) throws JSONException {
        if (o instanceof JSONObject) {
            stringer.object();
            JSONObject object = (JSONObject)o;
            Iterator keyIterator = object.keys();
            ArrayList keys = new ArrayList();
            while (keyIterator.hasNext()) {
                keys.add(keyIterator.next());
            }
            Collections.sort(keys);
            for (String key : keys) {
                stringer.key(key);
                ParseCommand.addToStringer(stringer, object.opt(key));
            }
            stringer.endObject();
            return;
        }
        if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            stringer.array();
            for (int i = 0; i < array.length(); ++i) {
                ParseCommand.addToStringer(stringer, array.get(i));
            }
            stringer.endArray();
            return;
        }
        stringer.value(o);
    }

    Task<Object> performAsync() {
        return this.performAsync(false);
    }

    ParseException connectionFailed(String message, Exception e) {
        return new ParseException(100, message + ": " + e.getClass().getName() + ": " + e.getMessage());
    }

    void preparePost() throws ParseException {
        Iterator keys = this.params.keys();
        JSONObject fullParams = new JSONObject();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                fullParams.put(key, this.params.get(key));
            }
            fullParams.put("v", (Object)"a1.1.15");
            fullParams.put("iid", (Object)ParseInstallation.getCurrentInstallation().getInstallationId());
            fullParams.put("uuid", (Object)UUID.randomUUID().toString());
            if (this.sessionToken != null) {
                fullParams.put("session_token", (Object)this.sessionToken);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        String url = String.format("%s/%s/%s", ParseObject.server, "2", this.op);
        this.post = new HttpPost(url);
        try {
            StringEntity entity = new StringEntity(fullParams.toString(), "UTF8");
            entity.setContentType("application/json");
            this.post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(Parse.applicationId, Parse.clientKey);
        consumer.setTokenWithSecret(null, "");
        try {
            consumer.sign(this.post);
        }
        catch (OAuthMessageSignerException e) {
            throw new ParseException(109, e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new ParseException(109, e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new ParseException(109, e.getMessage());
        }
    }

    Task<Object> performAsync(final boolean saveToCache) {
        Parse.checkInit();
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTask.set(tcs);
        Task.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ParseCommand.this.resolveLocalIds();
                if (ParseCommand.this.post == null || !ParseCommand.this.post.getURI().getHost().equals(ParseObject.server)) {
                    ParseCommand.this.preparePost();
                }
                return null;
            }
        }).continueWithTask(new Continuation<Void, Task<JSONObject>>(){

            @Override
            public Task<JSONObject> then(Task<Void> task) throws Exception {
                return ParseCommand.this.sendRequestWithRetriesAsync();
            }
        }).onSuccess(new Continuation<JSONObject, Object>(){

            @Override
            public Object then(Task<JSONObject> task) throws Exception {
                Object answer;
                JSONObject result = task.getResult();
                try {
                    if (result.has("error")) {
                        throw new ParseException(result.getInt("code"), result.getString("error"));
                    }
                    answer = result.get("result");
                }
                catch (JSONException e) {
                    throw ParseCommand.this.connectionFailed("corrupted json", (Exception)((Object)e));
                }
                if (saveToCache) {
                    Parse.saveToKeyValueCache(ParseCommand.this.getCacheKey(), answer.toString());
                }
                return answer;
            }
        }).continueWithTask(new Continuation<Object, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Object> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else if (task.isFaulted()) {
                    tcs.trySetError(task.getError());
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return null;
            }
        });
        return tcs.getTask();
    }

    private Task<JSONObject> sendRequestWithRetriesAsync() {
        return this.sendRequestAsync(this.client, this.post).continueWithTask(new Continuation<JSONObject, Task<JSONObject>>(){

            @Override
            public Task<JSONObject> then(Task<JSONObject> task) {
                if (((Task.TaskCompletionSource)ParseCommand.this.currentTask.get()).getTask().isCancelled()) {
                    return Task.cancelled();
                }
                ParseCommand.this.attemptsMade++;
                if (task.isFaulted() && task.getError() instanceof ParseException && ParseCommand.this.retryEnabled && ParseCommand.this.attemptsMade < 5) {
                    Parse.logI("com.parse.ParseCommand", "Fetch failed. Waiting " + ParseCommand.this.delay + " milliseconds before attempt #" + (ParseCommand.this.attemptsMade + 1));
                    final Task.TaskCompletionSource delayTaskSource = Task.create();
                    networkThreadPool.schedule(new Runnable(){

                        public void run() {
                            delayTaskSource.setResult(null);
                        }
                    }, ParseCommand.this.delay, TimeUnit.MILLISECONDS);
                    return delayTaskSource.getTask().continueWithTask(new Continuation<Void, Task<JSONObject>>(){

                        @Override
                        public Task<JSONObject> then(Task<Void> task) {
                            ParseCommand.this.calculateNextDelay();
                            return ParseCommand.this.sendRequestWithRetriesAsync();
                        }
                    });
                }
                return task;
            }
        });
    }

    private void maybeSetupHttpProxy() {
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host == null || host.length() == 0 || portString == null || portString.length() == 0) {
            return;
        }
        int port = Integer.parseInt(portString);
        HttpHost proxy = new HttpHost(host, port, "http");
        this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    private Task<JSONObject> sendRequestAsync(final HttpClient client, final HttpPost post) {
        if (this.currentTask.get().getTask().isCancelled()) {
            return Task.cancelled();
        }
        return Task.call(new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                JSONObject result;
                String json;
                try {
                    HttpResponse rawResponse = client.execute((HttpUriRequest)post);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(rawResponse.getEntity().getContent(), "UTF-8"), 8192);
                    json = reader.readLine();
                }
                catch (ClientProtocolException e) {
                    throw ParseCommand.this.connectionFailed("bad protocol", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw ParseCommand.this.connectionFailed("i/o failure", e);
                }
                try {
                    JSONTokener tokener = new JSONTokener(json);
                    result = new JSONObject(tokener);
                }
                catch (JSONException e) {
                    throw ParseCommand.this.connectionFailed("bad json response", (Exception)((Object)e));
                }
                return result;
            }
        }, networkThreadPool);
    }

    private void calculateNextDelay() {
        this.delay *= 2L;
    }

    public void enableRetrying() {
        this.retryEnabled = true;
        this.delay = (long)INITIAL_DELAY + (long)((double)INITIAL_DELAY * Math.random());
    }

    public static void setInitialDelay(double seconds) {
        INITIAL_DELAY = (int)(seconds * 1000.0);
    }

    public void cancel() {
        Task.TaskCompletionSource curr = this.currentTask.get();
        if (curr != null) {
            curr.trySetCancelled();
        }
        if (this.post != null) {
            this.post.abort();
        }
    }

    private static void getLocalPointersIn(Object container, ArrayList<JSONObject> localPointers) throws JSONException {
        if (container instanceof JSONObject) {
            JSONObject object = (JSONObject)container;
            if ("Pointer".equals(object.opt("__type")) && object.has("localId")) {
                localPointers.add((JSONObject)container);
                return;
            }
            Iterator keyIterator = object.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                ParseCommand.getLocalPointersIn(object.get(key), localPointers);
            }
        }
        if (container instanceof JSONArray) {
            JSONArray array = (JSONArray)container;
            for (int i = 0; i < array.length(); ++i) {
                ParseCommand.getLocalPointersIn(array.get(i), localPointers);
            }
        }
    }

    public void maybeChangeServerOperation() throws JSONException {
        String objectId;
        if (this.localId != null && (objectId = LocalIdManager.getDefaultInstance().getObjectId(this.localId)) != null) {
            this.localId = null;
            JSONObject data = this.params.optJSONObject("data");
            if (data != null) {
                data.put("objectId", (Object)objectId);
            }
            if (this.op.equals("create")) {
                this.op = "update";
            }
        }
    }

    public void resolveLocalIds() {
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                String objectId = LocalIdManager.getDefaultInstance().getObjectId(localId);
                if (objectId == null) {
                    throw new IllegalStateException("Tried to serialize a command referencing a new, unsaved object.");
                }
                pointer.put("objectId", (Object)objectId);
                pointer.remove("localId");
            }
            this.maybeChangeServerOperation();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void retainLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(this.localId);
        }
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void releaseLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(this.localId);
        }
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static interface InternalCallback {
        public void perform(ParseCommand var1, Object var2);
    }
}

