/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import com.parse.Continuation;
import com.parse.CountingMultipartEntity;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseRequestRetryer;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.Task;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.content.ByteArrayBody;
import com.parse.entity.mime.content.StringBody;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFile {
    private String name = null;
    private String url = null;
    private byte[] data;
    private ParseCommand currentCommand = null;
    private HttpPost fileUploadPost = null;
    private AtomicReference<Task.TaskCompletionSource> currentTask = new AtomicReference();
    private ParseFileState state;
    private ParseFileState previousState;

    public ParseFile(byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.setState(ParseFileState.DIRTY);
        this.data = data;
    }

    public ParseFile(String name, byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.setState(ParseFileState.DIRTY);
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
        this.setState(ParseFileState.AWAITING_FETCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ParseFileState newState) {
        ParseFile parseFile = this;
        synchronized (parseFile) {
            if (newState != ParseFileState.SAVING && newState != ParseFileState.FETCHING) {
                this.currentTask.set(null);
                this.currentCommand = null;
            }
            if (this.state != newState) {
                this.previousState = this.state;
                this.state = newState;
            }
        }
    }

    private void revertState() {
        this.setState(this.previousState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNotRunning() {
        ParseFile parseFile = this;
        synchronized (parseFile) {
            if (this.state == ParseFileState.SAVING || this.state == ParseFileState.FETCHING) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.state == ParseFileState.DIRTY;
    }

    public boolean isDataAvailable() {
        return this.state != ParseFileState.AWAITING_FETCH && this.state != ParseFileState.FETCHING;
    }

    public String getUrl() {
        return this.url;
    }

    private ParseCommand constructFileUploadCommand(String sessionToken) {
        this.currentCommand = new ParseCommand("upload_file", sessionToken);
        this.currentCommand.enableRetrying();
        if (this.name != null) {
            this.currentCommand.put("name", this.name);
        }
        return this.currentCommand;
    }

    private void prepareFileUploadPost(JSONObject result, ProgressCallback progressCallback) {
        JSONObject postParams = null;
        try {
            this.name = result.getString("name");
            this.url = result.getString("url");
            postParams = result.getJSONObject("post_params");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        String mimeType = null;
        CountingMultipartEntity entity = new CountingMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, progressCallback);
        if (this.name.lastIndexOf(".") != -1) {
            String extension = this.name.substring(this.name.lastIndexOf(".") + 1);
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            entity.addPart("Content-Type", new StringBody(mimeType));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        Iterator keys = postParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                entity.addPart(key, new StringBody(postParams.getString(key)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.addPart("file", new ByteArrayBody(this.data, mimeType, "file"));
        try {
            this.fileUploadPost = new HttpPost(result.getString("post_url"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.fileUploadPost.setEntity((HttpEntity)entity);
    }

    private Task<Void> handleFileUploadResultAsync(JSONObject result, ProgressCallback progressCallback) {
        if (this.state != ParseFileState.SAVING) {
            return Task.forResult(null);
        }
        if (this.fileUploadPost == null) {
            this.prepareFileUploadPost(result, progressCallback);
        }
        ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)this.fileUploadPost, 1000L, 5);
        return retryer.goAsync(null).continueWithTask(new Continuation<byte[], Task<byte[]>>(){

            @Override
            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                ParseFile.this.setState(ParseFileState.DATA_AVAILABLE);
                return task;
            }
        }).onSuccess(new Continuation<byte[], Void>(){

            @Override
            public Void then(Task<byte[]> task) throws Exception {
                return null;
            }
        });
    }

    public void save() throws ParseException {
        this.save(null);
    }

    private void save(ProgressCallback progressCallback) throws ParseException {
        Parse.waitForTask(this.saveAsync(progressCallback));
    }

    Task<Void> saveAsync(final ProgressCallback progressCallback) {
        this.assertNotRunning();
        if (this.state != ParseFileState.DIRTY) {
            return Task.forResult(null);
        }
        this.setState(ParseFileState.SAVING);
        final Task.TaskCompletionSource tcs = Task.create();
        final String sessionToken = ParseUser.getCurrentSessionToken();
        this.currentTask.set(tcs);
        Task.call(new Callable<ParseCommand>(){

            @Override
            public ParseCommand call() throws Exception {
                return ParseFile.this.constructFileUploadCommand(sessionToken);
            }
        }).onSuccessTask(new Continuation<ParseCommand, Task<Object>>(){

            @Override
            public Task<Object> then(Task<ParseCommand> task) throws Exception {
                return task.getResult().performAsync();
            }
        }).onSuccessTask(new Continuation<Object, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Object> task) throws Exception {
                return ParseFile.this.handleFileUploadResultAsync((JSONObject)task.getResult(), progressCallback);
            }
        }).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                if (task.isFaulted()) {
                    ParseFile.this.revertState();
                }
                return task;
            }
        }).continueWith(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else if (task.isFaulted()) {
                    tcs.trySetError(task.getError());
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return null;
            }
        });
        return tcs.getTask();
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.saveAsync(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public byte[] getData() throws ParseException {
        return Parse.waitForTask(this.getDataAsync(null));
    }

    private Task<byte[]> getDataAsync(ProgressCallback progressCallback) {
        if (this.isDataAvailable()) {
            return Task.forResult(this.data);
        }
        this.assertNotRunning();
        this.setState(ParseFileState.FETCHING);
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTask.set(tcs);
        ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)new HttpGet(this.url), 1000L, 5);
        retryer.goAsync(progressCallback).continueWithTask(new Continuation<byte[], Task<byte[]>>(){

            @Override
            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                if (task.isFaulted()) {
                    ParseFile.this.revertState();
                    if (task.getError() instanceof IllegalStateException) {
                        return Task.forError(new ParseException(100, task.getError().getMessage()));
                    }
                }
                ParseFile.this.data = task.getResult();
                return task;
            }
        }).continueWith(new Continuation<byte[], Void>(){

            @Override
            public Void then(Task<byte[]> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else if (task.isFaulted()) {
                    tcs.trySetError(task.getError());
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return null;
            }
        });
        return tcs.getTask();
    }

    public synchronized void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataAsync(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        Task.TaskCompletionSource curr;
        if (this.fileUploadPost != null) {
            this.fileUploadPost.abort();
        }
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
        }
        if ((curr = this.currentTask.get()) != null) {
            curr.trySetCancelled();
        }
        this.revertState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseFileState {
        DIRTY,
        SAVING,
        AWAITING_FETCH,
        FETCHING,
        DATA_AVAILABLE;

    }
}

