/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.LogInCallback;
import com.parse.ParseUser;
import com.parse.auth.AnonymousAuthenticationProvider;
import org.json.JSONException;

public final class ParseAnonymousUtils {
    private static AnonymousAuthenticationProvider provider;
    static final String ANONYMOUS_AUTH_TYPE = "anonymous";

    static {
        ParseAnonymousUtils.initialize();
    }

    private ParseAnonymousUtils() {
    }

    private static void initialize() {
        if (provider == null) {
            provider = new AnonymousAuthenticationProvider();
            ParseUser.registerAuthenticationProvider(provider);
        }
    }

    public static boolean isLinked(ParseUser user) {
        return user.getLinkedServiceNames().contains(ANONYMOUS_AUTH_TYPE);
    }

    public static void logIn(LogInCallback callback) {
        ParseUser.logInWith(provider.getAuthType(), callback);
    }

    static void lazyLogIn() {
        try {
            ParseUser.logInLazyUser(provider.getAuthType(), provider.getAuthData());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

