/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import com.parse.BackgroundTask;
import com.parse.DeleteCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.LocalIdManager;
import com.parse.Parse;
import com.parse.ParseACL;
import com.parse.ParseAddOperation;
import com.parse.ParseAddUniqueOperation;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseCommandCache;
import com.parse.ParseDeleteOperation;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseIncrementOperation;
import com.parse.ParseInstallation;
import com.parse.ParseJSONCacheItem;
import com.parse.ParseMulticastDelegate;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import com.parse.ParseRemoveOperation;
import com.parse.ParseRole;
import com.parse.ParseSetOperation;
import com.parse.ParseUser;
import com.parse.RefreshCallback;
import com.parse.SaveCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseObject {
    private static final String TAG = "com.parse.ParseObject";
    static String server = "https://api.parse.com";
    static final String API_VERSION = "2";
    static final String VERSION_NAME = "1.1.12";
    private static final Map<String, ParseObjectFactory<?>> objectFactories = new HashMap();
    private static final DateFormat impreciseDateFormat;
    boolean dirty;
    private String objectId;
    private String localId;
    private String className;
    private final ParseMulticastDelegate<ParseObject> saveEvent = new ParseMulticastDelegate();
    private final Map<String, Object> serverData;
    protected final LinkedList<Map<String, ParseFieldOperation>> operationSetQueue;
    private final Map<String, Object> estimatedData;
    private final Map<String, Boolean> dataAvailability;
    private final Map<Object, ParseJSONCacheItem> hashedObjects;
    private boolean hasBeenFetched;
    private Date updatedAt;
    private Date createdAt;
    private Boolean isRunning = false;

    ParseObject(String theClassName, boolean isPointer) {
        if (this.getClass().equals(ParseObject.class) && objectFactories.containsKey(theClassName) && !objectFactories.get(theClassName).getExpectedType().isInstance(this)) {
            throw new IllegalArgumentException("You must create this type of ParseObject using ParseObject.create()");
        }
        this.localId = null;
        this.serverData = new HashMap<String, Object>();
        this.operationSetQueue = new LinkedList();
        this.operationSetQueue.add(new HashMap());
        this.estimatedData = new HashMap<String, Object>();
        this.hashedObjects = new HashMap<Object, ParseJSONCacheItem>();
        this.dataAvailability = new HashMap<String, Boolean>();
        this.className = theClassName;
        if (!isPointer) {
            if (!(this instanceof ParseUser) && !(this instanceof ParseInstallation) && ParseACL.getDefaultACL() != null) {
                this.setACL(ParseACL.getDefaultACL());
            }
            this.hasBeenFetched = true;
            this.dirty = true;
        } else {
            this.dirty = false;
            this.hasBeenFetched = false;
        }
    }

    public ParseObject(String theClassName) {
        this(theClassName, false);
    }

    public static ParseObject create(String className) {
        if (objectFactories.containsKey(className)) {
            return objectFactories.get(className).getNew(false);
        }
        return new ParseObject(className, false);
    }

    public static ParseObject createWithoutData(String className, String objectId) {
        ParseObject result = objectFactories.containsKey(className) ? objectFactories.get(className).getNew(true) : new ParseObject(className, true);
        result.setObjectId(objectId);
        result.dirty = false;
        return result;
    }

    private static void registerFactory(String name, ParseObjectFactory<?> factory) {
        objectFactories.put(name, factory);
    }

    static String getApplicationId() {
        Parse.checkInit();
        return Parse.applicationId;
    }

    private static synchronized Date impreciseParseDate(String encoded) {
        try {
            return impreciseDateFormat.parse(encoded);
        }
        catch (java.text.ParseException e) {
            Parse.logE(TAG, "could not parse date: " + encoded, e);
            return null;
        }
    }

    static synchronized JSONObject getDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        return ParseObject.getDiskObject(file);
    }

    static synchronized JSONObject getDiskObject(File file) {
        String fileContent;
        if (!file.exists()) {
            return null;
        }
        try {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            fileContent = new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
        JSONTokener tokener = new JSONTokener(fileContent);
        try {
            return new JSONObject(tokener);
        }
        catch (JSONException e) {
            return null;
        }
    }

    static synchronized void saveDiskObject(Context context, String filename, JSONObject object) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        ParseObject.saveDiskObject(file, object);
    }

    static synchronized void saveDiskObject(File file, JSONObject object) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(object.toString().getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    static synchronized void deleteDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        if (file != null) {
            file.delete();
        }
    }

    protected void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfRunning(boolean grabLock) {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            if (this.isRunning.booleanValue()) {
                throw new RuntimeException("This object has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishedRunning() {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            this.isRunning = false;
        }
    }

    void saveToDisk(Context context, String filename) {
        if (this.isDirty()) {
            throw new RuntimeException("Can't serialize a dirty object to disk.");
        }
        JSONObject object = this.toJSONObjectForDataFile();
        ParseObject.saveDiskObject(context, filename, object);
    }

    void addToHashedObjects(Object object) {
        try {
            this.hashedObjects.put(object, new ParseJSONCacheItem(object));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Couldn't serialize container value to JSON.");
        }
    }

    static ParseObject getFromDisk(Context context, String filename) {
        JSONObject object = ParseObject.getDiskObject(context, filename);
        if (object == null) {
            return null;
        }
        try {
            ParseObject parseObject = ParseObject.createWithoutData(object.getString("classname"), null);
            parseObject.mergeFromServer(object);
            return parseObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.estimatedData.keySet());
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    protected void clearChanges() {
        this.currentOperations().clear();
        this.rebuildEstimatedData();
    }

    protected void copyChangesFrom(ParseObject other) {
        Map<String, ParseFieldOperation> operations = other.operationSetQueue.getFirst();
        for (String key : operations.keySet()) {
            this.performOperation(key, operations.get(key));
        }
    }

    protected void mergeFromObject(ParseObject other) {
        this.objectId = other.objectId;
        this.createdAt = other.createdAt;
        this.updatedAt = other.updatedAt;
        this.serverData.clear();
        this.serverData.putAll(other.serverData);
        if (this.operationSetQueue.size() != 1) {
            throw new IllegalStateException("Attempt ot mergeFromObject during a save.");
        }
        this.operationSetQueue.clear();
        this.operationSetQueue.add(new HashMap());
        this.dirty = false;
        this.rebuildEstimatedData();
    }

    protected void mergeAfterFetch(JSONObject result) {
        this.mergeFromServer(result);
        this.operationSetQueue.clear();
        this.operationSetQueue.add(new HashMap());
        this.rebuildEstimatedData();
    }

    private void mergeAfterSave(JSONObject result, boolean justCreated) {
        Map<String, ParseFieldOperation> operationsBeforeSave = this.operationSetQueue.removeFirst();
        if (result == null) {
            for (String key : operationsBeforeSave.keySet()) {
                ParseFieldOperation operation1 = operationsBeforeSave.get(key);
                ParseFieldOperation operation2 = this.operationSetQueue.getFirst().get(key);
                operation2 = operation2 != null ? operation2.mergeWithPrevious(operation1) : operation1;
                this.operationSetQueue.getFirst().put(key, operation2);
            }
        } else {
            this.applyOperations(operationsBeforeSave, this.serverData);
            this.mergeFromServer(result);
            this.rebuildEstimatedData();
        }
    }

    protected void mergeFromServer(JSONObject object) {
        this.dirty = false;
        try {
            String key;
            Iterator keys;
            String updatedAtString;
            String createdAtString;
            if (object.has("id") && this.objectId == null) {
                this.setObjectIdInternal(object.getString("id"));
                this.hasBeenFetched = true;
            }
            if (object.has("created_at") && (createdAtString = object.getString("created_at")) != null) {
                this.createdAt = ParseObject.impreciseParseDate(createdAtString);
            }
            if (object.has("updated_at") && (updatedAtString = object.getString("updated_at")) != null) {
                this.updatedAt = ParseObject.impreciseParseDate(updatedAtString);
            }
            if (object.has("pointers")) {
                JSONObject newPointers = object.getJSONObject("pointers");
                keys = newPointers.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    JSONArray pointerArray = newPointers.getJSONArray(key);
                    this.serverData.put(key, ParseObject.createWithoutData(pointerArray.optString(0), pointerArray.optString(1)));
                }
            }
            if (object.has("data")) {
                JSONObject newData = object.getJSONObject("data");
                keys = newData.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    this.dataAvailability.put(key, true);
                    if (key.equals("objectId")) {
                        this.setObjectIdInternal(newData.getString(key));
                        this.hasBeenFetched = true;
                        continue;
                    }
                    if (key.equals("createdAt")) {
                        this.createdAt = Parse.parseDate(newData.getString(key));
                        continue;
                    }
                    if (key.equals("updatedAt")) {
                        this.updatedAt = Parse.parseDate(newData.getString(key));
                        continue;
                    }
                    if (key.equals("ACL")) {
                        ParseACL acl = ParseACL.createACLFromJSONObject(newData.getJSONObject(key));
                        this.serverData.put("ACL", acl);
                        this.addToHashedObjects(acl);
                        continue;
                    }
                    if (key.equals("__type") || key.equals("className")) continue;
                    List<Object> value = newData.get(key);
                    List<Object> decodedObject = Parse.decodeJSONObject(value);
                    if (decodedObject != null) {
                        if (Parse.isContainerObject(decodedObject)) {
                            if (decodedObject instanceof JSONArray) {
                                decodedObject = Parse.convertArrayToList((JSONArray)decodedObject);
                            }
                            this.addToHashedObjects(decodedObject);
                        }
                        this.serverData.put(key, decodedObject);
                        continue;
                    }
                    if (Parse.isContainerObject(value)) {
                        JSONObject json;
                        if (value instanceof JSONArray) {
                            value = Parse.convertArrayToList((JSONArray)value);
                        }
                        if (value instanceof JSONObject && (json = (JSONObject)value).has("__type") && json.getString("__type").equals("Relation")) {
                            String className = json.getString("className");
                            value = new ParseRelation(this, key);
                            ((ParseRelation)((Object)value)).setTargetClass(className);
                        }
                        this.addToHashedObjects(value);
                    }
                    this.serverData.put(key, value);
                }
            }
            if (this.updatedAt == null && this.createdAt != null) {
                this.updatedAt = this.createdAt;
            }
            this.dirty = false;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.rebuildEstimatedData();
    }

    private boolean hasDirtyChildren() {
        ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
        ParseObject.findUnsavedChildren(this.estimatedData, unsavedChildren);
        return unsavedChildren.size() > 0;
    }

    protected boolean isDirty() {
        return this.isDirty(true);
    }

    private boolean isDirty(boolean considerChildren) {
        this.checkForChangesToMutableContainers();
        return this.dirty || this.currentOperations().size() > 0 || considerChildren && this.hasDirtyChildren();
    }

    private void checkpointMutableContainer(Object object) {
        if (Parse.isContainerObject(object)) {
            ParseJSONCacheItem newCacheItem = null;
            try {
                newCacheItem = new ParseJSONCacheItem(object);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            this.hashedObjects.put(object, newCacheItem);
        }
    }

    private void checkForChangesToMutableContainer(String key, Object object) {
        if (Parse.isContainerObject(object)) {
            ParseJSONCacheItem oldCacheItem = this.hashedObjects.get(object);
            if (oldCacheItem == null) {
                throw new IllegalArgumentException("ParseObject contains container item that isn't cached.");
            }
            ParseJSONCacheItem newCacheItem = null;
            try {
                newCacheItem = new ParseJSONCacheItem(object);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            if (!oldCacheItem.equals(newCacheItem)) {
                this.performOperation(key, new ParseSetOperation(object));
            }
        } else {
            this.hashedObjects.remove(object);
        }
    }

    protected void checkForChangesToMutableContainers() {
        for (String key : this.estimatedData.keySet()) {
            this.checkForChangesToMutableContainer(key, this.estimatedData.get(key));
        }
        this.hashedObjects.keySet().retainAll(this.estimatedData.values());
    }

    public String getObjectId() {
        return this.objectId;
    }

    public synchronized String getOrCreateLocalId() {
        if (this.localId == null) {
            if (this.objectId != null) {
                throw new IllegalStateException("Attempted to get a localId for an object with an objectId.");
            }
            this.localId = LocalIdManager.getDefaultInstance().createLocalId();
        }
        return this.localId;
    }

    public void setObjectId(String newObjectId) {
        this.checkIfRunning();
        this.dirty = true;
        this.setObjectIdInternal(newObjectId);
    }

    private void setObjectIdInternal(String newObjectId) {
        this.objectId = newObjectId;
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().setObjectId(this.localId, this.objectId);
            this.localId = null;
        }
    }

    private static void findUnsavedChildren(Object data, List<ParseObject> unsaved) {
        ParseObject object;
        if (data instanceof List) {
            List list = (List)data;
            for (Object elem : list) {
                ParseObject.findUnsavedChildren(elem, unsaved);
            }
        } else if (data instanceof Map) {
            Map map = (Map)data;
            for (Object elem : map.values()) {
                ParseObject.findUnsavedChildren(elem, unsaved);
            }
        } else if (data instanceof ParseObject && (object = (ParseObject)data).isDirty()) {
            object.checkIfRunning(true);
            unsaved.add(object);
        }
    }

    protected ParseCommand constructSaveCommand() throws ParseException {
        if (!this.isDirty()) {
            return null;
        }
        JSONObject objectJSON = this.toJSONObjectForSaving();
        String op = this.objectId == null ? "create" : "update";
        ParseCommand command = new ParseCommand(op);
        command.enableRetrying();
        command.put("classname", this.className);
        try {
            command.put("data", objectJSON.getJSONObject("data"));
        }
        catch (JSONException e) {
            throw new RuntimeException("could not decode data");
        }
        return command;
    }

    JSONObject toJSONObjectForDataFile() {
        this.checkForChangesToMutableContainers();
        JSONObject objectJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        try {
            for (String key : this.serverData.keySet()) {
                Object object = this.serverData.get(key);
                if (Parse.isContainerObject(object) && this.hashedObjects.containsKey(object)) {
                    dataJSON.put(key, this.hashedObjects.get(object).getJSONObject());
                    continue;
                }
                dataJSON.put(key, Parse.maybeEncodeJSONObject(object, true));
            }
            if (this.createdAt != null) {
                dataJSON.put("createdAt", (Object)Parse.encodeDate(this.createdAt));
            }
            if (this.updatedAt != null) {
                dataJSON.put("updatedAt", (Object)Parse.encodeDate(this.updatedAt));
            }
            if (this.objectId != null) {
                dataJSON.put("objectId", (Object)this.objectId);
            }
            objectJSON.put("data", (Object)dataJSON);
            objectJSON.put("classname", (Object)this.className);
            if (this.operationSetQueue.size() != 1) {
                throw new IllegalArgumentException("Attempt to serialize an object with saves in progress.");
            }
            dataJSON.put("operations", Parse.maybeReferenceAndEncode(this.currentOperations()));
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    protected JSONObject toJSONObjectForSaving() {
        this.checkForChangesToMutableContainers();
        JSONObject objectJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        try {
            Map<String, ParseFieldOperation> operations = this.currentOperations();
            for (String key : operations.keySet()) {
                Object object;
                ParseFieldOperation operation = operations.get(key);
                if (operation instanceof ParseSetOperation && Parse.isContainerObject(object = ((ParseSetOperation)operation).getValue()) && this.hashedObjects.containsKey(object)) {
                    dataJSON.put(key, this.hashedObjects.get(object).getJSONObject());
                    continue;
                }
                dataJSON.put(key, Parse.maybeEncodeJSONObject(operation, true));
            }
            if (this.objectId != null) {
                dataJSON.put("objectId", (Object)this.objectId);
            }
            objectJSON.put("data", (Object)dataJSON);
            objectJSON.put("classname", (Object)this.className);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    protected void handleSaveResult(String op, JSONObject result) {
        boolean justCreated = op.equals("create") || op.equals("user_signup");
        this.mergeAfterSave(result, justCreated);
        this.saveEvent.invoke(this, null);
    }

    protected void startSave() {
        this.operationSetQueue.addLast(new HashMap());
    }

    protected void validateSave() {
    }

    public void save() throws ParseException {
        this.save(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        try {
            this.validateSave();
            if (this.isDataAvailable("ACL") && this.getACL(false) != null && this.getACL(false).hasUnresolvedUser()) {
                ParseUser.getCurrentUser().save();
                if (this.getACL(false).hasUnresolvedUser()) {
                    throw new IllegalStateException("ACL has an unresolved ParseUser. Save or sign up before attempting to serialize the ACL.");
                }
            }
            ParseObject.deepSave(this.estimatedData);
            ParseCommand command = this.constructSaveCommand();
            if (command == null) {
                return;
            }
            this.startSave();
            command.setInternalCallback(new ParseCommand.InternalCallback(){

                public void perform(ParseCommand command, Object result) {
                    ParseObject.this.handleSaveResult(command.op, (JSONObject)result);
                }
            });
            command.perform();
        }
        finally {
            this.finishedRunning();
        }
    }

    public void saveInBackground(SaveCallback callback) {
        this.checkIfRunning(true);
        BackgroundTask<Void> saveTask = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParseObject.this.save(false);
                return null;
            }
        };
        BackgroundTask.executeTask(saveTask);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public void saveEventually() {
        this.saveEventually(null);
    }

    public void saveEventually(SaveCallback callback) {
        ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
        ParseObject.findUnsavedChildren(this.estimatedData, unsavedChildren);
        for (ParseObject object : unsavedChildren) {
            object.saveEventually();
        }
        ParseCommandCache cache = Parse.getCommandCache();
        ParseCommand command = null;
        try {
            command = this.constructSaveCommand();
        }
        catch (ParseException exception) {
            throw new IllegalStateException("Unable to saveEventually.", exception);
        }
        this.startSave();
        command.setInternalCallback(new ParseCommand.InternalCallback(){

            public void perform(ParseCommand command, Object result) {
                ParseObject.this.handleSaveResult(command.op, (JSONObject)result);
            }
        });
        cache.runEventually(command, callback, this);
    }

    public void deleteEventually() {
        this.deleteEventually(null);
    }

    public void deleteEventually(final DeleteCallback callback) {
        BackgroundTask<Void> runEventuallyTask = new BackgroundTask<Void>(null){

            @Override
            public Void run() throws ParseException {
                ParseCommandCache cache = Parse.getCommandCache();
                cache.runEventually(ParseObject.this.constructDeleteCommand(false), callback, ParseObject.this);
                return null;
            }
        };
        BackgroundTask.executeTask(runEventuallyTask);
        this.dirty = true;
    }

    void handleFetchResult(JSONObject result) {
        this.mergeAfterFetch(result);
        this.hasBeenFetched = true;
    }

    public void refresh() throws ParseException {
        this.fetch();
    }

    public void refreshInBackground(final RefreshCallback callback) {
        this.fetchInBackground(new GetCallback(){

            public void done(ParseObject object, ParseException e) {
                if (callback != null) {
                    callback.internalDone(object, e);
                }
            }
        });
    }

    public ParseObject fetch() throws ParseException {
        return this.fetch(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParseObject fetch(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        try {
            if (this.objectId == null) {
                throw new IllegalArgumentException("Cannot refresh an object that hasn't been saved to the server.");
            }
            ParseCommand command = new ParseCommand("get");
            command.enableRetrying();
            command.put("classname", this.className);
            JSONObject data = new JSONObject();
            try {
                data.put("objectId", (Object)this.objectId);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
            command.put("data", data);
            JSONObject result = (JSONObject)command.perform();
            this.handleFetchResult(result);
            ParseObject parseObject = this;
            return parseObject;
        }
        finally {
            this.finishedRunning();
        }
    }

    public void fetchInBackground(GetCallback callback) {
        this.checkIfRunning(true);
        BackgroundTask<ParseObject> refreshTask = new BackgroundTask<ParseObject>((ParseCallback)callback){

            @Override
            public ParseObject run() throws ParseException {
                ParseObject.this.fetch(false);
                return ParseObject.this;
            }
        };
        BackgroundTask.executeTask(refreshTask);
    }

    private ParseObject fetchIfNeeded(boolean needsLock) throws ParseException {
        if (this.isDataAvailable()) {
            return this;
        }
        this.fetch(needsLock);
        return this;
    }

    public ParseObject fetchIfNeeded() throws ParseException {
        return this.fetchIfNeeded(true);
    }

    public void fetchIfNeededInBackground(GetCallback callback) {
        if (this.isDataAvailable()) {
            callback.internalDone(this, (ParseException)null);
        }
        this.checkIfRunning(true);
        BackgroundTask<ParseObject> fetchTask = new BackgroundTask<ParseObject>((ParseCallback)callback){

            @Override
            public ParseObject run() throws ParseException {
                return ParseObject.this.fetchIfNeeded(false);
            }
        };
        BackgroundTask.executeTask(fetchTask);
    }

    private ParseCommand constructDeleteCommand(boolean requireObjectId) throws ParseException {
        ParseCommand command = new ParseCommand("delete");
        command.enableRetrying();
        command.put("classname", this.className);
        JSONObject data = new JSONObject();
        try {
            data.put("objectId", (Object)this.objectId);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        command.put("data", data);
        return command;
    }

    protected void validateDelete() {
    }

    public void delete() throws ParseException {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        try {
            this.validateDelete();
            if (this.objectId == null) {
                return;
            }
            ParseCommand command = this.constructDeleteCommand(true);
            command.perform();
            this.dirty = true;
        }
        finally {
            this.finishedRunning();
        }
    }

    public void deleteInBackground(DeleteCallback callback) {
        this.checkIfRunning(true);
        this.validateDelete();
        BackgroundTask<Void> deleteTask = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParseObject.this.delete(false);
                return null;
            }
        };
        BackgroundTask.executeTask(deleteTask);
    }

    public void deleteInBackground() {
        this.deleteInBackground(null);
    }

    private static void collectDirtyChildren(Object node, List<ParseObject> dirtyChildren, List<ParseFile> dirtyFiles, IdentityHashMap<ParseObject, ParseObject> seen, IdentityHashMap<ParseObject, ParseObject> seenNew) {
        ParseFile file;
        if (node instanceof List) {
            List list = (List)node;
            for (Object item : list) {
                ParseObject.collectDirtyChildren(item, dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof Map) {
            Map map = (Map)node;
            for (Object value : map.values()) {
                ParseObject.collectDirtyChildren(value, dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof JSONArray) {
            JSONArray array = (JSONArray)node;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    ParseObject.collectDirtyChildren(array.get(i), dirtyChildren, dirtyFiles, seen, seenNew);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Invalid JSONArray on object.", e);
                }
            }
        } else if (node instanceof JSONObject) {
            JSONObject dictionary = (JSONObject)node;
            Iterator keys = dictionary.keys();
            while (keys.hasNext()) {
                try {
                    Object value = dictionary.get((String)keys.next());
                    ParseObject.collectDirtyChildren(value, dirtyChildren, dirtyFiles, seen, seenNew);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Invalid JSONDictionary on object.", e);
                }
            }
        } else if (node instanceof ParseACL) {
            ParseACL acl = (ParseACL)node;
            if (acl.hasUnresolvedUser()) {
                ParseObject.collectDirtyChildren(ParseUser.getCurrentUser(), dirtyChildren, dirtyFiles, seen, seenNew);
            }
        } else if (node instanceof ParseObject) {
            ParseObject object = (ParseObject)node;
            if (object.getObjectId() != null) {
                seenNew = new IdentityHashMap();
            } else {
                if (seenNew.containsKey(object)) {
                    throw new RuntimeException("Found a circular dependency while saving.");
                }
                seenNew = new IdentityHashMap<ParseObject, ParseObject>(seenNew);
                seenNew.put(object, object);
            }
            if (seen.containsKey(object)) {
                return;
            }
            seen = new IdentityHashMap<ParseObject, ParseObject>(seen);
            seen.put(object, object);
            ParseObject.collectDirtyChildren(object.estimatedData, dirtyChildren, dirtyFiles, seen, seenNew);
            if (object.isDirty(false)) {
                dirtyChildren.add(object);
            }
        } else if (node instanceof ParseFile && (file = (ParseFile)node).getUrl() == null) {
            dirtyFiles.add(file);
        }
    }

    private static void collectDirtyChildren(Object node, List<ParseObject> dirtyChildren, List<ParseFile> dirtyFiles) {
        ParseObject.collectDirtyChildren(node, dirtyChildren, dirtyFiles, new IdentityHashMap<ParseObject, ParseObject>(), new IdentityHashMap<ParseObject, ParseObject>());
    }

    private static boolean canBeSerializedAsValue(Object value) {
        ParseACL acl;
        if (value instanceof ParseObject) {
            ParseObject object = (ParseObject)value;
            return object.getObjectId() != null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object item : map.values()) {
                if (ParseObject.canBeSerializedAsValue(item)) continue;
                return false;
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    if (ParseObject.canBeSerializedAsValue(array.get(i))) continue;
                    return false;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unable to find related objects for saving.", e);
                }
            }
        } else if (value instanceof JSONObject) {
            JSONObject dictionary = (JSONObject)value;
            Iterator keys = dictionary.keys();
            while (keys.hasNext()) {
                try {
                    Object v = dictionary.get((String)keys.next());
                    if (ParseObject.canBeSerializedAsValue(v)) continue;
                    return false;
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unable to find related objects for saving.", e);
                }
            }
        } else if (value instanceof ParseACL && (acl = (ParseACL)value).hasUnresolvedUser() && !ParseObject.canBeSerializedAsValue(ParseUser.getCurrentUser())) {
            return false;
        }
        return true;
    }

    private boolean canBeSerialized() {
        if (!ParseObject.canBeSerializedAsValue(this.estimatedData)) {
            return false;
        }
        return !this.isDataAvailable("ACL") || this.getACL(false) == null || !this.getACL(false).hasUnresolvedUser();
    }

    private static void deepSave(Object object) throws ParseException {
        ArrayList<ParseObject> objects = new ArrayList<ParseObject>();
        ArrayList<ParseFile> files = new ArrayList<ParseFile>();
        ParseObject.collectDirtyChildren(object, objects, files);
        for (ParseFile file : files) {
            file.save();
        }
        IdentityHashMap<ParseObject, Boolean> uniqueObjects = new IdentityHashMap<ParseObject, Boolean>();
        for (ParseObject obj : objects) {
            uniqueObjects.put(obj, true);
        }
        ArrayList<Object> remaining = new ArrayList(uniqueObjects.keySet());
        while (remaining.size() > 0) {
            ArrayList<ParseObject> current = new ArrayList<ParseObject>();
            ArrayList<ParseObject> nextBatch = new ArrayList<ParseObject>();
            for (ParseObject obj : remaining) {
                if (obj.canBeSerialized()) {
                    current.add(obj);
                    continue;
                }
                nextBatch.add(obj);
            }
            remaining = nextBatch;
            if (current.size() == 0) {
                throw new RuntimeException("Unable to save a PFObject with a relation to a cycle.");
            }
            if (ParseUser.getCurrentUser() != null && ParseUser.getCurrentUser().isLazy() && current.contains(ParseUser.getCurrentUser())) {
                ParseUser.getCurrentUser().save();
                current.remove(ParseUser.getCurrentUser());
                if (current.size() == 0) continue;
            }
            JSONArray commands = new JSONArray();
            ArrayList<String> ops = new ArrayList<String>();
            for (ParseObject obj : current) {
                obj.validateSave();
                ParseCommand command = obj.constructSaveCommand();
                obj.startSave();
                if (command == null) continue;
                JSONObject jsonCommand = command.toJSONObject();
                commands.put((Object)jsonCommand);
                ops.add(command.op);
            }
            ParseCommand multiCommand = new ParseCommand("multi");
            multiCommand.put("commands", commands);
            JSONArray results = (JSONArray)multiCommand.perform();
            for (int i = 0; i < current.size(); ++i) {
                String op = (String)ops.get(i);
                try {
                    JSONObject result = results.getJSONObject(i);
                    ((ParseObject)current.get(i)).handleSaveResult(op, result);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
    }

    public static void saveAll(List<ParseObject> objects) throws ParseException {
        ParseObject.deepSave(objects);
    }

    public static List<ParseObject> fetchAllIfNeeded(List<ParseObject> objects) throws ParseException {
        ArrayList<String> ids = new ArrayList<String>();
        String className = null;
        for (ParseObject object : objects) {
            if (object.isDataAvailable()) continue;
            if (className != null && !className.equals(object.getClassName())) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            className = object.getClassName();
            String id2 = object.getObjectId();
            if (id2 == null) continue;
            ids.add(id2);
        }
        if (ids.size() == 0) {
            return objects;
        }
        ParseQuery query = new ParseQuery(className);
        query.whereContainedIn("objectId", ids);
        List<ParseObject> results = query.find();
        HashMap<String, ParseObject> resultMap = new HashMap<String, ParseObject>();
        for (ParseObject o : results) {
            resultMap.put(o.getObjectId(), o);
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (objects.get(i).isDataAvailable()) continue;
            ParseObject newObject = (ParseObject)resultMap.get(objects.get(i).getObjectId());
            if (newObject == null) {
                throw new RuntimeException("Object id " + objects.get(i).getObjectId() + " does not exist");
            }
            objects.get(i).mergeFromObject(newObject);
            objects.get((int)i).hasBeenFetched = true;
        }
        return objects;
    }

    public static void fetchAllIfNeededInBackground(final List<ParseObject> objects, FindCallback callback) {
        BackgroundTask<List<ParseObject>> fetchTask = new BackgroundTask<List<ParseObject>>((ParseCallback)callback){

            @Override
            public List<ParseObject> run() throws ParseException {
                return ParseObject.fetchAllIfNeeded(objects);
            }
        };
        BackgroundTask.executeTask(fetchTask);
    }

    public static List<ParseObject> fetchAll(List<ParseObject> objects) throws ParseException {
        if (objects.size() == 0) {
            return objects;
        }
        ArrayList<String> ids = new ArrayList<String>();
        String className = objects.get(0).getClassName();
        for (int i = 0; i < objects.size(); ++i) {
            if (!objects.get(i).getClassName().equals(className)) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            String id2 = objects.get(i).getObjectId();
            if (id2 == null) {
                throw new IllegalArgumentException("All objects must exist on the server");
            }
            ids.add(objects.get(i).getObjectId());
        }
        ParseQuery query = new ParseQuery(className);
        query.whereContainedIn("objectId", ids);
        List<ParseObject> results = query.find();
        HashMap<String, ParseObject> resultMap = new HashMap<String, ParseObject>();
        for (ParseObject o : results) {
            resultMap.put(o.getObjectId(), o);
        }
        for (int i = 0; i < objects.size(); ++i) {
            ParseObject newObject = (ParseObject)resultMap.get(objects.get(i).getObjectId());
            if (newObject == null) {
                throw new RuntimeException("Object id " + objects.get(i).getObjectId() + " does not exist");
            }
            objects.get(i).mergeFromObject(newObject);
            objects.get((int)i).hasBeenFetched = true;
        }
        return objects;
    }

    public static void fetchAllInBackground(final List<ParseObject> objects, FindCallback callback) {
        BackgroundTask<List<ParseObject>> fetchTask = new BackgroundTask<List<ParseObject>>((ParseCallback)callback){

            @Override
            public List<ParseObject> run() throws ParseException {
                return ParseObject.fetchAll(objects);
            }
        };
        BackgroundTask.executeTask(fetchTask);
    }

    public static void saveAllInBackground(List<ParseObject> objects, SaveCallback callback) {
        final List<ParseObject> finalObjects = objects;
        BackgroundTask<Void> saveTask = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParseObject.saveAll(finalObjects);
                return null;
            }
        };
        BackgroundTask.executeTask(saveTask);
    }

    public static void saveAllInBackground(List<ParseObject> objects) {
        ParseObject.saveAllInBackground(objects, null);
    }

    public void remove(String key) {
        this.checkIfRunning();
        Object object = this.get(key);
        if (object != null) {
            this.performOperation(key, ParseDeleteOperation.getInstance());
        }
    }

    public boolean has(String key) {
        return this.containsKey(key);
    }

    private Map<String, ParseFieldOperation> currentOperations() {
        return this.operationSetQueue.getLast();
    }

    private void applyOperations(Map<String, ParseFieldOperation> operations, Map<String, Object> map) {
        for (String key : operations.keySet()) {
            Object oldValue;
            ParseFieldOperation operation = operations.get(key);
            Object newValue = operation.apply(oldValue = map.get(key), this, key);
            if (newValue != null) {
                map.put(key, newValue);
                continue;
            }
            map.remove(key);
        }
    }

    private void rebuildEstimatedData() {
        this.estimatedData.clear();
        this.estimatedData.putAll(this.serverData);
        for (Map map : this.operationSetQueue) {
            this.applyOperations(map, this.estimatedData);
        }
    }

    void performOperation(String key, ParseFieldOperation operation) {
        Object oldValue = this.estimatedData.get(key);
        Object newValue = operation.apply(oldValue, this, key);
        if (newValue != null) {
            this.estimatedData.put(key, newValue);
        } else {
            this.estimatedData.remove(key);
        }
        ParseFieldOperation oldOperation = this.currentOperations().get(key);
        ParseFieldOperation newOperation = operation.mergeWithPrevious(oldOperation);
        this.currentOperations().put(key, newOperation);
        this.checkpointMutableContainer(newValue);
        this.dataAvailability.put(key, Boolean.TRUE);
    }

    public void put(String key, Object value) {
        this.checkIfRunning();
        if (key == null) {
            throw new IllegalArgumentException("key may not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null.");
        }
        if (value instanceof ParseFile && ((ParseFile)value).isDirty()) {
            throw new IllegalArgumentException("ParseFile must be saved before being set on a ParseObject.");
        }
        if (!Parse.isValidType(value)) {
            throw new IllegalArgumentException("invalid type for value: " + value.getClass().toString());
        }
        this.performOperation(key, new ParseSetOperation(value));
        this.checkpointMutableContainer(value);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number amount) {
        this.checkIfRunning();
        ParseIncrementOperation operation = new ParseIncrementOperation(amount);
        this.performOperation(key, operation);
    }

    public void add(String key, Object value) {
        this.addAll(key, Arrays.asList(value));
    }

    public void addAll(String key, Collection<?> values) {
        this.checkIfRunning();
        ParseAddOperation operation = new ParseAddOperation(values);
        this.performOperation(key, operation);
    }

    public void addUnique(String key, Object value) {
        this.addAllUnique(key, Arrays.asList(value));
    }

    public void addAllUnique(String key, Collection<?> values) {
        this.checkIfRunning();
        ParseAddUniqueOperation operation = new ParseAddUniqueOperation(values);
        this.performOperation(key, operation);
    }

    public void removeAll(String key, Collection<?> values) {
        this.checkIfRunning();
        ParseRemoveOperation operation = new ParseRemoveOperation(values);
        this.performOperation(key, operation);
    }

    public boolean containsKey(String key) {
        return this.estimatedData.containsKey(key);
    }

    public String getString(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public byte[] getBytes(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof byte[])) {
            return null;
        }
        return (byte[])value;
    }

    public Number getNumber(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof Number)) {
            return null;
        }
        return (Number)value;
    }

    public JSONArray getJSONArray(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (value instanceof List) {
            List l = (List)value;
            value = Parse.encodeAsJSONArray(l, true);
            this.put(key, value);
        }
        if (!(value instanceof JSONArray)) {
            return null;
        }
        return (JSONArray)value;
    }

    public <T> List<T> getList(String key) {
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        List<Object> value = this.estimatedData.get(key);
        if (value instanceof JSONArray) {
            value = Parse.convertArrayToList((JSONArray)value);
            this.put(key, value);
        }
        if (!(value instanceof List)) {
            return null;
        }
        List<Object> returnValue = value;
        return returnValue;
    }

    public <V> Map<String, V> getMap(String key) {
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Map<String, Object> value = this.estimatedData.get(key);
        if (value instanceof JSONObject) {
            value = Parse.convertJSONObjectToMap((JSONObject)value);
            this.put(key, value);
        }
        if (!(value instanceof Map)) {
            return null;
        }
        Map<String, Object> returnValue = value;
        return returnValue;
    }

    public JSONObject getJSONObject(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (value instanceof Map) {
            value = Parse.encodeJSONObject(value, true);
            this.put(key, value);
        }
        if (!(value instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)value;
    }

    public int getInt(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public double getDouble(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public long getLong(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    public boolean getBoolean(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return false;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    public Date getDate(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof Date)) {
            return null;
        }
        return (Date)value;
    }

    public ParseObject getParseObject(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseObject)) {
            return null;
        }
        return (ParseObject)value;
    }

    public ParseUser getParseUser(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseUser)) {
            return null;
        }
        return (ParseUser)value;
    }

    public ParseGeoPoint getParseGeoPoint(String key) {
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (!(value instanceof ParseGeoPoint)) {
            return null;
        }
        return (ParseGeoPoint)value;
    }

    public ParseACL getACL() {
        return this.getACL(true);
    }

    private ParseACL getACL(boolean mayCopy) {
        this.checkGetAccess("ACL");
        Object acl = this.estimatedData.get("ACL");
        if (acl == null) {
            return null;
        }
        if (!(acl instanceof ParseACL)) {
            throw new RuntimeException("only ACLs can be stored in the ACL key");
        }
        if (mayCopy && ((ParseACL)acl).isShared()) {
            ParseACL copy = ((ParseACL)acl).copy();
            this.estimatedData.put("ACL", copy);
            this.addToHashedObjects(copy);
            return copy;
        }
        return (ParseACL)acl;
    }

    public void setACL(ParseACL acl) {
        this.put("ACL", acl);
    }

    public boolean isDataAvailable() {
        return this.hasBeenFetched;
    }

    private boolean isDataAvailable(String key) {
        return this.isDataAvailable() || this.dataAvailability.containsKey(key) && this.dataAvailability.get(key) != false;
    }

    public ParseRelation getRelation(String key) {
        ParseRelation relation = new ParseRelation(this, key);
        Object value = this.estimatedData.get(key);
        if (value instanceof ParseRelation) {
            relation.setTargetClass(((ParseRelation)value).getTargetClass());
        }
        return relation;
    }

    public Object get(String key) {
        ParseACL acl;
        this.checkGetAccess(key);
        if (!this.estimatedData.containsKey(key)) {
            return null;
        }
        Object value = this.estimatedData.get(key);
        if (value instanceof ParseACL && key.equals("ACL") && (acl = (ParseACL)value).isShared()) {
            ParseACL copy = acl.copy();
            this.estimatedData.put("ACL", copy);
            this.addToHashedObjects(copy);
            return this.getACL();
        }
        if (value instanceof ParseRelation) {
            ((ParseRelation)value).ensureParentAndKey(this, key);
        }
        return value;
    }

    private void checkGetAccess(String key) {
        if (!this.isDataAvailable(key)) {
            throw new IllegalStateException("ParseObject has no data for this key.  Call fetchIfNeeded() to get the data.");
        }
    }

    public boolean hasSameId(ParseObject other) {
        return this.getClassName() != null && this.getObjectId() != null && this.getClassName().equals(other.getClassName()) && this.getObjectId().equals(other.getObjectId());
    }

    void registerSaveListener(GetCallback callback) {
        this.saveEvent.subscribe(callback);
    }

    void unregisterSaveListener(GetCallback callback) {
        this.saveEvent.unsubscribe(callback);
    }

    static {
        ParseObject.registerFactory("_User", new ParseObjectFactory<ParseUser>(){

            @Override
            public ParseUser getNew(boolean isPointer) {
                return new ParseUser(isPointer);
            }

            @Override
            public Class<? extends ParseUser> getExpectedType() {
                return ParseUser.class;
            }
        });
        ParseObject.registerFactory("_Role", new ParseObjectFactory<ParseRole>(){

            @Override
            public ParseRole getNew(boolean isPointer) {
                return new ParseRole(isPointer);
            }

            @Override
            public Class<? extends ParseRole> getExpectedType() {
                return ParseRole.class;
            }
        });
        ParseObject.registerFactory("_Installation", new ParseObjectFactory<ParseInstallation>(){

            @Override
            public ParseInstallation getNew(boolean isPointer) {
                return new ParseInstallation(isPointer);
            }

            @Override
            public Class<? extends ParseInstallation> getExpectedType() {
                return ParseInstallation.class;
            }
        });
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        impreciseDateFormat = format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParseObjectFactory<T extends ParseObject> {
        public T getNew(boolean var1);

        public Class<? extends T> getExpectedType();
    }
}

