/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.util.Log;
import com.parse.ACRA;
import com.parse.BoundedLinkedList;
import com.parse.Compatibility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

class LogCatCollector {
    private static final int DEFAULT_TAIL_COUNT = 100;

    LogCatCollector() {
    }

    protected static String collectLogCat(String bufferName) {
        BoundedLinkedList<String> logcatBuf = null;
        try {
            String line;
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add("logcat");
            if (bufferName != null) {
                commandLine.add("-b");
                commandLine.add(bufferName);
            }
            int tailCount = -1;
            ArrayList<String> logcatArgumentsList = new ArrayList<String>(Arrays.asList(ACRA.getConfig().logcatArguments()));
            int tailIndex = logcatArgumentsList.indexOf("-t");
            if (tailIndex > -1 && tailIndex < logcatArgumentsList.size()) {
                tailCount = Integer.parseInt((String)logcatArgumentsList.get(tailIndex + 1));
                if (Compatibility.getAPILevel() < 8) {
                    logcatArgumentsList.remove(tailIndex + 1);
                    logcatArgumentsList.remove(tailIndex);
                    logcatArgumentsList.add("-d");
                }
            }
            logcatBuf = new BoundedLinkedList<String>(tailCount > 0 ? tailCount : 100);
            commandLine.addAll(logcatArgumentsList);
            Process process = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Log.d((String)"CrashReporting", (String)"Retrieving logcat output...");
            while ((line = bufferedReader.readLine()) != null) {
                logcatBuf.add(line + "\n");
            }
        }
        catch (IOException e) {
            Log.e((String)"CrashReporting", (String)"LogCatCollector.collectLogcat could not retrieve data.", (Throwable)e);
        }
        return logcatBuf.toString();
    }
}

