/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;

final class PackageManagerWrapper {
    private final Context context;

    public PackageManagerWrapper(Context context) {
        this.context = context;
    }

    public boolean hasPermission(String permission) {
        PackageManager pm = this.context.getPackageManager();
        if (pm == null) {
            return false;
        }
        try {
            return pm.checkPermission(permission, this.context.getPackageName()) == 0;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public PackageInfo getPackageInfo() {
        PackageManager pm = this.context.getPackageManager();
        if (pm == null) {
            return null;
        }
        try {
            return pm.getPackageInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.v((String)"CrashReporting", (String)("Failed to find PackageInfo for current App : " + this.context.getPackageName()));
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

