/*
 * Decompiled with CFR 0.152.
 */
package com.parse.facebook;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.parse.facebook.DialogError;
import com.parse.facebook.Facebook;
import com.parse.facebook.FacebookError;
import com.parse.facebook.Util;

public class FbDialog
extends Dialog {
    static final int FB_BLUE = -9599820;
    static final float[] DIMENSIONS_DIFF_LANDSCAPE = new float[]{20.0f, 60.0f};
    static final float[] DIMENSIONS_DIFF_PORTRAIT = new float[]{40.0f, 60.0f};
    static final FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
    static final int MARGIN = 4;
    static final int PADDING = 2;
    static final String DISPLAY_STRING = "touch";
    static final String FB_ICON = "icon.png";
    private String mUrl;
    private Facebook.DialogListener mListener;
    private ProgressDialog mSpinner;
    private ImageView mCrossImage;
    private WebView mWebView;
    private FrameLayout mContent;

    public FbDialog(Context context, String url, Facebook.DialogListener listener) {
        super(context, 0x1030010);
        this.mUrl = url;
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSpinner = new ProgressDialog(this.getContext());
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage((CharSequence)"Loading...");
        this.requestWindowFeature(1);
        this.mContent = new FrameLayout(this.getContext());
        this.createCrossImage();
        int crossWidth = this.mCrossImage.getDrawable().getIntrinsicWidth();
        this.setUpWebView(crossWidth / 2);
        this.mContent.addView((View)this.mCrossImage, new ViewGroup.LayoutParams(-2, -2));
        this.addContentView((View)this.mContent, new ViewGroup.LayoutParams(-1, -1));
    }

    private void createCrossImage() {
        this.mCrossImage = new ImageView(this.getContext());
        this.mCrossImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FbDialog.this.mListener.onCancel();
                FbDialog.this.dismiss();
            }
        });
        Drawable crossDrawable = this.getContext().getResources().getDrawable(17301527);
        this.mCrossImage.setImageDrawable(crossDrawable);
        this.mCrossImage.setVisibility(4);
    }

    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        this.mWebView = new WebView(this.getContext());
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setWebViewClient((WebViewClient)new FbWebViewClient());
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.loadUrl(this.mUrl);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)FILL);
        this.mWebView.setVisibility(4);
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView((View)this.mWebView);
        this.mContent.addView((View)webViewContainer);
    }

    private class FbWebViewClient
    extends WebViewClient {
        private FbWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Util.logd("Facebook-WebView", "Redirect URL: " + url);
            if (url.startsWith("fbconnect://success")) {
                Bundle values = Util.parseUrl(url);
                String error = values.getString("error");
                if (error == null) {
                    error = values.getString("error_type");
                }
                if (error == null) {
                    FbDialog.this.mListener.onComplete(values);
                } else if (error.equals("access_denied") || error.equals("OAuthAccessDeniedException")) {
                    FbDialog.this.mListener.onCancel();
                } else {
                    FbDialog.this.mListener.onFacebookError(new FacebookError(error));
                }
                FbDialog.this.dismiss();
                return true;
            }
            if (url.startsWith("fbconnect://cancel")) {
                FbDialog.this.mListener.onCancel();
                FbDialog.this.dismiss();
                return true;
            }
            if (url.contains(FbDialog.DISPLAY_STRING)) {
                return false;
            }
            FbDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            FbDialog.this.mListener.onError(new DialogError(description, errorCode, failingUrl));
            FbDialog.this.dismiss();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Util.logd("Facebook-WebView", "Webview loading URL: " + url);
            super.onPageStarted(view, url, favicon);
            FbDialog.this.mSpinner.show();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            try {
                FbDialog.this.mSpinner.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FbDialog.this.mContent.setBackgroundColor(0);
            FbDialog.this.mWebView.setVisibility(0);
            FbDialog.this.mCrossImage.setVisibility(0);
        }
    }
}

