/*
 * Decompiled with CFR 0.152.
 */
package com.parse.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import com.parse.auth.ParseAuthenticationProvider;
import com.parse.facebook.DialogError;
import com.parse.facebook.Facebook;
import com.parse.facebook.FacebookError;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookAuthenticationProvider
implements ParseAuthenticationProvider {
    private final DateFormat preciseDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final int DEFAULT_AUTH_ACTIVITY_CODE = 32665;
    private static final String AUTH_TYPE_NAME = "facebook";
    private final Facebook facebook;
    private boolean useSingleSignOn;
    private int activityCode;
    private WeakReference<Activity> baseActivity;
    private Collection<String> permissions;
    private ParseAuthenticationProvider.ParseAuthenticationCallback currentOperationCallback;
    private String userId;

    public FacebookAuthenticationProvider(Facebook facebook) {
        this.preciseDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.activityCode = 32665;
        this.facebook = facebook;
    }

    public synchronized void extendAccessToken(Context context, ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        boolean result = this.facebook.extendAccessToken(context, new Facebook.ServiceListener(){

            public void onComplete(Bundle values) {
                FacebookAuthenticationProvider.this.handleSuccess(FacebookAuthenticationProvider.this.userId);
            }

            public void onFacebookError(FacebookError e) {
                FacebookAuthenticationProvider.this.handleError(e);
            }

            public void onError(Error e) {
                FacebookAuthenticationProvider.this.handleError(e);
            }
        });
        if (!result) {
            this.handleCancel();
        }
    }

    @Override
    public synchronized void authenticate(ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        Activity activity;
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        Activity activity2 = activity = this.baseActivity == null ? null : (Activity)this.baseActivity.get();
        if (activity == null) {
            throw new IllegalStateException("Activity must be non-null for Facebook authentication to proceed.");
        }
        int activityCode = this.useSingleSignOn ? this.activityCode : -1;
        String[] permissions = this.permissions == null ? null : this.permissions.toArray(new String[this.permissions.size()]);
        this.facebook.authorize(activity, permissions, activityCode, new Facebook.DialogListener(){

            public void onCancel() {
                FacebookAuthenticationProvider.this.handleCancel();
            }

            public void onComplete(Bundle values) {
                if (FacebookAuthenticationProvider.this.currentOperationCallback == null) {
                    return;
                }
                new GetUserIdBackgroundTask().execute(new Void[0]);
            }

            public void onError(DialogError e) {
                FacebookAuthenticationProvider.this.handleError(e);
            }

            public void onFacebookError(FacebookError e) {
                FacebookAuthenticationProvider.this.handleError(e);
            }
        });
    }

    public void authenticateComplete(int requestCode, int resultCode, Intent data) {
        this.facebook.authorizeCallback(requestCode, resultCode, data);
    }

    @Override
    public synchronized void cancel() {
        this.handleCancel();
    }

    public int getActivityCode() {
        return this.activityCode;
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE_NAME;
    }

    public Facebook getFacebook() {
        return this.facebook;
    }

    private void handleCancel() {
        if (this.currentOperationCallback == null) {
            return;
        }
        try {
            this.currentOperationCallback.onCancel();
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    private void handleError(Throwable error) {
        if (this.currentOperationCallback == null) {
            return;
        }
        try {
            this.currentOperationCallback.onError(error);
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    public JSONObject getAuthData(String id, String accessToken, Date expiration) throws JSONException {
        JSONObject authData = new JSONObject();
        authData.put("id", (Object)id);
        authData.put("access_token", (Object)accessToken);
        authData.put("expiration_date", (Object)this.preciseDateFormat.format(expiration));
        return authData;
    }

    private void handleSuccess(String userId) {
        if (this.currentOperationCallback == null) {
            return;
        }
        this.userId = userId;
        JSONObject authData = null;
        try {
            authData = this.getAuthData(userId, this.facebook.getAccessToken(), new Date(this.facebook.getAccessExpires()));
        }
        catch (JSONException e) {
            this.handleError(e);
            return;
        }
        try {
            this.currentOperationCallback.onSuccess(authData);
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    public synchronized void setActivity(Activity activity) {
        this.baseActivity = new WeakReference<Activity>(activity);
    }

    public synchronized void setActivityCode(int activityCode) {
        this.activityCode = activityCode;
    }

    public synchronized void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }

    public synchronized void setSingleSignOn(boolean useSingleSignOn) {
        this.useSingleSignOn = useSingleSignOn;
    }

    @Override
    public boolean restoreAuthentication(JSONObject authData) {
        if (authData == null) {
            this.facebook.setAccessExpires(1L);
            this.facebook.setAccessToken(null);
            return true;
        }
        try {
            this.facebook.setAccessToken(authData.getString("access_token"));
            this.facebook.setAccessExpires(this.preciseDateFormat.parse(authData.getString("expiration_date")).getTime());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void deauthenticate() {
        this.facebook.setAccessExpires(0L);
        this.facebook.setAccessToken(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetUserIdBackgroundTask
    extends AsyncTask<Void, Void, Object> {
        private GetUserIdBackgroundTask() {
        }

        protected Object doInBackground(Void ... params) {
            Bundle idRequestArgs = new Bundle();
            idRequestArgs.putString("fields", "id");
            try {
                String result = FacebookAuthenticationProvider.this.facebook.request("me", idRequestArgs);
                JSONObject meObject = new JSONObject(result);
                return meObject.getString("id");
            }
            catch (Exception e) {
                return e;
            }
        }

        protected void onPostExecute(Object result) {
            super.onPostExecute(result);
            if (result instanceof Exception) {
                FacebookAuthenticationProvider.this.handleError((Exception)result);
                return;
            }
            FacebookAuthenticationProvider.this.handleSuccess((String)result);
        }
    }
}

