/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import com.parse.Parse;
import com.parse.ParsePushRouter;
import com.parse.os.ParseAsyncTask;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    private static String pushServer = "push.parse.com";
    private static int defaultPushPort = 8253;
    private int pushPort;
    static Socket socket;
    private ParseAsyncTask<Void, Void, String> task;
    private static int delaySeconds;
    private ServiceState state = ServiceState.STOPPED;
    private Timer keepAliveTimer = null;
    static int consecutiveFailures;
    static Semaphore sleepSemaphore;

    private static synchronized void startService(Context context) {
        Parse.logD(TAG, "ensuring push service is started");
        ComponentName name = context.startService(new Intent(context, PushService.class));
        if (name == null) {
            Parse.logE(TAG, "Could not start the push service. Make sure that the XML tag <service android:name=\"com.parse.PushService\" /> is in your AndroidManifest.xml as a child of the <application> element.");
        }
    }

    public static void startServiceIfRequired(Context context) {
        if (!ParsePushRouter.hasRoutes(context)) {
            Parse.logW(TAG, "No known push routes; will not start push service");
        } else {
            PushService.startService(context);
        }
    }

    public static void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.subscribe(context, channel, cls, info.icon);
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls, int icon) {
        PushService.startService(context);
        ParsePushRouter.addChannelRoute(context, channel, cls, icon);
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        ParsePushRouter.removeChannelRoute(context, channel);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.setDefaultPushCallback(context, cls, info.icon);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls, int icon) {
        ParsePushRouter.setDefaultRoute(context, cls, icon);
        if (cls != null) {
            PushService.startService(context);
        } else if (!ParsePushRouter.hasRoutes(context)) {
            Parse.logD(TAG, "Shutting down push service. No remaining channels");
            context.stopService(new Intent(context, PushService.class));
        }
    }

    public static synchronized Set<String> getSubscriptions(Context context) {
        return ParsePushRouter.getSubscriptions(context);
    }

    /*
     * Unable to fully structure code
     */
    static void sleep(int millis) throws InterruptedException {
        block1: {
            Parse.logV("com.parse.PushService", "Sleeping " + millis + " ms");
            semaphore = PushService.sleepSemaphore;
            if (semaphore != null) ** GOTO lbl8
            Thread.sleep(millis);
            break block1;
lbl-1000:
            // 1 sources

            {
                semaphore.acquire(100);
                millis -= 100;
lbl8:
                // 2 sources

                ** while (millis > 100)
            }
lbl9:
            // 1 sources

            semaphore.acquire(millis);
        }
    }

    static void useServer(String newServer) {
        pushServer = newServer;
    }

    static void usePort(int newPort) {
        defaultPushPort = newPort;
    }

    static void resetDelay() {
        delaySeconds = 0;
        consecutiveFailures = 0;
    }

    private void increaseDelay() {
        ++consecutiveFailures;
        delaySeconds = (int)((double)delaySeconds * (1.5 + Math.random() / 2.0));
        delaySeconds = Math.max(15, delaySeconds);
        delaySeconds = Math.min(delaySeconds, 300);
    }

    public void onCreate() {
        super.onCreate();
        if (Parse.applicationContext == null) {
            Parse.logE(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.state = ServiceState.ABORTING;
            this.stopSelf();
            return;
        }
        this.state = ServiceState.RUNNING;
        Parse.logD(TAG, "creating push service");
        this.pushPort = defaultPushPort;
        this.keepAliveTimer = new Timer("com.parse.PushService.keepAliveTimer", true);
        long msKeepAlive = 1200000L;
        this.keepAliveTimer.schedule(new TimerTask(){

            public void run() {
                PushService.this.sendKeepAlive();
            }
        }, msKeepAlive, msKeepAlive);
        PushService.resetDelay();
        this.readInBackground(null);
    }

    static boolean sendMessage(String message) {
        if (socket == null) {
            return false;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), 8192);
            Parse.logD(TAG, "subscribing with " + message + " @ " + socket.getPort());
            writer.write(String.valueOf(message) + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            Parse.logE(TAG, "unsupported encoding", e);
            return false;
        }
        catch (IOException e) {
            Parse.logE(TAG, "could not construct writer", e);
            return false;
        }
        return true;
    }

    private static synchronized boolean sendSubscriptionInformation(Context context) {
        JSONObject request = ParsePushRouter.getPushRequestJSON(context);
        return PushService.sendMessage(request.toString());
    }

    private void sendKeepAlive() {
        PushService.sendMessage("{}");
    }

    private void readInBackground(final BufferedReader initialReader) {
        final PushService finalService = this;
        if (this.state == ServiceState.DESTRUCTING) {
            return;
        }
        this.task = new ParseAsyncTask<Void, Void, String>(){
            private BufferedReader reader;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(Void ... v) {
                if (initialReader != null) {
                    this.reader = initialReader;
                } else {
                    Socket newSocket;
                    if (delaySeconds > 0) {
                        try {
                            Parse.logI(PushService.TAG, "sleeping for " + delaySeconds + " seconds");
                            PushService.sleep(delaySeconds * 1000);
                        }
                        catch (InterruptedException e) {
                            Parse.logE(PushService.TAG, "sleep interrupted", e);
                            return null;
                        }
                    }
                    if (PushService.this.state == ServiceState.DESTRUCTING) {
                        return null;
                    }
                    PushService.this.increaseDelay();
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            Parse.logE(PushService.TAG, "error closing socket", e);
                        }
                    }
                    try {
                        Parse.logD(PushService.TAG, "connecting to push server at " + pushServer + ":" + PushService.this.pushPort);
                        InetSocketAddress address = new InetSocketAddress(pushServer, PushService.this.pushPort);
                        newSocket = new Socket();
                        newSocket.setKeepAlive(true);
                        if (sleepSemaphore == null) {
                            newSocket.connect(address, 5000);
                        } else {
                            newSocket.connect(address, 50);
                        }
                    }
                    catch (UnknownHostException e) {
                        Parse.logE(PushService.TAG, "unknown host", e);
                        return null;
                    }
                    catch (IOException e) {
                        Parse.logE(PushService.TAG, "could not connect to push server", e);
                        return null;
                    }
                    PushService e = PushService.this;
                    synchronized (e) {
                        block26: {
                            if (PushService.this.state != ServiceState.DESTRUCTING) break block26;
                            return null;
                        }
                        socket = newSocket;
                    }
                    try {
                        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"), 8192);
                    }
                    catch (UnsupportedEncodingException e2) {
                        Parse.logE(PushService.TAG, "unsupported encoding", e2);
                        return null;
                    }
                    catch (IOException e3) {
                        Parse.logE(PushService.TAG, "could not construct reader", e3);
                        return null;
                    }
                    if (PushService.this.state == ServiceState.DESTRUCTING) {
                        return null;
                    }
                    if (!PushService.sendSubscriptionInformation((Context)finalService)) {
                        return null;
                    }
                }
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    return null;
                }
                PushService.resetDelay();
                try {
                    Parse.logD(PushService.TAG, "waiting for a push");
                    String line = this.reader.readLine();
                    return line;
                }
                catch (IOException e) {
                    Parse.logV(PushService.TAG, "Network disconnect; will reconnect to the push service shortly.");
                    return null;
                }
            }

            @Override
            protected void onPostExecute(String line) {
                JSONObject message;
                if (PushService.this.state == ServiceState.DESTRUCTING) {
                    PushService.this.state = ServiceState.STOPPED;
                    return;
                }
                if (line == null) {
                    PushService.this.readInBackground(null);
                    return;
                }
                JSONTokener tokener = new JSONTokener(line);
                try {
                    message = new JSONObject(tokener);
                }
                catch (JSONException e) {
                    Parse.logE(PushService.TAG, "bad json: " + line, e);
                    PushService.this.readInBackground(this.reader);
                    return;
                }
                ParsePushRouter.routePush(finalService, message);
                PushService.this.readInBackground(this.reader);
            }
        };
        this.task.execute((Void[])new Void[0]);
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Socket oldSocket;
        super.onDestroy();
        Parse.logD(TAG, "destroying push service");
        if (this.state == ServiceState.ABORTING) {
            this.state = ServiceState.STOPPED;
            return;
        }
        this.task.cancel(true);
        this.keepAliveTimer.cancel();
        PushService pushService = this;
        synchronized (pushService) {
            this.state = ServiceState.DESTRUCTING;
            oldSocket = socket;
            socket = null;
        }
        if (oldSocket != null) {
            try {
                oldSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServiceState {
        STOPPED,
        ABORTING,
        DESTRUCTING,
        RUNNING;

    }
}

