/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseACL;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import java.util.regex.Pattern;

public class ParseRole
extends ParseObject {
    static final String CLASS_NAME = "_Role";
    private static final Pattern NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z_\\- ]+$");

    ParseRole(boolean isPointer) {
        super(CLASS_NAME, isPointer);
    }

    public ParseRole(String name) {
        this(false);
        this.setName(name);
    }

    public ParseRole(String name, ParseACL acl) {
        this(name);
        this.setACL(acl);
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public String getName() {
        return this.getString("name");
    }

    public ParseRelation getUsers() {
        return this.getRelation("users");
    }

    public ParseRelation getRoles() {
        return this.getRelation("roles");
    }

    protected void validateSave() {
        if (this.getObjectId() == null && this.getName() == null) {
            throw new IllegalStateException("New roles must specify a name.");
        }
        super.validateSave();
    }

    public void put(String key, Object value) {
        if ("name".equals(key)) {
            if (this.getObjectId() != null) {
                throw new IllegalArgumentException("A role's name can only be set before it has been saved.");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("A role's name must be a String.");
            }
            if (!NAME_PATTERN.matcher((String)value).matches()) {
                throw new IllegalArgumentException("A role's name can only contain alphanumeric characters, _, -, and spaces.");
            }
        }
        super.put(key, value);
    }

    public static ParseQuery getQuery() {
        return new ParseQuery(CLASS_NAME);
    }
}

