/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseDeleteOperation;
import com.parse.ParseFieldOperation;
import com.parse.ParseObject;
import com.parse.ParseRelation;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseRelationOperation
implements ParseFieldOperation {
    private String targetClass;
    private Set<String> relationsToAdd;
    private Set<String> relationsToRemove;

    ParseRelationOperation(Set<ParseObject> newRelationsToAdd, Set<ParseObject> newRelationsToRemove) {
        this.targetClass = null;
        this.relationsToAdd = new HashSet<String>();
        this.relationsToRemove = new HashSet<String>();
        if (newRelationsToAdd != null) {
            for (ParseObject object : newRelationsToAdd) {
                if (object.getObjectId() == null) {
                    throw new IllegalArgumentException("All objects in a relation must have object ids.");
                }
                this.relationsToAdd.add(object.getObjectId());
                if (this.targetClass == null) {
                    this.targetClass = object.getClassName();
                    continue;
                }
                if (this.targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (newRelationsToRemove != null) {
            for (ParseObject object : newRelationsToRemove) {
                if (object.getObjectId() == null) {
                    throw new IllegalArgumentException("All objects in a relation must have object ids.");
                }
                this.relationsToRemove.add(object.getObjectId());
                if (this.targetClass == null) {
                    this.targetClass = object.getClassName();
                    continue;
                }
                if (this.targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (this.targetClass == null) {
            throw new IllegalArgumentException("Cannot create a ParseRelationOperation with no objects.");
        }
    }

    private ParseRelationOperation(String newTargetClass, Set<String> newRelationsToAdd, Set<String> newRelationsToRemove) {
        this.targetClass = newTargetClass;
        this.relationsToAdd = new HashSet<String>(newRelationsToAdd);
        this.relationsToRemove = new HashSet<String>(newRelationsToRemove);
    }

    String getTargetClass() {
        return this.targetClass;
    }

    JSONArray convertSetToArray(Set<String> set) throws JSONException {
        JSONArray array = new JSONArray();
        for (String id : set) {
            JSONObject pointer = new JSONObject();
            pointer.put("__type", (Object)"Pointer");
            pointer.put("className", (Object)this.targetClass);
            pointer.put("objectId", (Object)id);
            array.put((Object)pointer);
        }
        return array;
    }

    public JSONObject encode() throws JSONException {
        JSONObject adds = null;
        JSONObject removes = null;
        if (this.relationsToAdd.size() > 0) {
            adds = new JSONObject();
            adds.put("__op", (Object)"AddRelation");
            adds.put("objects", (Object)this.convertSetToArray(this.relationsToAdd));
        }
        if (this.relationsToRemove.size() > 0) {
            removes = new JSONObject();
            removes.put("__op", (Object)"RemoveRelation");
            removes.put("objects", (Object)this.convertSetToArray(this.relationsToRemove));
        }
        if (adds != null && removes != null) {
            JSONObject result = new JSONObject();
            result.put("__op", (Object)"Batch");
            JSONArray ops = new JSONArray();
            ops.put((Object)adds);
            ops.put((Object)removes);
            result.put("ops", (Object)ops);
            return result;
        }
        if (adds != null) {
            return adds;
        }
        if (removes != null) {
            return removes;
        }
        throw new IllegalArgumentException("A ParseRelationOperation was created without any data.");
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            throw new IllegalArgumentException("You can't modify a relation after deleting it.");
        }
        if (previous instanceof ParseRelationOperation) {
            ParseRelationOperation previousOperation = (ParseRelationOperation)previous;
            if (previousOperation.targetClass != null && !previousOperation.targetClass.equals(this.targetClass)) {
                throw new IllegalArgumentException("Related object object must be of class " + previousOperation.targetClass + ", but " + this.targetClass + " was passed in.");
            }
            HashSet<String> newRelationsToAdd = new HashSet<String>(previousOperation.relationsToAdd);
            HashSet<String> newRelationsToRemove = new HashSet<String>(previousOperation.relationsToRemove);
            if (this.relationsToAdd != null) {
                newRelationsToAdd.addAll(this.relationsToAdd);
                newRelationsToRemove.removeAll(this.relationsToAdd);
            }
            if (this.relationsToRemove != null) {
                newRelationsToAdd.removeAll(this.relationsToRemove);
                newRelationsToRemove.addAll(this.relationsToRemove);
            }
            return new ParseRelationOperation(this.targetClass, newRelationsToAdd, newRelationsToRemove);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, ParseObject object, String key) {
        if (oldValue == null) {
            ParseRelation relation = new ParseRelation(object, key);
            relation.setTargetClass(this.targetClass);
            return relation;
        }
        if (oldValue instanceof ParseRelation) {
            ParseRelation relation = (ParseRelation)oldValue;
            if (this.targetClass != null && relation.getTargetClass() != null) {
                if (!relation.getTargetClass().equals(this.targetClass)) {
                    throw new IllegalArgumentException("Related object object must be of class " + relation.getTargetClass() + ", but " + this.targetClass + " was passed in.");
                }
                relation.setTargetClass(this.targetClass);
            }
            return relation;
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }
}

