/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.SaveCallback;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public class ParseInstallation
extends ParseObject {
    private static final String TAG = "com.parse.ParseInstallation";
    static final String CLASS_NAME = "_Installation";
    static ParseInstallation currentInstallation = null;
    private static final String STORAGE_LOCATION = "currentInstallation";
    private static final List<String> readonlyFields = Arrays.asList("deviceType", "installationId", "deviceToken", "timeZone", "appVersion", "appName", "parseVersion");

    ParseInstallation(boolean isPointer) {
        super(CLASS_NAME, isPointer);
        if (!isPointer) {
            super.put("deviceType", "android");
            super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
        }
    }

    ParseInstallation() {
        this(false);
    }

    public static synchronized ParseInstallation getCurrentInstallation() {
        if (currentInstallation != null) {
            return currentInstallation;
        }
        ParseObject installation = ParseInstallation.getFromDisk(Parse.applicationContext, STORAGE_LOCATION);
        if (installation == null) {
            currentInstallation = new ParseInstallation();
        } else {
            currentInstallation = (ParseInstallation)installation;
            Parse.logV(TAG, "Successfully deserialized Installation object");
        }
        return currentInstallation;
    }

    public static ParseQuery getQuery() {
        return new ParseQuery(CLASS_NAME);
    }

    private static synchronized String getOrCreateCurrentInstallationId() {
        String string;
        if (currentInstallation != null) {
            return currentInstallation.getInstallationId();
        }
        File installationIdFile = new File(Parse.getParseDir(), "installationId");
        RandomAccessFile f = null;
        try {
            if (!installationIdFile.exists()) {
                String uuid = UUID.randomUUID().toString();
                f = new RandomAccessFile(installationIdFile, "rw");
                f.writeBytes(uuid);
                f.close();
                String string2 = uuid;
                return string2;
            }
            Parse.logV(TAG, "Reading legacy file for installation ID");
            f = new RandomAccessFile(installationIdFile, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            string = new String(bytes);
        }
        catch (IOException e) {
            String string3 = UUID.randomUUID().toString();
            return string3;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    public String getInstallationId() {
        return this.getString("installationId");
    }

    void checkKeyIsMutable(String key) throws IllegalArgumentException {
        if (readonlyFields.contains(key)) {
            throw new IllegalArgumentException("Cannot change " + key + " property of an installation object.");
        }
    }

    public void put(String key, Object value) throws IllegalArgumentException {
        this.checkKeyIsMutable(key);
        super.put(key, value);
    }

    public void remove(String key) {
        this.checkKeyIsMutable(key);
        super.remove(key);
    }

    protected void save(boolean needsLock) throws ParseException {
        this.updateTimezone();
        this.updateVersionInfo();
        super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
        super.put("deviceType", "android");
        if (needsLock) {
            this.checkIfRunning(true);
        }
        super.save(false);
        ParseInstallation.maybeFlushToDisk(this);
        this.finishedRunning();
    }

    public void saveEventually(SaveCallback callback) {
        this.updateTimezone();
        this.updateVersionInfo();
        super.put("installationId", ParseInstallation.getOrCreateCurrentInstallationId());
        super.put("deviceType", "android");
        super.saveEventually(callback);
    }

    public ParseObject fetch() throws ParseException {
        if (this.getObjectId() == null) {
            this.save();
        }
        ParseObject result = super.fetch();
        ParseInstallation.maybeFlushToDisk(this);
        return result;
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if (zone.indexOf(47) > 0 && !zone.equals(this.get("timeZone"))) {
            super.put("timeZone", zone);
        }
    }

    private void updateVersionInfo() {
        try {
            String packageName = Parse.applicationContext.getPackageName();
            PackageManager pm = Parse.applicationContext.getPackageManager();
            PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
            String appVersion = pkgInfo.versionName;
            String appName = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0)).toString();
            if (appName != null && !appName.equals(this.get("appName"))) {
                super.put("appName", appName);
            }
            if (appVersion != null & !appVersion.equals(this.get("appVersion"))) {
                super.put("appVersion", appVersion);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logW(TAG, "Cannot load package info; will not be saved to installation");
        }
        if (!"1.1.10".equals(this.get("parseVersion"))) {
            super.put("parseVersion", "1.1.10");
        }
    }

    private static synchronized void maybeFlushToDisk(ParseInstallation installation) {
        if (currentInstallation == installation) {
            installation.saveToDisk(Parse.applicationContext, STORAGE_LOCATION);
        }
    }

    static synchronized void clearCurrentInstallationFromDisk(Context context) {
        currentInstallation = null;
        ParseObject.deleteDiskObject(context, STORAGE_LOCATION);
    }
}

