/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import bolts.Task;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.parse.ParseAuthenticationProvider;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class FacebookAuthenticationProvider
extends ParseAuthenticationProvider {
    private static final DateFormat preciseDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
    public static final int DEFAULT_AUTH_ACTIVITY_CODE = 64206;
    public static final String AUTH_TYPE = "facebook";
    private static final String KEY_USER_ID = "id";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_EXPIRATION_DATE = "expiration_date";
    private CallbackManager callbackManager;
    private WeakReference<Activity> baseActivity;
    private WeakReference<Fragment> baseFragment;
    private Collection<String> permissions;
    private LoginAuthorizationType authorizationType = LoginAuthorizationType.READ;

    public FacebookAuthenticationProvider() {
    }

    public FacebookAuthenticationProvider(Context context, int callbackRequestCodeOffset) {
        FacebookSdk.sdkInitialize((Context)context, (int)callbackRequestCodeOffset);
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public synchronized FacebookAuthenticationProvider setActivity(Activity activity) {
        this.baseActivity = new WeakReference<Activity>(activity);
        return this;
    }

    public synchronized FacebookAuthenticationProvider setFragment(Fragment fragment) {
        this.baseFragment = new WeakReference<Fragment>(fragment);
        return this;
    }

    public synchronized FacebookAuthenticationProvider setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public synchronized FacebookAuthenticationProvider setLoginAuthorizationType(LoginAuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
        return this;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean ret = false;
        if (this.callbackManager != null) {
            ret = this.callbackManager.onActivityResult(requestCode, resultCode, data);
            this.callbackManager = null;
        }
        return ret;
    }

    public Task<JSONObject> authenticateAsync() {
        if (this.callbackManager != null) {
            return Task.forError((Exception)new RuntimeException("Unable to authenticate when another authentication is in process"));
        }
        final Task.TaskCompletionSource tcs = Task.create();
        Activity activity = this.baseActivity != null ? (Activity)this.baseActivity.get() : null;
        Fragment fragment = this.baseFragment != null ? (Fragment)this.baseFragment.get() : null;
        LoginManager manager = LoginManager.getInstance();
        this.callbackManager = CallbackManager.Factory.create();
        manager.registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                AccessToken accessToken = loginResult.getAccessToken();
                try {
                    JSONObject authData = FacebookAuthenticationProvider.this.getAuthData(accessToken);
                    tcs.trySetResult((Object)authData);
                }
                catch (JSONException e) {
                    tcs.trySetError((Exception)((Object)e));
                }
            }

            public void onCancel() {
                tcs.trySetCancelled();
            }

            public void onError(FacebookException e) {
                tcs.trySetError((Exception)e);
            }
        });
        if (LoginAuthorizationType.PUBLISH.equals((Object)this.authorizationType)) {
            if (fragment != null) {
                manager.logInWithPublishPermissions(fragment, this.permissions);
            } else {
                manager.logInWithPublishPermissions(activity, this.permissions);
            }
        } else if (fragment != null) {
            manager.logInWithReadPermissions(fragment, this.permissions);
        } else {
            manager.logInWithReadPermissions(activity, this.permissions);
        }
        this.baseActivity = null;
        this.baseFragment = null;
        this.authorizationType = LoginAuthorizationType.READ;
        this.permissions = null;
        return tcs.getTask();
    }

    public synchronized void cancel() {
    }

    public boolean restoreAuthentication(JSONObject authData) {
        if (authData == null) {
            LoginManager.getInstance().logOut();
            return true;
        }
        try {
            AccessToken accessToken = new AccessToken(authData.getString(KEY_ACCESS_TOKEN), FacebookSdk.getApplicationId(), authData.getString(KEY_USER_ID), null, null, null, preciseDateFormat.parse(authData.getString(KEY_EXPIRATION_DATE)), null);
            AccessToken.setCurrentAccessToken((AccessToken)accessToken);
            return true;
        }
        catch (ParseException | JSONException e) {
            return false;
        }
    }

    public void deauthenticate() {
        this.restoreAuthentication(null);
    }

    public JSONObject getAuthData(AccessToken accessToken) throws JSONException {
        JSONObject authData = new JSONObject();
        authData.put(KEY_USER_ID, (Object)accessToken.getUserId());
        authData.put(KEY_ACCESS_TOKEN, (Object)accessToken.getToken());
        authData.put(KEY_EXPIRATION_DATE, (Object)preciseDateFormat.format(accessToken.getExpires()));
        return authData;
    }

    static {
        preciseDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    public static enum LoginAuthorizationType {
        READ,
        PUBLISH;

    }
}

