/*
 * Decompiled with CFR 0.152.
 */
package com.infradna.tool.bridge_method_injector;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.ClassAnnotationInjector;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class MethodInjector {
    private static final String SYNTHETIC_METHODS_ADDED = Type.getDescriptor(BridgeMethodsAdded.class);
    private static final String WITH_SYNTHETIC_METHODS = Type.getDescriptor(WithBridgeMethods.class);

    public void handleRecursively(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File c : files) {
                    this.handleRecursively(c);
                }
            }
        } else if (f.getName().endsWith(".class")) {
            this.handle(f);
        }
    }

    public void handle(File classFile) throws IOException {
        byte[] image;
        try (FileInputStream in = new FileInputStream(classFile);
             BufferedInputStream bis = new BufferedInputStream(in);){
            ClassReader cr = new ClassReader((InputStream)bis);
            ClassWriter cw = new ClassWriter(cr, 1);
            cr.accept((ClassVisitor)new Transformer(new ClassAnnotationInjectorImpl((ClassVisitor)cw)), 0);
            image = cw.toByteArray();
        }
        catch (AlreadyUpToDate unused) {
            return;
        }
        catch (IOException | RuntimeException e) {
            throw new IOException("Failed to process " + classFile, e);
        }
        try (FileOutputStream out = new FileOutputStream(classFile);){
            out.write(image);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user-provided value for running the program")
    public static void main(String[] args) throws IOException {
        MethodInjector mi = new MethodInjector();
        for (String a : args) {
            mi.handleRecursively(new File(a));
        }
    }

    static class Transformer
    extends ClassVisitor {
        private String internalClassName;
        private final List<SyntheticMethod> syntheticMethods = new ArrayList<SyntheticMethod>();

        Transformer(ClassVisitor cv) {
            super(589824, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.internalClassName = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(SYNTHETIC_METHODS_ADDED)) {
                throw new AlreadyUpToDate();
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(final int access, final String name, final String mdesc, final String signature, final String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, mdesc, signature, exceptions);
            return new MethodVisitor(589824, mv){

                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(adesc, visible);
                    if (adesc.equals(WITH_SYNTHETIC_METHODS) && (access & 0x1000) == 0) {
                        return new WithBridgeMethodsAnnotationVisitor(av){

                            public void visitEnd() {
                                super.visitEnd();
                                for (Type type : this.types) {
                                    syntheticMethods.add(new SyntheticMethod(access, name, mdesc, signature, exceptions, type, this.castRequired, this.adapterMethod));
                                }
                            }
                        };
                    }
                    return av;
                }
            };
        }

        public void visitEnd() {
            for (SyntheticMethod m : this.syntheticMethods) {
                m.inject(this.cv);
            }
            super.visitEnd();
        }

        class SyntheticMethod {
            final int access;
            final String name;
            final String desc;
            final String originalSignature;
            final String[] exceptions;
            final boolean castRequired;
            final String adapterMethod;
            final Type returnType;
            final Type originalReturnType;

            SyntheticMethod(int access, String name, String desc, String originalSignature, String[] exceptions, Type returnType, boolean castRequired, String adapterMethod) {
                this.access = access;
                this.name = name;
                this.desc = desc;
                this.originalSignature = originalSignature;
                this.exceptions = exceptions;
                this.returnType = returnType;
                this.castRequired = castRequired;
                this.adapterMethod = adapterMethod;
                this.originalReturnType = Type.getReturnType((String)desc);
            }

            public void inject(ClassVisitor cv) {
                Type[] paramTypes = Type.getArgumentTypes((String)this.desc);
                int access = this.access | 0x1000 | 0x40;
                String methodDescriptor = Type.getMethodDescriptor((Type)this.returnType, (Type[])paramTypes);
                MethodVisitor mv = cv.visitMethod(access, this.name, methodDescriptor, null, this.exceptions);
                if ((access & 0x400) == 0) {
                    boolean isStatic;
                    GeneratorAdapter ga = new GeneratorAdapter(mv, access, this.name, methodDescriptor);
                    mv.visitCode();
                    int sz = 0;
                    if (this.hasAdapterMethod()) {
                        ga.loadThis();
                        ++sz;
                    }
                    boolean bl = isStatic = (access & 8) != 0;
                    if (!isStatic) {
                        ga.loadThis();
                        ++sz;
                    }
                    int argpos = 0;
                    for (Type p : paramTypes) {
                        mv.visitVarInsn(p.getOpcode(21), argpos + (isStatic ? 0 : 1));
                        argpos += p.getSize();
                    }
                    sz += argpos;
                    mv.visitMethodInsn(isStatic ? 184 : 182, Transformer.this.internalClassName, this.name, this.desc, false);
                    if (this.hasAdapterMethod()) {
                        this.insertAdapterMethod(ga);
                    } else if (this.castRequired || this.returnType.equals((Object)Type.VOID_TYPE)) {
                        ga.unbox(this.returnType);
                    } else {
                        ga.box(this.originalReturnType);
                    }
                    if (this.returnType.equals((Object)Type.VOID_TYPE) || this.returnType.getClassName().equals("java.lang.Void")) {
                        switch (this.originalReturnType.getSize()) {
                            case 0: {
                                throw new IllegalArgumentException("Cannot bridge " + this.name + " from void to void; did you mean to use a different type?");
                            }
                            case 1: {
                                mv.visitInsn(87);
                                break;
                            }
                            case 2: {
                                mv.visitInsn(88);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unexpected operand size: " + this.originalReturnType));
                            }
                        }
                    }
                    mv.visitInsn(this.returnType.getOpcode(172));
                    mv.visitMaxs(sz, 0);
                }
                mv.visitEnd();
            }

            private boolean hasAdapterMethod() {
                return this.adapterMethod != null && this.adapterMethod.length() > 0;
            }

            private void insertAdapterMethod(GeneratorAdapter ga) {
                ga.push(this.returnType);
                ga.visitMethodInsn(182, Transformer.this.internalClassName, this.adapterMethod, Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{this.originalReturnType, Type.getType(Class.class)}), false);
                ga.unbox(this.returnType);
            }
        }
    }

    private static class WithBridgeMethodsAnnotationVisitor
    extends AnnotationVisitor {
        protected boolean castRequired = false;
        protected String adapterMethod = null;
        protected final List<Type> types = new ArrayList<Type>();

        public WithBridgeMethodsAnnotationVisitor(AnnotationVisitor av) {
            super(589824, av);
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationVisitor(589824, super.visitArray(name)){

                public void visit(String name, Object value) {
                    if (value instanceof Type) {
                        types.add((Type)value);
                    }
                    super.visit(name, value);
                }
            };
        }

        public void visit(String name, Object value) {
            if ("castRequired".equals(name) && value instanceof Boolean) {
                this.castRequired = (Boolean)value;
            }
            if ("adapterMethod".equals(name) && value instanceof String) {
                this.adapterMethod = (String)value;
            }
            super.visit(name, value);
        }
    }

    static class ClassAnnotationInjectorImpl
    extends ClassAnnotationInjector {
        ClassAnnotationInjectorImpl(ClassVisitor cv) {
            super(cv);
        }

        @Override
        protected void emit() {
            AnnotationVisitor av = this.cv.visitAnnotation(SYNTHETIC_METHODS_ADDED, false);
            av.visitEnd();
        }
    }

    static class AlreadyUpToDate
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AlreadyUpToDate() {
        }
    }
}

