/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Time;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeGenerator
extends GenerationRule<Time, String> {
    private String from;
    private String to;
    private Time.Format format;
    private final String SAMPLE_DATE = "02 Jan 2000";
    private final String SAMPLE_DATE_PATTERN = "dd MMM yyyy";
    private final String ACCEPTED_TIME_PATTERN_12_HOURS = "hh:mm aaa";
    private final String ACCEPTED_TIME_PATTERN_24_HOURS = "HH:mm";
    private long timediff = 0L;
    private long fromMillis = 0L;
    private long toMillis = 0L;
    private final long HOURS_24 = 86400000L;

    public TimeGenerator(Time annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.from = annotation.from();
        this.to = annotation.to();
        this.format = annotation.format();
        String pattern = this.prepareCompleteSampleDateFormat("dd MMM yyyy", ((Time)this.getAnnotation()).format() == Time.Format._12_HOURS ? "hh:mm aaa" : "HH:mm");
        this.from = this.prepareCompleteSampleDate("02 Jan 2000", annotation.from());
        this.to = this.prepareCompleteSampleDate("02 Jan 2000", annotation.to());
        this.fromMillis = this.getTimeMillisFromString(this.from, pattern);
        this.toMillis = this.getTimeMillisFromString(this.to, pattern);
        this.timediff = Math.abs(this.toMillis - this.fromMillis);
        if (this.toMillis < this.fromMillis) {
            this.toMillis += 86400000L;
            this.timediff = Math.abs(this.toMillis - this.fromMillis);
        }
    }

    @Override
    public String generate() {
        String pattern = ((Time)this.getAnnotation()).format() == Time.Format._12_HOURS ? "hh:mm aaa" : "HH:mm";
        long randomTime = (long)((double)this.fromMillis + Math.random() * (double)this.timediff);
        return this.getTimeString(randomTime, pattern);
    }

    private boolean isValidTime(String time) {
        return time != null && !time.isEmpty();
    }

    private String getTimeString(long time, String pattern) {
        Date date = new Date(time);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, Locale.US);
        return simpleDateFormat.format(date);
    }

    private long getTimeMillisFromString(String time, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, Locale.US);
        Date date = null;
        try {
            date = simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            date = Calendar.getInstance().getTime();
        }
        return date.getTime();
    }

    private String prepareCompleteSampleDate(String sampleDate, String time) {
        return String.format("%s %s", sampleDate, time);
    }

    private String prepareCompleteSampleDateFormat(String sampleDateFormat, String timeFormat) {
        return String.format("%s %s", sampleDateFormat, timeFormat);
    }
}

