/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.adapters.ConversionAdapter;
import com.infoedge.jrandomizer.annotations.CollectionDescriptor;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.util.ArrayList;
import java.util.List;

public class RandomListGenerator
extends GenerationRule<CollectionDescriptor, List<Object>> {
    private int min;
    private int max;
    private ConversionAdapter mConversionAdapter;
    private GenerationRule mGenerationRule;

    public RandomListGenerator(CollectionDescriptor annotation, ProviderFactory providerFactory, GenerationRule generationRule, ConversionAdapter conversionAdapter) {
        super(annotation, providerFactory);
        this.max = this.min = 1;
        if (annotation != null) {
            this.min = annotation.min();
            this.max = annotation.max();
        }
        this.mGenerationRule = generationRule;
        this.mConversionAdapter = conversionAdapter;
    }

    @Override
    public List<Object> generate() {
        int random = this.min + this.getRandom().nextInt(this.max - this.min + 1) + 1;
        ArrayList<Object> randomList = new ArrayList<Object>(random);
        for (int i = 0; i < random; ++i) {
            randomList.add(this.mConversionAdapter.value(this.mGenerationRule.generate()));
        }
        return randomList;
    }
}

