/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.adapters.ConversionAdapter;
import com.infoedge.jrandomizer.annotations.CollectionDescriptor;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import java.lang.reflect.Array;

public class RandomArrayGenerator<T>
extends GenerationRule<CollectionDescriptor, Object> {
    private int min;
    private int max;
    private ConversionAdapter mConversionAdapter;
    private GenerationRule mGenerationRule;
    private Class<?> mClazz;

    public RandomArrayGenerator(CollectionDescriptor annotation, ProviderFactory providerFactory, GenerationRule generationRule, ConversionAdapter conversionAdapter, Class<?> clazz) {
        super(annotation, providerFactory);
        this.min = annotation.min();
        this.max = annotation.max();
        this.mGenerationRule = generationRule;
        this.mConversionAdapter = conversionAdapter;
        this.mClazz = clazz;
    }

    @Override
    public Object generate() {
        int random = this.min + this.getRandom().nextInt(this.max - this.min) + 1;
        Object array = Array.newInstance(this.mClazz, random);
        for (int i = 0; i < random; ++i) {
            Array.set(array, i, this.mConversionAdapter.value(this.mGenerationRule.generate()));
        }
        return array;
    }
}

