/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.FirstName;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.FirstNameFemaleProvider;
import com.infoedge.jrandomizer.providers.FirstNameMaleProvider;
import com.infoedge.jrandomizer.providers.FirstNameMixProvider;
import com.infoedge.jrandomizer.providers.Provider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class FirstNameGenerator
extends GenerationRule<FirstName, String> {
    private Provider<String[]> mProvider;

    public FirstNameGenerator(FirstName annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.mProvider = this.loadProvider(annotation.gender());
    }

    @Override
    public String generate() {
        String[] firstNames = this.mProvider.provide();
        int random = this.getRandom().nextInt(firstNames.length);
        return firstNames[random];
    }

    private Provider<String[]> loadProvider(FirstName.Gender gender) {
        switch (gender) {
            case MIX: {
                return ProviderFactory.getInstance().provider(FirstNameMixProvider.class, String[].class);
            }
            case MALE: {
                return ProviderFactory.getInstance().provider(FirstNameMaleProvider.class, String[].class);
            }
            case FEMALE: {
                return ProviderFactory.getInstance().provider(FirstNameFemaleProvider.class, String[].class);
            }
        }
        return ProviderFactory.getInstance().provider(FirstNameMixProvider.class, String[].class);
    }
}

