/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.FileName;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.FileNameProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class FileNameGenerator
extends GenerationRule<FileName, String> {
    private FileNameProvider mProvider;
    private FileName.Types types;
    private FileName.Format format;

    public FileNameGenerator(FileName annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.types = annotation.types();
        this.format = annotation.format();
        this.mProvider = this.providerFactory().provider(FileNameProvider.class, FileNameProvider.FileNameData.class);
    }

    @Override
    public String generate() {
        FileNameProvider.FileNameData fileNameData = (FileNameProvider.FileNameData)this.mProvider.provide();
        String randomFileName = this.randomFileName(fileNameData, this.format);
        String randomFileExtension = this.fileTypesExtension(this.types, fileNameData.extensions);
        return String.format("%s%s", randomFileName, randomFileExtension);
    }

    private String fileTypesExtension(FileName.Types types, FileNameProvider.Extensions extensionsData) {
        String[] extensions = null;
        switch (types) {
            case ALL: {
                extensions = extensionsData.all;
                break;
            }
            case COMMON: {
                extensions = extensionsData.common;
                break;
            }
            case CODE: {
                extensions = extensionsData.code;
                break;
            }
            case DOCUMENT: {
                extensions = extensionsData.document;
                break;
            }
            case IMAGE: {
                extensions = extensionsData.image;
                break;
            }
            case MEDIA: {
                extensions = extensionsData.media;
                break;
            }
            case TEXT: {
                extensions = extensionsData.text;
            }
        }
        int randomIndex = this.getRandom().nextInt(extensions.length);
        return extensions[randomIndex];
    }

    private String randomFileName(FileNameProvider.FileNameData fileNameData, FileName.Format format) {
        int randomIndex = this.getRandom().nextInt(fileNameData.fileNames.length);
        String fileName = fileNameData.fileNames[randomIndex];
        return this.formatFileName(fileName, format);
    }

    private String formatFileName(String fileName, FileName.Format format) {
        if (format == FileName.Format.RANDOM) {
            format = FileName.Format.values()[this.getRandom().nextInt(FileName.Format.values().length)];
        }
        switch (format) {
            case file_name: {
                return fileName.toLowerCase().replaceAll(" ", "_");
            }
            case fileName: {
                return this.firstLetterLower(fileName).replaceAll(" ", "");
            }
            case FileName: {
                return fileName.replaceAll(" ", "");
            }
        }
        return fileName;
    }

    private String firstLetterLower(String name) {
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

