/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer;

public final class Utils {
    private Utils() {
    }

    public static int randomIntWithDigits(int digits) {
        int max = (int)Math.pow(10.0, digits) + 1;
        return Utils.randomIntWithMinMax(0, max);
    }

    public static int randomIntWithMax(int max) {
        return Utils.randomIntWithMinMax(0, max);
    }

    public static int randomIntWithMinMax(int min, int max) {
        return (int)((double)min + Math.random() * (double)(max - min + 1));
    }

    public static long randomLongWithMinMax(long min, long max) {
        return (long)((double)min + Math.random() * (double)(max - min + 1L));
    }

    public static String randomHexOfInt(int min, int max) {
        int randomInt = Utils.randomIntWithMinMax(min, max);
        return Integer.toHexString(randomInt);
    }

    public static String randomHexOfInt(int max) {
        int randomInt = Utils.randomIntWithMinMax(0, max);
        return Integer.toHexString(randomInt);
    }

    public static String randomHexOfLong(long max) {
        long randomInt = Utils.randomLongWithMinMax(0L, max);
        return Long.toHexString(randomInt);
    }

    public static String frontZeroPaddedRandomInt(int digits) {
        String randomInt = String.valueOf(Utils.randomIntWithDigits(digits));
        return Utils.frontPad(randomInt, "0", digits);
    }

    public static String frontPad(String target, String padChar, int length) {
        if (length == 0 || target.length() >= length) {
            return target;
        }
        return Utils.frontPad(padChar + target, padChar, length - 1);
    }

    public static String tailPad(String target, String padChar, int length) {
        if (length == 0 || target.length() >= length) {
            return target;
        }
        return Utils.tailPad(target + padChar, padChar, length);
    }
}

