/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** TfaVerifyPinResponse */
public class TfaVerifyPinResponse {
  public static final String SERIALIZED_NAME_ATTEMPTS_REMAINING = "attemptsRemaining";

  @SerializedName(SERIALIZED_NAME_ATTEMPTS_REMAINING)
  private Integer attemptsRemaining;

  public static final String SERIALIZED_NAME_MSISDN = "msisdn";

  @SerializedName(SERIALIZED_NAME_MSISDN)
  private String msisdn;

  public static final String SERIALIZED_NAME_PIN_ERROR = "pinError";

  @SerializedName(SERIALIZED_NAME_PIN_ERROR)
  private String pinError;

  public static final String SERIALIZED_NAME_PIN_ID = "pinId";

  @SerializedName(SERIALIZED_NAME_PIN_ID)
  private String pinId;

  public static final String SERIALIZED_NAME_VERIFIED = "verified";

  @SerializedName(SERIALIZED_NAME_VERIFIED)
  private Boolean verified;

  /**
   * Number of remaining PIN attempts.
   *
   * @return attemptsRemaining
   */
  public Integer getAttemptsRemaining() {
    return attemptsRemaining;
  }

  /**
   * Phone number (&#x60;MSISDN&#x60;) to which the 2FA message was sent.
   *
   * @return msisdn
   */
  public String getMsisdn() {
    return msisdn;
  }

  /**
   * Indicates if any error occurs during PIN verification.
   *
   * @return pinError
   */
  public String getPinError() {
    return pinError;
  }

  /**
   * Sent PIN code ID.
   *
   * @return pinId
   */
  public String getPinId() {
    return pinId;
  }

  /**
   * Indicates if the phone number (&#x60;MSISDN&#x60;) was successfully verified.
   *
   * @return verified
   */
  public Boolean getVerified() {
    return verified;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TfaVerifyPinResponse tfaVerifyPinResponse = (TfaVerifyPinResponse) o;
    return Objects.equals(this.attemptsRemaining, tfaVerifyPinResponse.attemptsRemaining)
        && Objects.equals(this.msisdn, tfaVerifyPinResponse.msisdn)
        && Objects.equals(this.pinError, tfaVerifyPinResponse.pinError)
        && Objects.equals(this.pinId, tfaVerifyPinResponse.pinId)
        && Objects.equals(this.verified, tfaVerifyPinResponse.verified);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attemptsRemaining, msisdn, pinError, pinId, verified);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TfaVerifyPinResponse {\n");
    sb.append("    attemptsRemaining: ").append(toIndentedString(attemptsRemaining)).append("\n");
    sb.append("    msisdn: ").append(toIndentedString(msisdn)).append("\n");
    sb.append("    pinError: ").append(toIndentedString(pinError)).append("\n");
    sb.append("    pinId: ").append(toIndentedString(pinId)).append("\n");
    sb.append("    verified: ").append(toIndentedString(verified)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
