/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** SmsSendingSpeedLimit */
public class SmsSendingSpeedLimit {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";

  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Integer amount;

  public static final String SERIALIZED_NAME_TIME_UNIT = "timeUnit";

  @SerializedName(SERIALIZED_NAME_TIME_UNIT)
  private SmsSpeedLimitTimeUnit timeUnit = null;

  public SmsSendingSpeedLimit amount(Integer amount) {

    this.amount = amount;
    return this;
  }

  /**
   * The number of messages to send per time unit. By default, Infobip sends your messages as fast
   * as the infrastructure allows. Use this parameter to reduce the traffic if you find the default
   * sending speed too fast for your use case. Note that boosting this parameter will not result in
   * faster sending speeds beyond infrastructure capabilities.
   *
   * @return amount
   */
  public Integer getAmount() {
    return amount;
  }

  public void setAmount(Integer amount) {
    this.amount = amount;
  }

  public SmsSendingSpeedLimit timeUnit(SmsSpeedLimitTimeUnit timeUnit) {

    this.timeUnit = timeUnit;
    return this;
  }

  /**
   * The time unit in which the defined message amount will be sent. The default value is
   * &#x60;MINUTE&#x60;.
   *
   * @return timeUnit
   */
  public SmsSpeedLimitTimeUnit getTimeUnit() {
    return timeUnit;
  }

  public void setTimeUnit(SmsSpeedLimitTimeUnit timeUnit) {
    this.timeUnit = timeUnit;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsSendingSpeedLimit smsSendingSpeedLimit = (SmsSendingSpeedLimit) o;
    return Objects.equals(this.amount, smsSendingSpeedLimit.amount)
        && Objects.equals(this.timeUnit, smsSendingSpeedLimit.timeUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, timeUnit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsSendingSpeedLimit {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    timeUnit: ").append(toIndentedString(timeUnit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
