/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** SmsPreview */
public class SmsPreview {
  public static final String SERIALIZED_NAME_CHARACTERS_REMAINING = "charactersRemaining";

  @SerializedName(SERIALIZED_NAME_CHARACTERS_REMAINING)
  private Integer charactersRemaining;

  public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";

  @SerializedName(SERIALIZED_NAME_CONFIGURATION)
  private SmsLanguageConfiguration _configuration = null;

  public static final String SERIALIZED_NAME_MESSAGE_COUNT = "messageCount";

  @SerializedName(SERIALIZED_NAME_MESSAGE_COUNT)
  private Integer messageCount;

  public static final String SERIALIZED_NAME_TEXT_PREVIEW = "textPreview";

  @SerializedName(SERIALIZED_NAME_TEXT_PREVIEW)
  private String textPreview;

  /**
   * Number of remaining characters in the last SMS part.
   *
   * @return charactersRemaining
   */
  public Integer getCharactersRemaining() {
    return charactersRemaining;
  }

  /**
   * Configuration that, when sent with the original text, results in this preview.
   *
   * @return _configuration
   */
  public SmsLanguageConfiguration getConfiguration() {
    return _configuration;
  }

  /**
   * Number of SMS message parts required to deliver the message.
   *
   * @return messageCount
   */
  public Integer getMessageCount() {
    return messageCount;
  }

  /**
   * Preview of the text as it should appear on the recipient’s device.
   *
   * @return textPreview
   */
  public String getTextPreview() {
    return textPreview;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsPreview smsPreview = (SmsPreview) o;
    return Objects.equals(this.charactersRemaining, smsPreview.charactersRemaining)
        && Objects.equals(this._configuration, smsPreview._configuration)
        && Objects.equals(this.messageCount, smsPreview.messageCount)
        && Objects.equals(this.textPreview, smsPreview.textPreview);
  }

  @Override
  public int hashCode() {
    return Objects.hash(charactersRemaining, _configuration, messageCount, textPreview);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsPreview {\n");
    sb.append("    charactersRemaining: ")
        .append(toIndentedString(charactersRemaining))
        .append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    messageCount: ").append(toIndentedString(messageCount)).append("\n");
    sb.append("    textPreview: ").append(toIndentedString(textPreview)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
