/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** SmsDeliveryTimeWindow */
public class SmsDeliveryTimeWindow {
  public static final String SERIALIZED_NAME_DAYS = "days";

  @SerializedName(SERIALIZED_NAME_DAYS)
  private List<SmsDeliveryDay> days = new ArrayList<>();

  public static final String SERIALIZED_NAME_FROM = "from";

  @SerializedName(SERIALIZED_NAME_FROM)
  private SmsDeliveryTime from = null;

  public static final String SERIALIZED_NAME_TO = "to";

  @SerializedName(SERIALIZED_NAME_TO)
  private SmsDeliveryTime to = null;

  public SmsDeliveryTimeWindow days(List<SmsDeliveryDay> days) {

    this.days = days;
    return this;
  }

  public SmsDeliveryTimeWindow addDaysItem(SmsDeliveryDay daysItem) {
    this.days.add(daysItem);
    return this;
  }

  /**
   * Days which are included in the delivery time window. Values are: &#x60;MONDAY&#x60;,
   * &#x60;TUESDAY&#x60;, &#x60;WEDNESDAY&#x60;, &#x60;THURSDAY&#x60;, &#x60;FRIDAY&#x60;,
   * &#x60;SATURDAY&#x60;, &#x60;SUNDAY&#x60;. At least one day must be stated.
   *
   * @return days
   */
  public List<SmsDeliveryDay> getDays() {
    return days;
  }

  public void setDays(List<SmsDeliveryDay> days) {
    this.days = days;
  }

  public SmsDeliveryTimeWindow from(SmsDeliveryTime from) {

    this.from = from;
    return this;
  }

  /**
   * Exact time of day in which the sending can start. Consists of hour and minute properties, both
   * mandatory. Time is expressed in the UTC time zone.
   *
   * @return from
   */
  public SmsDeliveryTime getFrom() {
    return from;
  }

  public void setFrom(SmsDeliveryTime from) {
    this.from = from;
  }

  public SmsDeliveryTimeWindow to(SmsDeliveryTime to) {

    this.to = to;
    return this;
  }

  /**
   * Exact time of day in which the sending will end. Consists of an hour and minute properties,
   * both mandatory. Time is expressed in the UTC time zone.
   *
   * @return to
   */
  public SmsDeliveryTime getTo() {
    return to;
  }

  public void setTo(SmsDeliveryTime to) {
    this.to = to;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsDeliveryTimeWindow smsDeliveryTimeWindow = (SmsDeliveryTimeWindow) o;
    return Objects.equals(this.days, smsDeliveryTimeWindow.days)
        && Objects.equals(this.from, smsDeliveryTimeWindow.from)
        && Objects.equals(this.to, smsDeliveryTimeWindow.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(days, from, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsDeliveryTimeWindow {\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
