/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.TfaApplicationRequest;
import com.infobip.model.TfaApplicationResponse;
import com.infobip.model.TfaCreateMessageRequest;
import com.infobip.model.TfaMessage;
import com.infobip.model.TfaResendPinRequest;
import com.infobip.model.TfaStartAuthenticationRequest;
import com.infobip.model.TfaStartAuthenticationResponse;
import com.infobip.model.TfaUpdateMessageRequest;
import com.infobip.model.TfaVerificationResponse;
import com.infobip.model.TfaVerifyPinRequest;
import com.infobip.model.TfaVerifyPinResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TfaApi {
  private ApiClient localVarApiClient;

  public TfaApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TfaApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  /**
   * Build call for createTfaApplication.
   *
   * @param tfaApplicationRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call createTfaApplicationCall(
      TfaApplicationRequest tfaApplicationRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaApplicationRequest;

    // create path and map variables
    String localVarPath = "/2fa/2/applications";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createTfaApplicationValidateBeforeCall(
      TfaApplicationRequest tfaApplicationRequest, final ApiCallback _callback)
      throws ApiException {

    okhttp3.Call localVarCall = createTfaApplicationCall(tfaApplicationRequest, _callback);
    return localVarCall;
  }

  /**
   * Create 2FA application. Create and configure a new 2FA application.
   *
   * @param tfaApplicationRequest (optional)
   * @return TfaApplicationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaApplicationResponse createTfaApplication(TfaApplicationRequest tfaApplicationRequest)
      throws ApiException {
    ApiResponse<TfaApplicationResponse> localVarResp =
        createTfaApplicationWithHttpInfo(tfaApplicationRequest);
    return localVarResp.getData();
  }

  /**
   * Create 2FA application. Create and configure a new 2FA application.
   *
   * @param tfaApplicationRequest (optional)
   * @return ApiResponse&lt;TfaApplicationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaApplicationResponse> createTfaApplicationWithHttpInfo(
      TfaApplicationRequest tfaApplicationRequest) throws ApiException {
    okhttp3.Call localVarCall = createTfaApplicationValidateBeforeCall(tfaApplicationRequest, null);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create 2FA application (asynchronously). Create and configure a new 2FA application.
   *
   * @param tfaApplicationRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call createTfaApplicationAsync(
      TfaApplicationRequest tfaApplicationRequest,
      final ApiCallback<TfaApplicationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createTfaApplicationValidateBeforeCall(tfaApplicationRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for createTfaMessageTemplate.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param tfaCreateMessageRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call createTfaMessageTemplateCall(
      String appId, TfaCreateMessageRequest tfaCreateMessageRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaCreateMessageRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}/messages"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createTfaMessageTemplateValidateBeforeCall(
      String appId, TfaCreateMessageRequest tfaCreateMessageRequest, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling createTfaMessageTemplate(Async)");
    }

    okhttp3.Call localVarCall =
        createTfaMessageTemplateCall(appId, tfaCreateMessageRequest, _callback);
    return localVarCall;
  }

  /**
   * Create 2FA message template. Once you have your [2FA
   * application](#channels/sms/create-2fa-message-template), create one or more message templates
   * where your PIN will be dynamically included when you send the PIN message.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param tfaCreateMessageRequest (optional)
   * @return TfaMessage
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaMessage createTfaMessageTemplate(
      String appId, TfaCreateMessageRequest tfaCreateMessageRequest) throws ApiException {
    ApiResponse<TfaMessage> localVarResp =
        createTfaMessageTemplateWithHttpInfo(appId, tfaCreateMessageRequest);
    return localVarResp.getData();
  }

  /**
   * Create 2FA message template. Once you have your [2FA
   * application](#channels/sms/create-2fa-message-template), create one or more message templates
   * where your PIN will be dynamically included when you send the PIN message.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param tfaCreateMessageRequest (optional)
   * @return ApiResponse&lt;TfaMessage&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaMessage> createTfaMessageTemplateWithHttpInfo(
      String appId, TfaCreateMessageRequest tfaCreateMessageRequest) throws ApiException {
    okhttp3.Call localVarCall =
        createTfaMessageTemplateValidateBeforeCall(appId, tfaCreateMessageRequest, null);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create 2FA message template (asynchronously). Once you have your [2FA
   * application](#channels/sms/create-2fa-message-template), create one or more message templates
   * where your PIN will be dynamically included when you send the PIN message.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param tfaCreateMessageRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call createTfaMessageTemplateAsync(
      String appId,
      TfaCreateMessageRequest tfaCreateMessageRequest,
      final ApiCallback<TfaMessage> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createTfaMessageTemplateValidateBeforeCall(appId, tfaCreateMessageRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTfaApplication.
   *
   * @param appId Requested application ID. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaApplicationCall(String appId, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTfaApplicationValidateBeforeCall(
      String appId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling getTfaApplication(Async)");
    }

    okhttp3.Call localVarCall = getTfaApplicationCall(appId, _callback);
    return localVarCall;
  }

  /**
   * Get 2FA application. Get a single 2FA application to see its configuration details.
   *
   * @param appId Requested application ID. (required)
   * @return TfaApplicationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaApplicationResponse getTfaApplication(String appId) throws ApiException {
    ApiResponse<TfaApplicationResponse> localVarResp = getTfaApplicationWithHttpInfo(appId);
    return localVarResp.getData();
  }

  /**
   * Get 2FA application. Get a single 2FA application to see its configuration details.
   *
   * @param appId Requested application ID. (required)
   * @return ApiResponse&lt;TfaApplicationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaApplicationResponse> getTfaApplicationWithHttpInfo(String appId)
      throws ApiException {
    okhttp3.Call localVarCall = getTfaApplicationValidateBeforeCall(appId, null);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get 2FA application (asynchronously). Get a single 2FA application to see its configuration
   * details.
   *
   * @param appId Requested application ID. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaApplicationAsync(
      String appId, final ApiCallback<TfaApplicationResponse> _callback) throws ApiException {

    okhttp3.Call localVarCall = getTfaApplicationValidateBeforeCall(appId, _callback);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTfaApplications.
   *
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaApplicationsCall(final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/2fa/2/applications";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTfaApplicationsValidateBeforeCall(final ApiCallback _callback)
      throws ApiException {

    okhttp3.Call localVarCall = getTfaApplicationsCall(_callback);
    return localVarCall;
  }

  /**
   * Get 2FA applications. An application is a container for 2FA message templates. Use this method
   * to list your applications.
   *
   * @return List&lt;TfaApplicationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public List<TfaApplicationResponse> getTfaApplications() throws ApiException {
    ApiResponse<List<TfaApplicationResponse>> localVarResp = getTfaApplicationsWithHttpInfo();
    return localVarResp.getData();
  }

  /**
   * Get 2FA applications. An application is a container for 2FA message templates. Use this method
   * to list your applications.
   *
   * @return ApiResponse&lt;List&lt;TfaApplicationResponse&gt;&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<List<TfaApplicationResponse>> getTfaApplicationsWithHttpInfo()
      throws ApiException {
    okhttp3.Call localVarCall = getTfaApplicationsValidateBeforeCall(null);
    Type localVarReturnType = new TypeToken<List<TfaApplicationResponse>>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get 2FA applications (asynchronously). An application is a container for 2FA message templates.
   * Use this method to list your applications.
   *
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaApplicationsAsync(
      final ApiCallback<List<TfaApplicationResponse>> _callback) throws ApiException {

    okhttp3.Call localVarCall = getTfaApplicationsValidateBeforeCall(_callback);
    Type localVarReturnType = new TypeToken<List<TfaApplicationResponse>>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTfaMessageTemplate.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaMessageTemplateCall(
      String appId, String msgId, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}/messages/{msgId}"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "msgId" + "\\}", localVarApiClient.escapeString(msgId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTfaMessageTemplateValidateBeforeCall(
      String appId, String msgId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling getTfaMessageTemplate(Async)");
    }

    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(
          "Missing the required parameter 'msgId' when calling getTfaMessageTemplate(Async)");
    }

    okhttp3.Call localVarCall = getTfaMessageTemplateCall(appId, msgId, _callback);
    return localVarCall;
  }

  /**
   * Get 2FA message template. Get a single 2FA message template from an application to see its
   * configuration details.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @return TfaMessage
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaMessage getTfaMessageTemplate(String appId, String msgId) throws ApiException {
    ApiResponse<TfaMessage> localVarResp = getTfaMessageTemplateWithHttpInfo(appId, msgId);
    return localVarResp.getData();
  }

  /**
   * Get 2FA message template. Get a single 2FA message template from an application to see its
   * configuration details.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @return ApiResponse&lt;TfaMessage&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaMessage> getTfaMessageTemplateWithHttpInfo(String appId, String msgId)
      throws ApiException {
    okhttp3.Call localVarCall = getTfaMessageTemplateValidateBeforeCall(appId, msgId, null);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get 2FA message template (asynchronously). Get a single 2FA message template from an
   * application to see its configuration details.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaMessageTemplateAsync(
      String appId, String msgId, final ApiCallback<TfaMessage> _callback) throws ApiException {

    okhttp3.Call localVarCall = getTfaMessageTemplateValidateBeforeCall(appId, msgId, _callback);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTfaMessageTemplates.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaMessageTemplatesCall(String appId, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}/messages"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTfaMessageTemplatesValidateBeforeCall(
      String appId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling getTfaMessageTemplates(Async)");
    }

    okhttp3.Call localVarCall = getTfaMessageTemplatesCall(appId, _callback);
    return localVarCall;
  }

  /**
   * Get 2FA message templates. List all message templates in a 2FA application.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @return List&lt;TfaMessage&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public List<TfaMessage> getTfaMessageTemplates(String appId) throws ApiException {
    ApiResponse<List<TfaMessage>> localVarResp = getTfaMessageTemplatesWithHttpInfo(appId);
    return localVarResp.getData();
  }

  /**
   * Get 2FA message templates. List all message templates in a 2FA application.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @return ApiResponse&lt;List&lt;TfaMessage&gt;&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<List<TfaMessage>> getTfaMessageTemplatesWithHttpInfo(String appId)
      throws ApiException {
    okhttp3.Call localVarCall = getTfaMessageTemplatesValidateBeforeCall(appId, null);
    Type localVarReturnType = new TypeToken<List<TfaMessage>>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get 2FA message templates (asynchronously). List all message templates in a 2FA application.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaMessageTemplatesAsync(
      String appId, final ApiCallback<List<TfaMessage>> _callback) throws ApiException {

    okhttp3.Call localVarCall = getTfaMessageTemplatesValidateBeforeCall(appId, _callback);
    Type localVarReturnType = new TypeToken<List<TfaMessage>>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTfaVerificationStatus.
   *
   * @param msisdn Filter by msisdn (phone number) for which verification status is checked.
   *     (required)
   * @param appId ID of 2-FA application for which phone number verification status is requested.
   *     (required)
   * @param verified Filter by verified (true or false). (optional)
   * @param sent Filter by message sent status (true or false). (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaVerificationStatusCall(
      String msisdn, String appId, Boolean verified, Boolean sent, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}/verifications"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (msisdn != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("msisdn", msisdn));
    }

    if (verified != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("verified", verified));
    }

    if (sent != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("sent", sent));
    }

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTfaVerificationStatusValidateBeforeCall(
      String msisdn, String appId, Boolean verified, Boolean sent, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'msisdn' is set
    if (msisdn == null) {
      throw new ApiException(
          "Missing the required parameter 'msisdn' when calling getTfaVerificationStatus(Async)");
    }

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling getTfaVerificationStatus(Async)");
    }

    okhttp3.Call localVarCall =
        getTfaVerificationStatusCall(msisdn, appId, verified, sent, _callback);
    return localVarCall;
  }

  /**
   * Get 2FA verification status. Check if a phone number is already verified for a specific 2FA
   * application.
   *
   * @param msisdn Filter by msisdn (phone number) for which verification status is checked.
   *     (required)
   * @param appId ID of 2-FA application for which phone number verification status is requested.
   *     (required)
   * @param verified Filter by verified (true or false). (optional)
   * @param sent Filter by message sent status (true or false). (optional)
   * @return TfaVerificationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaVerificationResponse getTfaVerificationStatus(
      String msisdn, String appId, Boolean verified, Boolean sent) throws ApiException {
    ApiResponse<TfaVerificationResponse> localVarResp =
        getTfaVerificationStatusWithHttpInfo(msisdn, appId, verified, sent);
    return localVarResp.getData();
  }

  /**
   * Get 2FA verification status. Check if a phone number is already verified for a specific 2FA
   * application.
   *
   * @param msisdn Filter by msisdn (phone number) for which verification status is checked.
   *     (required)
   * @param appId ID of 2-FA application for which phone number verification status is requested.
   *     (required)
   * @param verified Filter by verified (true or false). (optional)
   * @param sent Filter by message sent status (true or false). (optional)
   * @return ApiResponse&lt;TfaVerificationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaVerificationResponse> getTfaVerificationStatusWithHttpInfo(
      String msisdn, String appId, Boolean verified, Boolean sent) throws ApiException {
    okhttp3.Call localVarCall =
        getTfaVerificationStatusValidateBeforeCall(msisdn, appId, verified, sent, null);
    Type localVarReturnType = new TypeToken<TfaVerificationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get 2FA verification status (asynchronously). Check if a phone number is already verified for a
   * specific 2FA application.
   *
   * @param msisdn Filter by msisdn (phone number) for which verification status is checked.
   *     (required)
   * @param appId ID of 2-FA application for which phone number verification status is requested.
   *     (required)
   * @param verified Filter by verified (true or false). (optional)
   * @param sent Filter by message sent status (true or false). (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call getTfaVerificationStatusAsync(
      String msisdn,
      String appId,
      Boolean verified,
      Boolean sent,
      final ApiCallback<TfaVerificationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getTfaVerificationStatusValidateBeforeCall(msisdn, appId, verified, sent, _callback);
    Type localVarReturnType = new TypeToken<TfaVerificationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for resendTfaPinCodeOverSms.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call resendTfaPinCodeOverSmsCall(
      String pinId, TfaResendPinRequest tfaResendPinRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaResendPinRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/pin/{pinId}/resend"
            .replaceAll("\\{" + "pinId" + "\\}", localVarApiClient.escapeString(pinId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call resendTfaPinCodeOverSmsValidateBeforeCall(
      String pinId, TfaResendPinRequest tfaResendPinRequest, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'pinId' is set
    if (pinId == null) {
      throw new ApiException(
          "Missing the required parameter 'pinId' when calling resendTfaPinCodeOverSms(Async)");
    }

    okhttp3.Call localVarCall = resendTfaPinCodeOverSmsCall(pinId, tfaResendPinRequest, _callback);
    return localVarCall;
  }

  /**
   * Resend 2FA PIN code over SMS. If needed, you can resend the same (previously sent) PIN code
   * over SMS.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @return TfaStartAuthenticationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaStartAuthenticationResponse resendTfaPinCodeOverSms(
      String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
    ApiResponse<TfaStartAuthenticationResponse> localVarResp =
        resendTfaPinCodeOverSmsWithHttpInfo(pinId, tfaResendPinRequest);
    return localVarResp.getData();
  }

  /**
   * Resend 2FA PIN code over SMS. If needed, you can resend the same (previously sent) PIN code
   * over SMS.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @return ApiResponse&lt;TfaStartAuthenticationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaStartAuthenticationResponse> resendTfaPinCodeOverSmsWithHttpInfo(
      String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
    okhttp3.Call localVarCall =
        resendTfaPinCodeOverSmsValidateBeforeCall(pinId, tfaResendPinRequest, null);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Resend 2FA PIN code over SMS (asynchronously). If needed, you can resend the same (previously
   * sent) PIN code over SMS.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call resendTfaPinCodeOverSmsAsync(
      String pinId,
      TfaResendPinRequest tfaResendPinRequest,
      final ApiCallback<TfaStartAuthenticationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        resendTfaPinCodeOverSmsValidateBeforeCall(pinId, tfaResendPinRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for resendTfaPinCodeOverVoice.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call resendTfaPinCodeOverVoiceCall(
      String pinId, TfaResendPinRequest tfaResendPinRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaResendPinRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/pin/{pinId}/resend/voice"
            .replaceAll("\\{" + "pinId" + "\\}", localVarApiClient.escapeString(pinId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call resendTfaPinCodeOverVoiceValidateBeforeCall(
      String pinId, TfaResendPinRequest tfaResendPinRequest, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'pinId' is set
    if (pinId == null) {
      throw new ApiException(
          "Missing the required parameter 'pinId' when calling resendTfaPinCodeOverVoice(Async)");
    }

    okhttp3.Call localVarCall =
        resendTfaPinCodeOverVoiceCall(pinId, tfaResendPinRequest, _callback);
    return localVarCall;
  }

  /**
   * Resend 2FA PIN code over Voice. If needed, you can resend the same (previously sent) PIN code
   * over Voice.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @return TfaStartAuthenticationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaStartAuthenticationResponse resendTfaPinCodeOverVoice(
      String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
    ApiResponse<TfaStartAuthenticationResponse> localVarResp =
        resendTfaPinCodeOverVoiceWithHttpInfo(pinId, tfaResendPinRequest);
    return localVarResp.getData();
  }

  /**
   * Resend 2FA PIN code over Voice. If needed, you can resend the same (previously sent) PIN code
   * over Voice.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @return ApiResponse&lt;TfaStartAuthenticationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaStartAuthenticationResponse> resendTfaPinCodeOverVoiceWithHttpInfo(
      String pinId, TfaResendPinRequest tfaResendPinRequest) throws ApiException {
    okhttp3.Call localVarCall =
        resendTfaPinCodeOverVoiceValidateBeforeCall(pinId, tfaResendPinRequest, null);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Resend 2FA PIN code over Voice (asynchronously). If needed, you can resend the same (previously
   * sent) PIN code over Voice.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaResendPinRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call resendTfaPinCodeOverVoiceAsync(
      String pinId,
      TfaResendPinRequest tfaResendPinRequest,
      final ApiCallback<TfaStartAuthenticationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        resendTfaPinCodeOverVoiceValidateBeforeCall(pinId, tfaResendPinRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendTfaPinCodeOverSms.
   *
   * @param ncNeeded Indicates if Number Lookup is needed before sending the 2FA message. If the
   *     parameter value is true, Number Lookup will be requested before sending the SMS. If the
   *     value is false, the SMS will be sent without requesting Number Lookup. Field&#39;s default
   *     value is &#x60;true&#x60;. (optional)
   * @param tfaStartAuthenticationRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call sendTfaPinCodeOverSmsCall(
      Boolean ncNeeded,
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest,
      final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaStartAuthenticationRequest;

    // create path and map variables
    String localVarPath = "/2fa/2/pin";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (ncNeeded != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("ncNeeded", ncNeeded));
    }

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendTfaPinCodeOverSmsValidateBeforeCall(
      Boolean ncNeeded,
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest,
      final ApiCallback _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendTfaPinCodeOverSmsCall(ncNeeded, tfaStartAuthenticationRequest, _callback);
    return localVarCall;
  }

  /**
   * Send 2FA PIN code over SMS. Send a PIN code over SMS using a previously created [message
   * template](#channels/sms/create-2fa-message-template).
   *
   * @param ncNeeded Indicates if Number Lookup is needed before sending the 2FA message. If the
   *     parameter value is true, Number Lookup will be requested before sending the SMS. If the
   *     value is false, the SMS will be sent without requesting Number Lookup. Field&#39;s default
   *     value is &#x60;true&#x60;. (optional)
   * @param tfaStartAuthenticationRequest (optional)
   * @return TfaStartAuthenticationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaStartAuthenticationResponse sendTfaPinCodeOverSms(
      Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest)
      throws ApiException {
    ApiResponse<TfaStartAuthenticationResponse> localVarResp =
        sendTfaPinCodeOverSmsWithHttpInfo(ncNeeded, tfaStartAuthenticationRequest);
    return localVarResp.getData();
  }

  /**
   * Send 2FA PIN code over SMS. Send a PIN code over SMS using a previously created [message
   * template](#channels/sms/create-2fa-message-template).
   *
   * @param ncNeeded Indicates if Number Lookup is needed before sending the 2FA message. If the
   *     parameter value is true, Number Lookup will be requested before sending the SMS. If the
   *     value is false, the SMS will be sent without requesting Number Lookup. Field&#39;s default
   *     value is &#x60;true&#x60;. (optional)
   * @param tfaStartAuthenticationRequest (optional)
   * @return ApiResponse&lt;TfaStartAuthenticationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaStartAuthenticationResponse> sendTfaPinCodeOverSmsWithHttpInfo(
      Boolean ncNeeded, TfaStartAuthenticationRequest tfaStartAuthenticationRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        sendTfaPinCodeOverSmsValidateBeforeCall(ncNeeded, tfaStartAuthenticationRequest, null);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send 2FA PIN code over SMS (asynchronously). Send a PIN code over SMS using a previously
   * created [message template](#channels/sms/create-2fa-message-template).
   *
   * @param ncNeeded Indicates if Number Lookup is needed before sending the 2FA message. If the
   *     parameter value is true, Number Lookup will be requested before sending the SMS. If the
   *     value is false, the SMS will be sent without requesting Number Lookup. Field&#39;s default
   *     value is &#x60;true&#x60;. (optional)
   * @param tfaStartAuthenticationRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call sendTfaPinCodeOverSmsAsync(
      Boolean ncNeeded,
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest,
      final ApiCallback<TfaStartAuthenticationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendTfaPinCodeOverSmsValidateBeforeCall(ncNeeded, tfaStartAuthenticationRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendTfaPinCodeOverVoice.
   *
   * @param tfaStartAuthenticationRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call sendTfaPinCodeOverVoiceCall(
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaStartAuthenticationRequest;

    // create path and map variables
    String localVarPath = "/2fa/2/pin/voice";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendTfaPinCodeOverVoiceValidateBeforeCall(
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest, final ApiCallback _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendTfaPinCodeOverVoiceCall(tfaStartAuthenticationRequest, _callback);
    return localVarCall;
  }

  /**
   * Send 2FA PIN code over Voice. Send a PIN code over Voice using previously created [message
   * template](#channels/sms/create-2fa-message-template).
   *
   * @param tfaStartAuthenticationRequest (optional)
   * @return TfaStartAuthenticationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaStartAuthenticationResponse sendTfaPinCodeOverVoice(
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
    ApiResponse<TfaStartAuthenticationResponse> localVarResp =
        sendTfaPinCodeOverVoiceWithHttpInfo(tfaStartAuthenticationRequest);
    return localVarResp.getData();
  }

  /**
   * Send 2FA PIN code over Voice. Send a PIN code over Voice using previously created [message
   * template](#channels/sms/create-2fa-message-template).
   *
   * @param tfaStartAuthenticationRequest (optional)
   * @return ApiResponse&lt;TfaStartAuthenticationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaStartAuthenticationResponse> sendTfaPinCodeOverVoiceWithHttpInfo(
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest) throws ApiException {
    okhttp3.Call localVarCall =
        sendTfaPinCodeOverVoiceValidateBeforeCall(tfaStartAuthenticationRequest, null);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send 2FA PIN code over Voice (asynchronously). Send a PIN code over Voice using previously
   * created [message template](#channels/sms/create-2fa-message-template).
   *
   * @param tfaStartAuthenticationRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call sendTfaPinCodeOverVoiceAsync(
      TfaStartAuthenticationRequest tfaStartAuthenticationRequest,
      final ApiCallback<TfaStartAuthenticationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendTfaPinCodeOverVoiceValidateBeforeCall(tfaStartAuthenticationRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaStartAuthenticationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for updateTfaApplication.
   *
   * @param appId ID of application that should be updated. (required)
   * @param tfaApplicationRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call updateTfaApplicationCall(
      String appId, TfaApplicationRequest tfaApplicationRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaApplicationRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call updateTfaApplicationValidateBeforeCall(
      String appId, TfaApplicationRequest tfaApplicationRequest, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling updateTfaApplication(Async)");
    }

    okhttp3.Call localVarCall = updateTfaApplicationCall(appId, tfaApplicationRequest, _callback);
    return localVarCall;
  }

  /**
   * Update 2FA application. Change configuration options for your existing 2FA application.
   *
   * @param appId ID of application that should be updated. (required)
   * @param tfaApplicationRequest (optional)
   * @return TfaApplicationResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaApplicationResponse updateTfaApplication(
      String appId, TfaApplicationRequest tfaApplicationRequest) throws ApiException {
    ApiResponse<TfaApplicationResponse> localVarResp =
        updateTfaApplicationWithHttpInfo(appId, tfaApplicationRequest);
    return localVarResp.getData();
  }

  /**
   * Update 2FA application. Change configuration options for your existing 2FA application.
   *
   * @param appId ID of application that should be updated. (required)
   * @param tfaApplicationRequest (optional)
   * @return ApiResponse&lt;TfaApplicationResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaApplicationResponse> updateTfaApplicationWithHttpInfo(
      String appId, TfaApplicationRequest tfaApplicationRequest) throws ApiException {
    okhttp3.Call localVarCall =
        updateTfaApplicationValidateBeforeCall(appId, tfaApplicationRequest, null);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Update 2FA application (asynchronously). Change configuration options for your existing 2FA
   * application.
   *
   * @param appId ID of application that should be updated. (required)
   * @param tfaApplicationRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call updateTfaApplicationAsync(
      String appId,
      TfaApplicationRequest tfaApplicationRequest,
      final ApiCallback<TfaApplicationResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        updateTfaApplicationValidateBeforeCall(appId, tfaApplicationRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaApplicationResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for updateTfaMessageTemplate.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param tfaUpdateMessageRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call updateTfaMessageTemplateCall(
      String appId,
      String msgId,
      TfaUpdateMessageRequest tfaUpdateMessageRequest,
      final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaUpdateMessageRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/applications/{appId}/messages/{msgId}"
            .replaceAll("\\{" + "appId" + "\\}", localVarApiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "msgId" + "\\}", localVarApiClient.escapeString(msgId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call updateTfaMessageTemplateValidateBeforeCall(
      String appId,
      String msgId,
      TfaUpdateMessageRequest tfaUpdateMessageRequest,
      final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'appId' is set
    if (appId == null) {
      throw new ApiException(
          "Missing the required parameter 'appId' when calling updateTfaMessageTemplate(Async)");
    }

    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(
          "Missing the required parameter 'msgId' when calling updateTfaMessageTemplate(Async)");
    }

    okhttp3.Call localVarCall =
        updateTfaMessageTemplateCall(appId, msgId, tfaUpdateMessageRequest, _callback);
    return localVarCall;
  }

  /**
   * Update 2FA message template. Change configuration options for your existing 2FA application
   * message template.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param tfaUpdateMessageRequest (optional)
   * @return TfaMessage
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaMessage updateTfaMessageTemplate(
      String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest)
      throws ApiException {
    ApiResponse<TfaMessage> localVarResp =
        updateTfaMessageTemplateWithHttpInfo(appId, msgId, tfaUpdateMessageRequest);
    return localVarResp.getData();
  }

  /**
   * Update 2FA message template. Change configuration options for your existing 2FA application
   * message template.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param tfaUpdateMessageRequest (optional)
   * @return ApiResponse&lt;TfaMessage&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaMessage> updateTfaMessageTemplateWithHttpInfo(
      String appId, String msgId, TfaUpdateMessageRequest tfaUpdateMessageRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        updateTfaMessageTemplateValidateBeforeCall(appId, msgId, tfaUpdateMessageRequest, null);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Update 2FA message template (asynchronously). Change configuration options for your existing
   * 2FA application message template.
   *
   * @param appId ID of application for which requested message was created. (required)
   * @param msgId Requested message ID. (required)
   * @param tfaUpdateMessageRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call updateTfaMessageTemplateAsync(
      String appId,
      String msgId,
      TfaUpdateMessageRequest tfaUpdateMessageRequest,
      final ApiCallback<TfaMessage> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        updateTfaMessageTemplateValidateBeforeCall(
            appId, msgId, tfaUpdateMessageRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaMessage>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for verifyTfaPhoneNumber.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaVerifyPinRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call verifyTfaPhoneNumberCall(
      String pinId, TfaVerifyPinRequest tfaVerifyPinRequest, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = tfaVerifyPinRequest;

    // create path and map variables
    String localVarPath =
        "/2fa/2/pin/{pinId}/verify"
            .replaceAll("\\{" + "pinId" + "\\}", localVarApiClient.escapeString(pinId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call verifyTfaPhoneNumberValidateBeforeCall(
      String pinId, TfaVerifyPinRequest tfaVerifyPinRequest, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'pinId' is set
    if (pinId == null) {
      throw new ApiException(
          "Missing the required parameter 'pinId' when calling verifyTfaPhoneNumber(Async)");
    }

    okhttp3.Call localVarCall = verifyTfaPhoneNumberCall(pinId, tfaVerifyPinRequest, _callback);
    return localVarCall;
  }

  /**
   * Verify phone number. Verify a phone number to confirm successful 2FA authentication.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaVerifyPinRequest (optional)
   * @return TfaVerifyPinResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public TfaVerifyPinResponse verifyTfaPhoneNumber(
      String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) throws ApiException {
    ApiResponse<TfaVerifyPinResponse> localVarResp =
        verifyTfaPhoneNumberWithHttpInfo(pinId, tfaVerifyPinRequest);
    return localVarResp.getData();
  }

  /**
   * Verify phone number. Verify a phone number to confirm successful 2FA authentication.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaVerifyPinRequest (optional)
   * @return ApiResponse&lt;TfaVerifyPinResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public ApiResponse<TfaVerifyPinResponse> verifyTfaPhoneNumberWithHttpInfo(
      String pinId, TfaVerifyPinRequest tfaVerifyPinRequest) throws ApiException {
    okhttp3.Call localVarCall =
        verifyTfaPhoneNumberValidateBeforeCall(pinId, tfaVerifyPinRequest, null);
    Type localVarReturnType = new TypeToken<TfaVerifyPinResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Verify phone number (asynchronously). Verify a phone number to confirm successful 2FA
   * authentication.
   *
   * @param pinId ID of the pin code that has to be verified. (required)
   * @param tfaVerifyPinRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/use-cases/two-factor-authentication-over-api">Read
   *     me first: Introduction and use cases</a>
   */
  public okhttp3.Call verifyTfaPhoneNumberAsync(
      String pinId,
      TfaVerifyPinRequest tfaVerifyPinRequest,
      final ApiCallback<TfaVerifyPinResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        verifyTfaPhoneNumberValidateBeforeCall(pinId, tfaVerifyPinRequest, _callback);
    Type localVarReturnType = new TypeToken<TfaVerifyPinResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
