/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.reactive.internal;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.WriteApi;
import com.influxdb.client.domain.WriteConsistency;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.internal.MeasurementMapper;
import com.influxdb.client.reactive.WriteOptionsReactive;
import com.influxdb.client.reactive.WriteReactiveApi;
import com.influxdb.client.service.WriteService;
import com.influxdb.client.write.Point;
import com.influxdb.client.write.WriteParameters;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import retrofit2.HttpException;

public class WriteReactiveApiImpl
extends AbstractRestClient
implements WriteReactiveApi {
    private static final Logger LOG = Logger.getLogger(WriteReactiveApi.class.getName());
    private final WriteOptionsReactive writeOptions;
    private final InfluxDBClientOptions options;
    private final WriteService service;
    private final MeasurementMapper measurementMapper = new MeasurementMapper();

    WriteReactiveApiImpl(@Nonnull WriteOptionsReactive writeOptions, @Nonnull WriteService service, @Nonnull InfluxDBClientOptions options) {
        this.writeOptions = writeOptions;
        this.options = options;
        this.service = service;
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull((Object)precision, (String)"precision");
        if (record == null) {
            LOG.log(Level.FINE, "The record is null for bucket: ''{0}'', org: ''{1}'' and precision: ''{2}''.", new Object[]{bucket, org, precision});
            return Flowable.just((Object)new WriteReactiveApi.Success());
        }
        return this.writeRecords(bucket, org, precision, (Publisher<String>)Flowable.just((Object)record));
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writeRecords(@Nonnull WritePrecision precision, @Nonnull Publisher<String> records) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull Publisher<String> records) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull((Object)precision, (String)"precision");
        Arguments.checkNotNull(records, (String)"records");
        return this.writeRecords(records, new WriteParameters(bucket, org, precision));
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writeRecords(@Nonnull Publisher<String> records, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(records, (String)"records");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromPublisher(records).map(AbstractWriteClient.BatchWriteDataRecord::new);
        return this.write(parameters, (Flowable<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writePoint(@Nonnull WritePrecision precision, @Nonnull Point point) {
        Arguments.checkNotNull((Object)precision, (String)"precision");
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writePoint(this.options.getBucket(), this.options.getOrg(), precision, point);
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writePoint(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull Point point) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull((Object)precision, (String)"precision");
        Arguments.checkNotNull((Object)point, (String)"point");
        return this.writePoints(bucket, org, precision, (Publisher<Point>)Flowable.just((Object)point));
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writePoints(@Nonnull WritePrecision precision, @Nonnull Publisher<Point> points) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writePoints(this.options.getBucket(), this.options.getOrg(), precision, points);
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull Publisher<Point> points) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull(points, (String)"points");
        return this.writePoints(points, new WriteParameters(bucket, org, precision));
    }

    @Override
    public Publisher<WriteReactiveApi.Success> writePoints(@Nonnull Publisher<Point> points, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(points, (String)"points");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromPublisher(points).filter(Objects::nonNull).map(point -> new AbstractWriteClient.BatchWriteDataPoint(point, parameters.precisionSafe(this.options), this.options));
        return this.write(parameters, (Flowable<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    public <M> Publisher<WriteReactiveApi.Success> writeMeasurement(@Nonnull WritePrecision precision, @Nonnull M measurement) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> Publisher<WriteReactiveApi.Success> writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull M measurement) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull((Object)precision, (String)"precision");
        Arguments.checkNotNull(measurement, (String)"measurement");
        return this.writeMeasurements(bucket, org, precision, (Publisher<M>)Flowable.just(measurement));
    }

    @Override
    public <M> Publisher<WriteReactiveApi.Success> writeMeasurements(@Nonnull WritePrecision precision, @Nonnull Publisher<M> measurements) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> Publisher<WriteReactiveApi.Success> writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull Publisher<M> measurements) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"organization");
        Arguments.checkNotNull((Object)precision, (String)"precision");
        Arguments.checkNotNull(measurements, (String)"measurements");
        return this.writeMeasurements(measurements, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> Publisher<WriteReactiveApi.Success> writeMeasurements(@Nonnull Publisher<M> measurements, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(measurements, (String)"points");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromPublisher(measurements).map(it -> new AbstractWriteClient.BatchWriteDataMeasurement(it, parameters.precisionSafe(this.options), this.options, this.measurementMapper));
        return this.write(parameters, (Flowable<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Nonnull
    private Publisher<WriteReactiveApi.Success> write(@Nonnull WriteParameters parameters, @Nonnull Flowable<AbstractWriteClient.BatchWriteData> stream) {
        Arguments.checkNotNull((Object)parameters, (String)"parameters");
        Arguments.checkNotNull(stream, (String)"stream");
        Flowable batches = stream.compose(source -> {
            if (this.writeOptions.getBatchSize() == 0) {
                return Flowable.just((Object)Flowable.fromPublisher((Publisher)stream));
            }
            return source.window((long)this.writeOptions.getFlushInterval(), TimeUnit.MILLISECONDS, this.writeOptions.getComputationScheduler(), (long)this.writeOptions.getBatchSize(), true);
        }).concatMapSingle(batch -> batch.map(item -> {
            String lineProtocol = item.toLineProtocol();
            if (lineProtocol == null) {
                return "";
            }
            return lineProtocol;
        }).filter(it -> !it.isEmpty()).collect(StringBuilder::new, (sb, x) -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append((String)x);
        }).map(StringBuilder::toString)).filter(it -> !it.isEmpty());
        return batches.compose(AbstractWriteClient.jitter((Scheduler)this.writeOptions.getComputationScheduler(), (WriteApi.RetryOptions)this.writeOptions)).flatMapSingle(it -> {
            String organization = parameters.orgSafe(this.options);
            String bucket = parameters.bucketSafe(this.options);
            WritePrecision precision = parameters.precisionSafe(this.options);
            WriteConsistency consistency = parameters.consistencySafe(this.options);
            return this.service.postWriteRx(organization, bucket, it, null, "identity", "text/plain; charset=utf-8", null, "application/json", null, precision, consistency);
        }).flatMap(response -> {
            if (!response.isSuccessful()) {
                return Flowable.error((Throwable)new HttpException(response));
            }
            return Flowable.just((Object)new WriteReactiveApi.Success());
        }).retryWhen(AbstractWriteClient.retry((Scheduler)this.writeOptions.getComputationScheduler(), (WriteApi.RetryOptions)this.writeOptions, (throwable, retryInterval) -> {
            String msg = MessageFormat.format("The retriable error occurred during writing of data. Retry in: {0}s.", (double)retryInterval.longValue() / 1000.0);
            LOG.log(Level.WARNING, msg, (Throwable)throwable);
        })).timeout((long)this.writeOptions.getMaxRetryTime(), TimeUnit.MILLISECONDS, this.writeOptions.getComputationScheduler(), (Publisher)Flowable.error((Throwable)new TimeoutException("Max retry time exceeded."))).onErrorResumeNext(throwable -> Flowable.error((Throwable)this.toInfluxException((Throwable)throwable)));
    }
}

