/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * SMTPNotificationRuleBase
 */

public class SMTPNotificationRuleBase extends NotificationRule {
  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    SMTP("smtp");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.SMTP;

  public static final String SERIALIZED_NAME_SUBJECT_TEMPLATE = "subjectTemplate";
  @SerializedName(SERIALIZED_NAME_SUBJECT_TEMPLATE)
  private String subjectTemplate;

  public static final String SERIALIZED_NAME_BODY_TEMPLATE = "bodyTemplate";
  @SerializedName(SERIALIZED_NAME_BODY_TEMPLATE)
  private String bodyTemplate;

  public static final String SERIALIZED_NAME_TO = "to";
  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  public TypeEnum getType() {
    return type;
  }

  public SMTPNotificationRuleBase subjectTemplate(String subjectTemplate) {
    this.subjectTemplate = subjectTemplate;
    return this;
  }

   /**
   * Get subjectTemplate
   * @return subjectTemplate
  **/
  @ApiModelProperty(required = true, value = "")
  public String getSubjectTemplate() {
    return subjectTemplate;
  }

  public void setSubjectTemplate(String subjectTemplate) {
    this.subjectTemplate = subjectTemplate;
  }

  public SMTPNotificationRuleBase bodyTemplate(String bodyTemplate) {
    this.bodyTemplate = bodyTemplate;
    return this;
  }

   /**
   * Get bodyTemplate
   * @return bodyTemplate
  **/
  @ApiModelProperty(value = "")
  public String getBodyTemplate() {
    return bodyTemplate;
  }

  public void setBodyTemplate(String bodyTemplate) {
    this.bodyTemplate = bodyTemplate;
  }

  public SMTPNotificationRuleBase to(String to) {
    this.to = to;
    return this;
  }

   /**
   * Get to
   * @return to
  **/
  @ApiModelProperty(required = true, value = "")
  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SMTPNotificationRuleBase smTPNotificationRuleBase = (SMTPNotificationRuleBase) o;
    return Objects.equals(this.type, smTPNotificationRuleBase.type) &&
        Objects.equals(this.subjectTemplate, smTPNotificationRuleBase.subjectTemplate) &&
        Objects.equals(this.bodyTemplate, smTPNotificationRuleBase.bodyTemplate) &&
        Objects.equals(this.to, smTPNotificationRuleBase.to) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, subjectTemplate, bodyTemplate, to, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SMTPNotificationRuleBase {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    subjectTemplate: ").append(toIndentedString(subjectTemplate)).append("\n");
    sb.append("    bodyTemplate: ").append(toIndentedString(bodyTemplate)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

