/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Links;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * DBRP
 */

public class DBRP {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
  @SerializedName(SERIALIZED_NAME_ORG_I_D)
  private String orgID;

  public static final String SERIALIZED_NAME_BUCKET_I_D = "bucketID";
  @SerializedName(SERIALIZED_NAME_BUCKET_I_D)
  private String bucketID;

  public static final String SERIALIZED_NAME_DATABASE = "database";
  @SerializedName(SERIALIZED_NAME_DATABASE)
  private String database;

  public static final String SERIALIZED_NAME_RETENTION_POLICY = "retention_policy";
  @SerializedName(SERIALIZED_NAME_RETENTION_POLICY)
  private String retentionPolicy;

  public static final String SERIALIZED_NAME_DEFAULT = "default";
  @SerializedName(SERIALIZED_NAME_DEFAULT)
  private Boolean _default;

  public static final String SERIALIZED_NAME_LINKS = "links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private Links links = null;

   /**
   * the mapping identifier
   * @return id
  **/
  @ApiModelProperty(required = true, value = "the mapping identifier")
  public String getId() {
    return id;
  }

  public DBRP orgID(String orgID) {
    this.orgID = orgID;
    return this;
  }

   /**
   * the organization ID that owns this mapping.
   * @return orgID
  **/
  @ApiModelProperty(required = true, value = "the organization ID that owns this mapping.")
  public String getOrgID() {
    return orgID;
  }

  public void setOrgID(String orgID) {
    this.orgID = orgID;
  }

  public DBRP bucketID(String bucketID) {
    this.bucketID = bucketID;
    return this;
  }

   /**
   * the bucket ID used as target for the translation.
   * @return bucketID
  **/
  @ApiModelProperty(required = true, value = "the bucket ID used as target for the translation.")
  public String getBucketID() {
    return bucketID;
  }

  public void setBucketID(String bucketID) {
    this.bucketID = bucketID;
  }

  public DBRP database(String database) {
    this.database = database;
    return this;
  }

   /**
   * InfluxDB v1 database
   * @return database
  **/
  @ApiModelProperty(required = true, value = "InfluxDB v1 database")
  public String getDatabase() {
    return database;
  }

  public void setDatabase(String database) {
    this.database = database;
  }

  public DBRP retentionPolicy(String retentionPolicy) {
    this.retentionPolicy = retentionPolicy;
    return this;
  }

   /**
   * InfluxDB v1 retention policy
   * @return retentionPolicy
  **/
  @ApiModelProperty(required = true, value = "InfluxDB v1 retention policy")
  public String getRetentionPolicy() {
    return retentionPolicy;
  }

  public void setRetentionPolicy(String retentionPolicy) {
    this.retentionPolicy = retentionPolicy;
  }

  public DBRP _default(Boolean _default) {
    this._default = _default;
    return this;
  }

   /**
   * Specify if this mapping represents the default retention policy for the database specificed.
   * @return _default
  **/
  @ApiModelProperty(required = true, value = "Specify if this mapping represents the default retention policy for the database specificed.")
  public Boolean getDefault() {
    return _default;
  }

  public void setDefault(Boolean _default) {
    this._default = _default;
  }

  public DBRP links(Links links) {
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @ApiModelProperty(value = "")
  public Links getLinks() {
    return links;
  }

  public void setLinks(Links links) {
    this.links = links;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DBRP DBRP = (DBRP) o;
    return Objects.equals(this.id, DBRP.id) &&
        Objects.equals(this.orgID, DBRP.orgID) &&
        Objects.equals(this.bucketID, DBRP.bucketID) &&
        Objects.equals(this.database, DBRP.database) &&
        Objects.equals(this.retentionPolicy, DBRP.retentionPolicy) &&
        Objects.equals(this._default, DBRP._default) &&
        Objects.equals(this.links, DBRP.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, orgID, bucketID, database, retentionPolicy, _default, links);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DBRP {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    orgID: ").append(toIndentedString(orgID)).append("\n");
    sb.append("    bucketID: ").append(toIndentedString(bucketID)).append("\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    retentionPolicy: ").append(toIndentedString(retentionPolicy)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

