/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.CheckBaseLinks;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.TaskStatusType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * CheckBase
 */

public class CheckBase {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
  @SerializedName(SERIALIZED_NAME_ORG_I_D)
  private String orgID;

  public static final String SERIALIZED_NAME_TASK_I_D = "taskID";
  @SerializedName(SERIALIZED_NAME_TASK_I_D)
  private String taskID;

  public static final String SERIALIZED_NAME_OWNER_I_D = "ownerID";
  @SerializedName(SERIALIZED_NAME_OWNER_I_D)
  private String ownerID;

  public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private DashboardQuery query = null;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private TaskStatusType status = null;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_LATEST_COMPLETED = "latestCompleted";
  @SerializedName(SERIALIZED_NAME_LATEST_COMPLETED)
  private OffsetDateTime latestCompleted;

  /**
   * Gets or Sets lastRunStatus
   */
  @JsonAdapter(LastRunStatusEnum.Adapter.class)
  public enum LastRunStatusEnum {
    FAILED("failed"),
    
    SUCCESS("success"),
    
    CANCELED("canceled");

    private String value;

    LastRunStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LastRunStatusEnum fromValue(String text) {
      for (LastRunStatusEnum b : LastRunStatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<LastRunStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LastRunStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LastRunStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LastRunStatusEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_LAST_RUN_STATUS = "lastRunStatus";
  @SerializedName(SERIALIZED_NAME_LAST_RUN_STATUS)
  private LastRunStatusEnum lastRunStatus;

  public static final String SERIALIZED_NAME_LAST_RUN_ERROR = "lastRunError";
  @SerializedName(SERIALIZED_NAME_LAST_RUN_ERROR)
  private String lastRunError;

  public static final String SERIALIZED_NAME_LABELS = "labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private List<Label> labels = new ArrayList<>();

  public static final String SERIALIZED_NAME_LINKS = "links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private CheckBaseLinks links = null;

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public String getId() {
    return id;
  }

  public CheckBase name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CheckBase orgID(String orgID) {
    this.orgID = orgID;
    return this;
  }

   /**
   * The ID of the organization that owns this check.
   * @return orgID
  **/
  @ApiModelProperty(required = true, value = "The ID of the organization that owns this check.")
  public String getOrgID() {
    return orgID;
  }

  public void setOrgID(String orgID) {
    this.orgID = orgID;
  }

  public CheckBase taskID(String taskID) {
    this.taskID = taskID;
    return this;
  }

   /**
   * The ID of the task associated with this check.
   * @return taskID
  **/
  @ApiModelProperty(value = "The ID of the task associated with this check.")
  public String getTaskID() {
    return taskID;
  }

  public void setTaskID(String taskID) {
    this.taskID = taskID;
  }

   /**
   * The ID of creator used to create this check.
   * @return ownerID
  **/
  @ApiModelProperty(value = "The ID of creator used to create this check.")
  public String getOwnerID() {
    return ownerID;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @ApiModelProperty(value = "")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @ApiModelProperty(value = "")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public CheckBase query(DashboardQuery query) {
    this.query = query;
    return this;
  }

   /**
   * Get query
   * @return query
  **/
  @ApiModelProperty(required = true, value = "")
  public DashboardQuery getQuery() {
    return query;
  }

  public void setQuery(DashboardQuery query) {
    this.query = query;
  }

  public CheckBase status(TaskStatusType status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(value = "")
  public TaskStatusType getStatus() {
    return status;
  }

  public void setStatus(TaskStatusType status) {
    this.status = status;
  }

  public CheckBase description(String description) {
    this.description = description;
    return this;
  }

   /**
   * An optional description of the check.
   * @return description
  **/
  @ApiModelProperty(value = "An optional description of the check.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

   /**
   * Timestamp of latest scheduled, completed run, RFC3339.
   * @return latestCompleted
  **/
  @ApiModelProperty(value = "Timestamp of latest scheduled, completed run, RFC3339.")
  public OffsetDateTime getLatestCompleted() {
    return latestCompleted;
  }

   /**
   * Get lastRunStatus
   * @return lastRunStatus
  **/
  @ApiModelProperty(value = "")
  public LastRunStatusEnum getLastRunStatus() {
    return lastRunStatus;
  }

   /**
   * Get lastRunError
   * @return lastRunError
  **/
  @ApiModelProperty(value = "")
  public String getLastRunError() {
    return lastRunError;
  }

  public CheckBase labels(List<Label> labels) {
    this.labels = labels;
    return this;
  }

  public CheckBase addLabelsItem(Label labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

   /**
   * Get labels
   * @return labels
  **/
  @ApiModelProperty(value = "")
  public List<Label> getLabels() {
    return labels;
  }

  public void setLabels(List<Label> labels) {
    this.labels = labels;
  }

  public CheckBase links(CheckBaseLinks links) {
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @ApiModelProperty(value = "")
  public CheckBaseLinks getLinks() {
    return links;
  }

  public void setLinks(CheckBaseLinks links) {
    this.links = links;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckBase checkBase = (CheckBase) o;
    return Objects.equals(this.id, checkBase.id) &&
        Objects.equals(this.name, checkBase.name) &&
        Objects.equals(this.orgID, checkBase.orgID) &&
        Objects.equals(this.taskID, checkBase.taskID) &&
        Objects.equals(this.ownerID, checkBase.ownerID) &&
        Objects.equals(this.createdAt, checkBase.createdAt) &&
        Objects.equals(this.updatedAt, checkBase.updatedAt) &&
        Objects.equals(this.query, checkBase.query) &&
        Objects.equals(this.status, checkBase.status) &&
        Objects.equals(this.description, checkBase.description) &&
        Objects.equals(this.latestCompleted, checkBase.latestCompleted) &&
        Objects.equals(this.lastRunStatus, checkBase.lastRunStatus) &&
        Objects.equals(this.lastRunError, checkBase.lastRunError) &&
        Objects.equals(this.labels, checkBase.labels) &&
        Objects.equals(this.links, checkBase.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, orgID, taskID, ownerID, createdAt, updatedAt, query, status, description, latestCompleted, lastRunStatus, lastRunError, labels, links);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckBase {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    orgID: ").append(toIndentedString(orgID)).append("\n");
    sb.append("    taskID: ").append(toIndentedString(taskID)).append("\n");
    sb.append("    ownerID: ").append(toIndentedString(ownerID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    latestCompleted: ").append(toIndentedString(latestCompleted)).append("\n");
    sb.append("    lastRunStatus: ").append(toIndentedString(lastRunStatus)).append("\n");
    sb.append("    lastRunError: ").append(toIndentedString(lastRunError)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

