/*
 * Decompiled with CFR 0.152.
 */
package com.inflectra.spiratest.plugins;

import com.inflectra.spiratest.plugins.SpiraBuilder;
import com.inflectra.spiratest.plugins.SpiraImportExport;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.scm.ChangeLogSet;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

@Extension
public class SpiraRunListener
extends RunListener<Run> {
    public void onCompleted(Run r, TaskListener listener) {
        super.onCompleted(r, listener);
        Project project = (Project)r.getParent();
        SpiraBuilder spiraBuilder = (SpiraBuilder)((Object)project.getBuildWrappers().get(Descriptor.find((String)SpiraBuilder.DescriptorImpl.class.getName())));
        if (spiraBuilder == null) {
            return;
        }
        if (spiraBuilder.getDescriptor() == null) {
            return;
        }
        String url = spiraBuilder.getDescriptor().getUrl();
        String username = spiraBuilder.getDescriptor().getUsername();
        String password = spiraBuilder.getDescriptor().getPassword().getPlainText();
        String projectIdString = spiraBuilder.getProject();
        int projectId = Integer.parseInt(projectIdString);
        String releaseVersionNumber = spiraBuilder.getRelease();
        try {
            AbstractBuild build;
            ChangeLogSet set;
            List logLines;
            String buildName = r.getFullDisplayName();
            String buildDescription = "";
            if (r.getDescription() != null) {
                buildDescription = buildDescription + r.getDescription() + "\n";
            }
            if ((logLines = r.getLog(Integer.MAX_VALUE)) != null && !logLines.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                for (String logLine : logLines) {
                    buffer.append(logLine + "\n");
                }
                buildDescription = buildDescription + buffer.toString();
            }
            int buildStatusId = this.convertStatus(r.getResult());
            ArrayList<String> revisionKeys = new ArrayList<String>();
            ArrayList<Integer> incidents = new ArrayList<Integer>();
            if (r instanceof AbstractBuild && (set = (build = (AbstractBuild)r).getChangeSet()) != null) {
                for (ChangeLogSet.Entry entry : set) {
                    String revisionKey = entry.getCommitId();
                    MarkupText unannotatedMessage = new MarkupText(entry.getMsg());
                    if (revisionKey != null && !revisionKey.isEmpty()) {
                        revisionKeys.add(revisionKey);
                    }
                    Pattern regex = Pattern.compile("\\[IN:([0-9]+)\\]");
                    List tokens = unannotatedMessage.findTokens(regex);
                    for (MarkupText.SubText token : tokens) {
                        if (token.groupCount() <= 0) continue;
                        try {
                            int incidentId = Integer.parseInt(token.group(1));
                            incidents.add(incidentId);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            SpiraImportExport spiraClient = new SpiraImportExport();
            spiraClient.setUrl(url);
            spiraClient.setUserName(username);
            spiraClient.setPassword(Secret.fromString((String)password));
            spiraClient.setProjectId(projectId);
            Date buildDate = r.getTime();
            spiraClient.recordBuild(releaseVersionNumber, buildDate, buildStatusId, buildName, buildDescription, revisionKeys, incidents);
        }
        catch (Exception ex) {
            listener.getLogger().print(ex.getMessage() + ": " + Arrays.toString(ex.getStackTrace()));
        }
    }

    protected int convertStatus(Result result) {
        int buildStatusId = 1;
        if (result == Result.SUCCESS) {
            buildStatusId = 2;
        }
        return buildStatusId;
    }
}

