/*
 * Decompiled with CFR 0.152.
 */
package com.inflectra.spiratest.plugins;

import com.inflectra.spiratest.plugins.SSLUtilities;
import com.inflectra.spiratest.plugins.soap.ArrayOfRemoteBuildSourceCode;
import com.inflectra.spiratest.plugins.soap.ArrayOfRemoteRelease;
import com.inflectra.spiratest.plugins.soap.IImportExport;
import com.inflectra.spiratest.plugins.soap.IImportExportBuildCreateServiceFaultMessageFaultFaultMessage;
import com.inflectra.spiratest.plugins.soap.IImportExportConnectionAuthenticate2ServiceFaultMessageFaultFaultMessage;
import com.inflectra.spiratest.plugins.soap.IImportExportConnectionConnectToProjectServiceFaultMessageFaultFaultMessage;
import com.inflectra.spiratest.plugins.soap.IImportExportSystemGetArtifactUrlServiceFaultMessageFaultFaultMessage;
import com.inflectra.spiratest.plugins.soap.IImportExportTestRunRecordAutomated1ServiceFaultMessageFaultFaultMessage;
import com.inflectra.spiratest.plugins.soap.ImportExport;
import com.inflectra.spiratest.plugins.soap.RemoteAutomatedTestRun;
import com.inflectra.spiratest.plugins.soap.RemoteBuild;
import com.inflectra.spiratest.plugins.soap.RemoteBuildSourceCode;
import com.inflectra.spiratest.plugins.soap.RemoteIncident;
import com.inflectra.spiratest.plugins.soap.RemoteRelease;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public class SpiraImportExport {
    private static final String WEB_SERVICE_SUFFIX = "/Services/v3_0/ImportExport.svc?WSDL";
    private static final String WEB_SERVICE_NAMESPACE = "{http://www.inflectra.com/SpiraTest/Services/v3.0/}ImportExport";
    private static final String WEB_SERVICE_NAMESPACE_DATA_OBJECTS = "http://schemas.datacontract.org/2004/07/Inflectra.SpiraTest.Web.Services.v3_0.DataObjects";
    private static final String SPIRA_PLUG_IN_NAME = "Jenkins Plugin";
    private String url;
    private String userName;
    private String password;
    private int projectId;

    public SpiraImportExport() {
    }

    public SpiraImportExport(String url, String userName, String password, int projectId) {
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.projectId = projectId;
    }

    public int recordTestRun(Integer testerUserId, int testCaseId, Integer releaseId, Integer testSetId, Date startDate, Date endDate, int executionStatusId, String runnerName, String runnerTestName, int runnerAssertCount, String runnerMessage, String runnerStackTrace) throws Exception {
        try {
            SSLUtilities.trustAllHttpsCertificates();
            URL serviceUrl = new URL(this.url + WEB_SERVICE_SUFFIX);
            ImportExport service = new ImportExport(serviceUrl, QName.valueOf(WEB_SERVICE_NAMESPACE));
            IImportExport soap = null;
            IImportExport soap1 = null;
            String soapMessage = "";
            try {
                soap = service.getBasicHttpBindingIImportExport();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            try {
                soap1 = service.getBasicHttpBindingIImportExport1();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            if (soap == null && soap1 == null) {
                throw new Exception("Unable to connect with either the SpiraTest HTTP or HTTPS APIs. Please check the URL and try again: " + soapMessage + "\n");
            }
            if (soap == null) {
                soap = soap1;
            } else {
                soap1 = soap;
            }
            Map requestContext = ((BindingProvider)soap).getRequestContext();
            requestContext.put("javax.xml.ws.session.maintain", true);
            Map requestContext1 = ((BindingProvider)soap1).getRequestContext();
            requestContext1.put("javax.xml.ws.session.maintain", true);
            boolean success = false;
            try {
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            catch (Exception ex) {
                soap = soap1;
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            if (!success) {
                throw new Exception("Unable to authenticate with SpiraTest server. Please check the username/password and try again\n\n");
            }
            success = soap.connectionConnectToProject(this.projectId);
            if (!success) {
                throw new Exception("Unable to connect to SpiraTest project " + this.projectId + ", please check that the user is a member of this project\n\n");
            }
            RemoteAutomatedTestRun remoteTestRun = new RemoteAutomatedTestRun();
            remoteTestRun.setTestCaseId(testCaseId);
            if (releaseId != null) {
                remoteTestRun.setReleaseId(SpiraImportExport.createJAXBInteger("ReleaseId", releaseId));
            }
            if (testSetId != null) {
                remoteTestRun.setTestSetId(SpiraImportExport.createJAXBInteger("TestSetId", testSetId));
            }
            remoteTestRun.setStartDate(SpiraImportExport.convertDatesJava2Xml(startDate));
            remoteTestRun.setEndDate(SpiraImportExport.createJAXBXMLGregorianCalendar("EndDate", SpiraImportExport.convertDatesJava2Xml(endDate)));
            remoteTestRun.setExecutionStatusId(executionStatusId);
            remoteTestRun.setRunnerName(SpiraImportExport.createJAXBString("RunnerName", runnerName));
            remoteTestRun.setRunnerTestName(SpiraImportExport.createJAXBString("RunnerTestName", runnerTestName));
            remoteTestRun.setRunnerAssertCount(SpiraImportExport.createJAXBInteger("RunnerAssertCount", runnerAssertCount));
            remoteTestRun.setRunnerMessage(SpiraImportExport.createJAXBString("RunnerMessage", runnerMessage));
            remoteTestRun.setRunnerStackTrace(SpiraImportExport.createJAXBString("RunnerStackTrace", runnerStackTrace));
            remoteTestRun = soap.testRunRecordAutomated1(remoteTestRun);
            int testRunId = (Integer)remoteTestRun.getTestRunId().getValue();
            return testRunId;
        }
        catch (IImportExportTestRunRecordAutomated1ServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (IImportExportConnectionConnectToProjectServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error connecting to SpiraTest project (" + exception.getMessage() + ")\n\n");
        }
        catch (IImportExportConnectionAuthenticate2ServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error authenticating with SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (MalformedURLException exception) {
            throw new Exception("Error creating URL for connecting to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (Exception exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
    }

    public boolean testConnection() throws Exception {
        try {
            SSLUtilities.trustAllHttpsCertificates();
            URL serviceUrl = new URL(this.url + WEB_SERVICE_SUFFIX);
            ImportExport service = new ImportExport(serviceUrl, QName.valueOf(WEB_SERVICE_NAMESPACE));
            IImportExport soap = null;
            IImportExport soap1 = null;
            String soapMessage = "";
            try {
                soap = service.getBasicHttpBindingIImportExport();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            try {
                soap1 = service.getBasicHttpBindingIImportExport1();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            if (soap == null && soap1 == null) {
                throw new Exception("Unable to connect with either the SpiraTest HTTP or HTTPS APIs. Please check the URL and try again: " + soapMessage + "\n");
            }
            if (soap == null) {
                soap = soap1;
            } else {
                soap1 = soap;
            }
            Map requestContext = ((BindingProvider)soap).getRequestContext();
            requestContext.put("javax.xml.ws.session.maintain", true);
            Map requestContext1 = ((BindingProvider)soap1).getRequestContext();
            requestContext1.put("javax.xml.ws.session.maintain", true);
            boolean success = false;
            try {
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            catch (Exception ex) {
                soap = soap1;
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            return success;
        }
        catch (IImportExportConnectionAuthenticate2ServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error authenticating with SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (MalformedURLException exception) {
            throw new Exception("Error creating URL for connecting to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (Exception exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
    }

    public Integer verifyRelease(String releaseVersionNumber) throws Exception {
        try {
            SSLUtilities.trustAllHttpsCertificates();
            URL serviceUrl = new URL(this.url + WEB_SERVICE_SUFFIX);
            ImportExport service = new ImportExport(serviceUrl, QName.valueOf(WEB_SERVICE_NAMESPACE));
            IImportExport soap = null;
            IImportExport soap1 = null;
            String soapMessage = "";
            try {
                soap = service.getBasicHttpBindingIImportExport();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            try {
                soap1 = service.getBasicHttpBindingIImportExport1();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            if (soap == null && soap1 == null) {
                throw new Exception("Unable to connect with either the SpiraTest HTTP or HTTPS APIs. Please check the URL and try again: " + soapMessage + "\n");
            }
            if (soap == null) {
                soap = soap1;
            } else {
                soap1 = soap;
            }
            Map requestContext = ((BindingProvider)soap).getRequestContext();
            requestContext.put("javax.xml.ws.session.maintain", true);
            Map requestContext1 = ((BindingProvider)soap1).getRequestContext();
            requestContext1.put("javax.xml.ws.session.maintain", true);
            boolean success = false;
            try {
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            catch (Exception ex) {
                soap = soap1;
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            success = soap.connectionConnectToProject(this.projectId);
            if (!success) {
                throw new Exception("Unable to connect to SpiraTest project " + this.projectId + ", please check that the user is a member of this project");
            }
            ArrayOfRemoteRelease remoteReleases = soap.releaseRetrieve(true);
            if (remoteReleases == null || remoteReleases.getRemoteRelease() == null || remoteReleases.getRemoteRelease().isEmpty()) {
                return null;
            }
            Integer releaseId = null;
            for (RemoteRelease remoteRelease : remoteReleases.getRemoteRelease()) {
                if (!((String)remoteRelease.getVersionNumber().getValue()).equals(releaseVersionNumber)) continue;
                releaseId = (Integer)remoteRelease.getReleaseId().getValue();
                break;
            }
            return releaseId;
        }
        catch (IImportExportConnectionAuthenticate2ServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error authenticating with SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (MalformedURLException exception) {
            throw new Exception("Error creating URL for connecting to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
        catch (Exception exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")\n\n");
        }
    }

    public String createArtifactUrl(String prefix, int artifactId) throws Exception {
        try {
            SSLUtilities.trustAllHttpsCertificates();
            URL serviceUrl = new URL(this.url + WEB_SERVICE_SUFFIX);
            ImportExport service = new ImportExport(serviceUrl, QName.valueOf(WEB_SERVICE_NAMESPACE));
            IImportExport soap = null;
            IImportExport soap1 = null;
            String soapMessage = "";
            try {
                soap = service.getBasicHttpBindingIImportExport();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            try {
                soap1 = service.getBasicHttpBindingIImportExport1();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            if (soap == null && soap1 == null) {
                throw new Exception("Unable to connect with either the SpiraTest HTTP or HTTPS APIs. Please check the URL and try again: " + soapMessage + "\n");
            }
            if (soap == null) {
                soap = soap1;
            }
            int artifactTypeId = ArtifactType.getByPrefix(prefix).getArtifactId();
            String relativeUrl = soap.systemGetArtifactUrl(artifactTypeId, this.projectId, artifactId, "");
            String absoluteUrl = relativeUrl.replaceFirst("~", this.url);
            return absoluteUrl;
        }
        catch (IImportExportSystemGetArtifactUrlServiceFaultMessageFaultFaultMessage ex) {
            throw new Exception("Unable to create artifact URL", ex);
        }
    }

    public int recordBuild(String releaseVersionNumber, Date creationDate, int buildStatusId, String name, String description, List<String> revisions, List<Integer> incidents) throws Exception {
        try {
            SSLUtilities.trustAllHttpsCertificates();
            URL serviceUrl = new URL(this.url + WEB_SERVICE_SUFFIX);
            ImportExport service = new ImportExport(serviceUrl, QName.valueOf(WEB_SERVICE_NAMESPACE));
            IImportExport soap = null;
            IImportExport soap1 = null;
            String soapMessage = "";
            try {
                soap = service.getBasicHttpBindingIImportExport();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            try {
                soap1 = service.getBasicHttpBindingIImportExport1();
            }
            catch (WebServiceException ex) {
                soapMessage = ex.getMessage() + " - " + this.extractStackTrace(ex.getStackTrace());
            }
            if (soap == null && soap1 == null) {
                throw new Exception("Unable to connect with either the SpiraTest HTTP or HTTPS APIs. Please check the URL and try again: " + soapMessage + "\n");
            }
            if (soap == null) {
                soap = soap1;
            } else {
                soap1 = soap;
            }
            Map requestContext = ((BindingProvider)soap).getRequestContext();
            requestContext.put("javax.xml.ws.session.maintain", true);
            Map requestContext1 = ((BindingProvider)soap1).getRequestContext();
            requestContext1.put("javax.xml.ws.session.maintain", true);
            boolean success = false;
            try {
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            catch (Exception ex) {
                soap = soap1;
                success = soap.connectionAuthenticate2(this.userName, this.password, SPIRA_PLUG_IN_NAME);
            }
            if (!success) {
                throw new Exception("Unable to authenticate with SpiraTest server. Please check the username/password and try again");
            }
            success = soap.connectionConnectToProject(this.projectId);
            if (!success) {
                throw new Exception("Unable to connect to SpiraTest project PR" + this.projectId + " with user '" + this.userName + "', please check that the user is a member of this project");
            }
            ArrayOfRemoteBuildSourceCode remoteSourceCodeRevisions = new ArrayOfRemoteBuildSourceCode();
            if (revisions != null && !revisions.isEmpty()) {
                for (String revisionKey : revisions) {
                    RemoteBuildSourceCode remoteSourceCodeRevision = new RemoteBuildSourceCode();
                    remoteSourceCodeRevision.setRevisionKey(SpiraImportExport.createJAXBString("RevisionKey", revisionKey));
                    remoteSourceCodeRevisions.getRemoteBuildSourceCode().add(remoteSourceCodeRevision);
                }
            }
            Integer releaseId = null;
            ArrayOfRemoteRelease remoteReleases = soap.releaseRetrieve(true);
            if (remoteReleases != null && remoteReleases.getRemoteRelease() != null && !remoteReleases.getRemoteRelease().isEmpty()) {
                for (RemoteRelease remoteRelease : remoteReleases.getRemoteRelease()) {
                    if (!((String)remoteRelease.getVersionNumber().getValue()).equals(releaseVersionNumber)) continue;
                    releaseId = (Integer)remoteRelease.getReleaseId().getValue();
                    break;
                }
            }
            if (releaseId == null) {
                throw new Exception("Unable to locate a release with version number '" + releaseVersionNumber + "' in project PR" + this.projectId);
            }
            RemoteBuild remoteBuild = new RemoteBuild();
            remoteBuild.setReleaseId(releaseId);
            remoteBuild.setBuildStatusId(buildStatusId);
            remoteBuild.setName(SpiraImportExport.createJAXBString("Name", this.cleanText(name)));
            remoteBuild.setDescription(SpiraImportExport.createJAXBString("Description", this.cleanText(description)));
            remoteBuild.setCreationDate(SpiraImportExport.createJAXBXMLGregorianCalendar("CreationDate", SpiraImportExport.convertDatesJava2Xml(creationDate)));
            if (remoteSourceCodeRevisions.getRemoteBuildSourceCode() != null && !remoteSourceCodeRevisions.getRemoteBuildSourceCode().isEmpty()) {
                remoteBuild.setRevisions(SpiraImportExport.createJAXBBuildRevisionArray("Revisions", remoteSourceCodeRevisions));
            }
            remoteBuild = soap.buildCreate(remoteBuild);
            int buildId = (Integer)remoteBuild.getBuildId().getValue();
            if (incidents != null && !incidents.isEmpty()) {
                for (Integer incidentId : incidents) {
                    RemoteIncident remoteIncident = soap.incidentRetrieveById(incidentId);
                    if (remoteIncident == null) continue;
                    remoteIncident.setFixedBuildId(SpiraImportExport.createJAXBInteger("FixedBuildId", buildId));
                    soap.incidentUpdate(remoteIncident);
                }
            }
            return buildId;
        }
        catch (IImportExportBuildCreateServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")");
        }
        catch (IImportExportConnectionConnectToProjectServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error connecting to SpiraTest project (" + exception.getMessage() + ")");
        }
        catch (IImportExportConnectionAuthenticate2ServiceFaultMessageFaultFaultMessage exception) {
            throw new Exception("Error authenticating with SpiraTest server (" + exception.getMessage() + ")");
        }
        catch (MalformedURLException exception) {
            throw new Exception("Error creating URL for connecting to SpiraTest server (" + exception.getMessage() + ")");
        }
        catch (Exception exception) {
            throw new Exception("Error sending results to SpiraTest server (" + exception.getMessage() + ")");
        }
    }

    public String cleanText(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\p{Cntrl}", "");
    }

    public String extractStackTrace(StackTraceElement[] elements) {
        StringBuffer buffer = new StringBuffer();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                buffer.append(elements[i].toString());
            }
        }
        return buffer.toString();
    }

    public static XMLGregorianCalendar convertDatesJava2Xml(Date date) {
        if (date == null) {
            return null;
        }
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlCal = datatypeFactory.newXMLGregorianCalendar(calendar);
            xmlCal.setTimezone(Integer.MIN_VALUE);
            return xmlCal;
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
    }

    public static JAXBElement<String> createJAXBString(String fieldName, String value) {
        JAXBElement jaxString = new JAXBElement(new QName(WEB_SERVICE_NAMESPACE_DATA_OBJECTS, fieldName), String.class, (Object)value);
        if (value == null) {
            jaxString.setNil(true);
        }
        return jaxString;
    }

    public static JAXBElement<ArrayOfRemoteBuildSourceCode> createJAXBBuildRevisionArray(String fieldName, ArrayOfRemoteBuildSourceCode value) {
        JAXBElement jaxObject = new JAXBElement(new QName(WEB_SERVICE_NAMESPACE_DATA_OBJECTS, fieldName), ArrayOfRemoteBuildSourceCode.class, (Object)value);
        if (value == null) {
            jaxObject.setNil(true);
        }
        return jaxObject;
    }

    public static JAXBElement<Integer> createJAXBInteger(String fieldName, Integer value) {
        JAXBElement jaxInteger = new JAXBElement(new QName(WEB_SERVICE_NAMESPACE_DATA_OBJECTS, fieldName), Integer.class, (Object)value);
        if (value == null) {
            jaxInteger.setNil(true);
        }
        return jaxInteger;
    }

    public static JAXBElement<XMLGregorianCalendar> createJAXBXMLGregorianCalendar(String fieldName, XMLGregorianCalendar value) {
        JAXBElement jaxXMLGregorianCalendar = new JAXBElement(new QName(WEB_SERVICE_NAMESPACE_DATA_OBJECTS, fieldName), XMLGregorianCalendar.class, (Object)value);
        if (value == null) {
            jaxXMLGregorianCalendar.setNil(true);
        }
        return jaxXMLGregorianCalendar;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public static enum ArtifactType {
        REQUIREMENT("RQ", 1),
        TESTCASE("TC", 2),
        INCIDENT("IN", 3),
        RELEASE("RL", 4),
        TESTRUN("TR", 5),
        TASK("TK", 6),
        TESTSTEP("TS", 7),
        TESTSET("TX", 8),
        HOST("AH", 9);

        private final String prefix;
        private final int artifactId;
        private static Map<String, ArtifactType> map;

        private ArtifactType(String prefix, int artifactId) {
            this.prefix = prefix;
            this.artifactId = artifactId;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getArtifactId() {
            return this.artifactId;
        }

        public static ArtifactType getByPrefix(String prefix) {
            return map.get(prefix);
        }

        static {
            map = new HashMap<String, ArtifactType>();
            for (ArtifactType a : ArtifactType.values()) {
                map.put(a.getPrefix(), a);
            }
        }
    }
}

