/*
 * Decompiled with CFR 0.152.
 */
package com.inflectra.spiratest.plugins;

import com.inflectra.spiratest.plugins.SpiraImportExport;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SpiraBuilder
extends BuildWrapper {
    private final String project;
    private final String release;

    @DataBoundConstructor
    public SpiraBuilder(String project, String release) {
        this.project = project;
        this.release = release;
    }

    public String getProject() {
        return this.project;
    }

    public String getRelease() {
        return this.release;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new SpiraEnvironment();
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new SpiraEnvironment();
    }

    public class SpiraEnvironment
    extends BuildWrapper.Environment {
        public SpiraEnvironment() {
            super((BuildWrapper)SpiraBuilder.this);
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            return true;
        }

        public boolean tearDown(Build build, BuildListener listener) throws IOException, InterruptedException {
            return true;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        private String url;
        private String username;
        private String password;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Enable Spira Integration";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.url = formData.getString("url");
            this.username = formData.getString("username");
            this.password = formData.getString("password");
            this.save();
            return super.configure(req, formData);
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) throws IOException, ServletException {
            try {
                SpiraImportExport spiraClient = new SpiraImportExport();
                spiraClient.setUrl(url);
                spiraClient.setUserName(username);
                spiraClient.setPassword(password);
                boolean success = spiraClient.testConnection();
                if (success) {
                    return FormValidation.ok((String)"Successfully Connected");
                }
                return FormValidation.error((String)"Unable to authenticate with SpiraTeam, please check the username and password, then try again.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Error connecting to SpiraTeam: " + e.getMessage()));
            }
        }

        public FormValidation doVerifyRelease(@QueryParameter(value="project") String project, @QueryParameter(value="release") String release) throws IOException, ServletException {
            try {
                SpiraImportExport spiraClient = new SpiraImportExport();
                spiraClient.setUrl(this.getUrl());
                spiraClient.setUserName(this.getUsername());
                spiraClient.setPassword(this.getPassword());
                if (release == null || release.isEmpty()) {
                    return FormValidation.error((String)"You need to enter a release version number");
                }
                int projectId = Integer.parseInt(project);
                spiraClient.setProjectId(projectId);
                Integer releaseId = spiraClient.verifyRelease(release);
                if (releaseId == null) {
                    return FormValidation.error((String)("A release with the version number '" + release + "' does not exist in the Spira project PR" + projectId));
                }
                return FormValidation.ok((String)"Successfully Verified Project and Release");
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"You need to enter a numeric project ID");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Error connecting to SpiraTeam: " + e.getMessage()));
            }
        }
    }
}

