/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.api;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.indeed.vw.wrapper.api.parameters.Link;
import com.indeed.vw.wrapper.api.parameters.Loss;
import com.indeed.vw.wrapper.api.parameters.SGDVowpalWabbitBuilder;
import com.indeed.vw.wrapper.learner.VWFloatLearner;
import com.indeed.vw.wrapper.learner.VWIntLearner;
import com.indeed.vw.wrapper.learner.VWLearner;
import com.indeed.vw.wrapper.learner.VWLearners;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class VowpalWabbit {
    public static final String ANY_NAMESPACE = ":";
    private static final Logger logger = Logger.getLogger(VowpalWabbit.class);

    private VowpalWabbit() {
    }

    public static SGDVowpalWabbitBuilder builder() {
        return new Builder();
    }

    public static Builder advancedBuilder() {
        return new Builder();
    }

    public static class Builder
    implements SGDVowpalWabbitBuilder {
        private final List<String> argumentsStrings = new ArrayList<String>(Arrays.asList("vw"));
        private boolean verbose = false;

        private Builder() {
        }

        @Override
        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        @Override
        public Builder randomSeed(int seed) {
            this.addParameter("--random_seed", String.valueOf(seed));
            return this;
        }

        public Builder ringSize(int ringSize) {
            this.addParameter("--ring_size", String.valueOf(ringSize));
            return this;
        }

        @Override
        public Builder learningRate(double learningRate) {
            this.addParameter("--learning_rate", String.valueOf(learningRate));
            return this;
        }

        public Builder powerT(double powerT) {
            this.addParameter("--power_t", String.valueOf(powerT));
            return this;
        }

        public Builder decayLearningRate(double decay) {
            this.addParameter("--decay_learning_rate", String.valueOf(decay));
            return this;
        }

        public Builder initialT(double initialT) {
            this.addParameter("--initial_t", String.valueOf(initialT));
            return this;
        }

        @Override
        public Builder featureMask(Path featureMask) {
            this.addParameter("--feature_mask", featureMask.toString());
            return this;
        }

        @Override
        public Builder initialRegressor(Path initialRegressor) {
            this.addParameter("--initial_regressor", initialRegressor.toString());
            return this;
        }

        public Builder initialWeight(double weight) {
            this.addParameter("--initial_weight", String.valueOf(weight));
            return this;
        }

        public Builder randomWeights(double arg) {
            this.addParameter("--random_weights", String.valueOf(arg));
            return this;
        }

        public Builder inputFeatureRegularizer(Path regularizationPath) {
            this.addParameter("--input_feature_regularizer", regularizationPath.toString());
            return this;
        }

        public Builder hash(Hash hash) {
            this.addParameter("--hash", hash.toString());
            return this;
        }

        public Builder ignore(String namespace) {
            this.addParameter("--ignore", String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder keep(String namespace) {
            this.addParameter("--keep", String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder redefine(String newNamespace, String ... namespaces) {
            StringBuilder oldNamespaces = new StringBuilder();
            for (String namespace : namespaces) {
                oldNamespaces.append(namespace.charAt(0));
            }
            this.addParameter("--redefine", newNamespace + ":=" + oldNamespaces);
            return this;
        }

        @Override
        public Builder bitPrecision(int bitsNum) {
            this.addParameter("--bit_precision", String.valueOf(bitsNum));
            return this;
        }

        @Override
        public Builder noconstant() {
            this.addFlag("--noconstant");
            return this;
        }

        @Override
        public Builder constant(double initialValue) {
            this.addParameter("--constant", String.valueOf(initialValue));
            return this;
        }

        @Override
        public Builder ngram(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.addParameter("--ngram", String.valueOf(n));
                return this;
            }
            this.addParameter("--ngram", namespace.charAt(0) + "" + n);
            return this;
        }

        @Override
        public Builder skips(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.addParameter("--skips", String.valueOf(n));
                return this;
            }
            this.addParameter("--skips", namespace.charAt(0) + "" + n);
            return this;
        }

        public Builder featureLimit(int n) {
            this.addParameter("--feature_limit", String.valueOf(n));
            return this;
        }

        public Builder affix(String arg) {
            this.addParameter("--affix", arg);
            return this;
        }

        public Builder spelling(String namespace) {
            this.addParameter("--spelling", String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder dictionary(Path file) {
            this.addParameter("--dictionary", file.toString());
            return this;
        }

        public Builder dictionaryPath(Path dir) {
            this.addParameter("--dictionary_path", dir.toString());
            return this;
        }

        public Builder interactions(String ... namespaces) {
            StringBuilder namespacesChars = new StringBuilder();
            for (String namespace : namespaces) {
                namespacesChars.append(namespace.charAt(0));
            }
            this.addParameter("--interactions", namespacesChars.toString());
            return this;
        }

        public Builder permutations() {
            this.addFlag("--permutations");
            return this;
        }

        public Builder leaveDuplicateInteractions() {
            this.addFlag("--leave_duplicate_interactions");
            return this;
        }

        @Override
        public Builder quadratic(String firstNameSpace, String secondNamespace) {
            this.addParameter("--quadratic", firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0));
            return this;
        }

        @Override
        public Builder cubic(String firstNameSpace, String secondNamespace, String thirdNamespace) {
            this.addParameter("--cubic", firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0) + "" + thirdNamespace.charAt(0));
            return this;
        }

        @Override
        public Builder testonly() {
            this.addFlag("--testonly");
            return this;
        }

        public Builder holdoutPeriod(int holdout) {
            this.addParameter("--holdout_period", String.valueOf(holdout));
            return this;
        }

        public Builder holdoutAfter(int n) {
            this.addParameter("--holdout_after", String.valueOf(n));
            return this;
        }

        public Builder earlyTerminate(int passes) {
            this.addParameter("--early_terminate", String.valueOf(passes));
            return this;
        }

        public Builder passes(int passes) {
            this.addParameter("--passes", String.valueOf(passes));
            return this.cache();
        }

        public Builder initialPassLength(int examples) {
            this.addParameter("--initial_pass_length", String.valueOf(examples));
            return this;
        }

        public Builder examples(int examples) {
            this.addParameter("--examples", String.valueOf(examples));
            return this;
        }

        @Override
        public Builder minPrediction(double min) {
            this.addParameter("--min_prediction", String.valueOf(min));
            return this;
        }

        @Override
        public Builder maxPrediction(double max) {
            this.addParameter("--max_prediction", String.valueOf(max));
            return this;
        }

        private void addParameter(String parameter, String value) {
            this.addFlag(parameter);
            this.addFlag(value);
        }

        public Builder sortFeatures() {
            this.addFlag("--sort_features");
            return this;
        }

        @Override
        public Builder lossFunction(Loss loss) {
            this.addParameter("--loss_function", loss.toString());
            return this;
        }

        @Override
        public Builder quantileTau(double tau) {
            this.addParameter("--quantile_tau", String.valueOf(tau));
            return this;
        }

        @Override
        public Builder l1(double l1) {
            this.addParameter("--l1", String.valueOf(l1));
            return this;
        }

        @Override
        public Builder l2(double l2) {
            this.addParameter("--l2", String.valueOf(l2));
            return this;
        }

        public Builder namedLabels(String ... labels) {
            this.addParameter("--named_labels", Joiner.on((String)",").join(Arrays.asList(labels)));
            return this;
        }

        @Override
        public Builder finalRegressor(Path regressor) {
            this.addParameter("--final_regressor", regressor.toString());
            return this;
        }

        @Override
        public Builder readableModel(Path model) {
            this.addParameter("--readable_model", model.toString());
            return this;
        }

        @Override
        public SGDVowpalWabbitBuilder invertHash(Path model) {
            this.addParameter("--invert_hash", model.toString());
            return this;
        }

        public Builder saveResume() {
            this.addFlag("--save_resume");
            return this;
        }

        public Builder savePerPass() {
            this.addFlag("--save_per_pass");
            return this;
        }

        public Builder outputFeatureRegularizerBinary(Path regularizationFile) {
            this.addParameter("--output_feature_regularizer_binary", regularizationFile.toString());
            return this;
        }

        public Builder outputFeatureRegularizerText(Path regularizationFile) {
            this.addParameter("--output_feature_regularizer_text", regularizationFile.toString());
            return this;
        }

        public Builder id(String id) {
            this.addParameter("--id", id);
            return this;
        }

        public Builder auditRegressor(Path regressor) {
            this.addParameter("--audit_regressor", regressor.toString());
            return this;
        }

        public Builder bootstrap(int k) {
            this.addParameter("--bootstrap", String.valueOf(k));
            return this;
        }

        public Builder search(int maxActionID) {
            this.addParameter("--search", String.valueOf(maxActionID));
            return this;
        }

        public Builder replayC(String arg) {
            this.addParameter("--replay_c", arg);
            return this;
        }

        public Builder cbify(int k) {
            this.addParameter("--cbify", String.valueOf(k));
            return this;
        }

        public Builder cbExploreAdf() {
            this.addFlag("--cb_explore_adf");
            return this;
        }

        public Builder cbExplore(int k) {
            this.addParameter("--cb_explore", String.valueOf(k));
            return this;
        }

        public Builder multiworldTest(String arg) {
            this.addParameter("--multiworld_test", arg);
            return this;
        }

        public Builder cbAdf() {
            this.addFlag("--cb_adf");
            return this;
        }

        public Builder cb(int k) {
            this.addParameter("--cb", String.valueOf(k));
            return this;
        }

        public Builder csoaaLdf(LDF ldf) {
            this.addParameter("--csoaa_ldf", ldf.toString());
            return this;
        }

        public Builder wapLdf(LDF ldf) {
            this.addParameter("--wap_ldf", ldf.toString());
            return this;
        }

        public Builder interact(String arg) {
            this.addParameter("--interact", arg);
            return this;
        }

        public Builder csoaa(int k) {
            this.addParameter("--csoaa", String.valueOf(k));
            return this;
        }

        public Builder multilabelOaa(int k) {
            this.addParameter("--multilabel_oaa", String.valueOf(k));
            return this;
        }

        public Builder recallTree(int k) {
            this.addParameter("--recall_tree", String.valueOf(k));
            return this;
        }

        public Builder logMulti(int k) {
            this.addParameter("--log_multi", String.valueOf(k));
            return this;
        }

        public Builder ect(int k) {
            this.addParameter("--ect", String.valueOf(k));
            return this;
        }

        public Builder boosting(int n) {
            this.addParameter("--boosting", String.valueOf(n));
            return this;
        }

        public Builder oaa(int k) {
            this.addParameter("--oaa", String.valueOf(k));
            return this;
        }

        public Builder top(int k) {
            this.addParameter("--top", String.valueOf(k));
            return this;
        }

        public Builder replayM(String arg) {
            this.addParameter("--replay_m", arg);
            return this;
        }

        public Builder binary() {
            this.addFlag("--binary");
            return this;
        }

        @Override
        public Builder link(Link link) {
            this.addParameter("--link", link.toString());
            return this;
        }

        public Builder stagePoly() {
            this.addFlag("--stage_poly");
            return this;
        }

        @Override
        public Builder lrqfa(String firstNamespace, String secondNamespace, int k) {
            this.addParameter("--lrqfa", firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k);
            return this;
        }

        public Builder lrq(String firstNamespace, String secondNamespace, int k) {
            this.addParameter("--lrq", firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k);
            return this;
        }

        public Builder lrqdropout() {
            this.addFlag("--lrqdropout");
            return this;
        }

        public Builder autolink(int d) {
            this.addParameter("--autolink", String.valueOf(d));
            return this;
        }

        public Builder newMf(int rank) {
            this.addParameter("--new_mf", String.valueOf(rank));
            return this;
        }

        public Builder nn(int units) {
            this.addParameter("--nn", String.valueOf(units));
            return this;
        }

        public Builder confidenceAfterTraining() {
            this.addFlag("--confidence_after_training");
            return this;
        }

        public Builder confidence() {
            this.addFlag("--confidence");
            return this;
        }

        public Builder activeCover() {
            this.addFlag("--active_cover");
            return this;
        }

        public Builder active() {
            this.addFlag("--active");
            return this;
        }

        public Builder replayB(String arg) {
            this.addParameter("--replay_b", arg);
            return this;
        }

        public Builder ojaNewton() {
            this.addFlag("--OjaNewton");
            return this;
        }

        public Builder bfgs() {
            this.addFlag("--bfgs");
            return this;
        }

        public Builder conjugateGradient() {
            this.addFlag("--conjugate_gradient");
            return this;
        }

        public Builder lda(int topics) {
            this.addParameter("--lda", String.valueOf(topics));
            return this;
        }

        public Builder noop() {
            this.addFlag("--noop");
            return this;
        }

        public Builder rank(int rank) {
            this.addParameter("--rank", String.valueOf(rank));
            return this;
        }

        public Builder svrg() {
            this.addFlag("--svrg");
            return this;
        }

        @Override
        public Builder ftrl() {
            this.addFlag("--ftrl");
            return this;
        }

        public Builder pistol() {
            this.addFlag("--pistol");
            return this;
        }

        public Builder ksvm() {
            this.addFlag("--ksvm");
            return this;
        }

        @Override
        public Builder sgd() {
            this.addFlag("--sgd");
            return this;
        }

        @Override
        public Builder adaptive() {
            this.addFlag("--adaptive");
            return this;
        }

        @Override
        public Builder invariant() {
            this.addFlag("--invariant");
            return this;
        }

        @Override
        public Builder normalized() {
            this.addFlag("--normalized");
            return this;
        }

        public Builder sparseL2(double l2) {
            this.addParameter("--sparse_l2", String.valueOf(l2));
            return this;
        }

        public Builder cache() {
            this.addFlag("--cache");
            return this;
        }

        public Builder cacheFile(Path cacheFile) {
            this.addParameter("--cache_file", cacheFile.toString());
            return this;
        }

        public Builder killCache() {
            this.addFlag("--kill_cache");
            return this;
        }

        public Builder compressed() {
            this.addFlag("--compressed");
            return this;
        }

        public Builder parameter(String argumentLine) {
            this.addFlag(argumentLine);
            return this;
        }

        private void addFlag(String argumentLine) {
            this.argumentsStrings.add(argumentLine);
        }

        public List<String> getCommandArguments() {
            ArrayList args = Lists.newArrayList(this.argumentsStrings);
            if (!this.verbose) {
                args.add("--quiet");
            }
            return args;
        }

        public String getCommand() {
            List<String> args = this.getCommandArguments();
            return Joiner.on((String)" ").join(args.subList(1, args.size()));
        }

        public VWIntLearner buildIntLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWIntLearner)VWLearners.create(this.getCommandArguments());
        }

        @Override
        public VWFloatLearner buildFloatLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWFloatLearner)VWLearners.create(this.getCommandArguments());
        }

        @Override
        public <T extends VWLearner> T build() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return VWLearners.create(this.getCommandArguments());
        }
    }

    public static enum LDF {
        singleline,
        multiline;

    }

    public static enum Hash {
        strings,
        all;

    }
}

