/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.api.parameters;

import com.indeed.vw.wrapper.api.VowpalWabbit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import org.apache.log4j.lf5.util.StreamUtils;

public class VWUtility {
    private VWUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countNumberOfNonZeroWeights(Path modelPath) throws IOException {
        Path readableModelPath = Files.createTempFile("readable-model", ".txt", new FileAttribute[0]);
        try {
            VowpalWabbit.advancedBuilder().initialRegressor(modelPath).readableModel(readableModelPath).buildFloatLearner().close();
            long l = Files.readAllLines(readableModelPath, Charset.defaultCharset()).size();
            return l;
        }
        finally {
            Files.delete(readableModelPath);
        }
    }

    public static Path getFilePathFromRelativePath(@Nonnull String relativePathToResources) throws IOException {
        Path modelDirectory = Files.createTempDirectory("temp", new FileAttribute[0]);
        Path modelPath = Paths.get(modelDirectory.toString(), "model");
        try (OutputStream os = Files.newOutputStream(modelPath, new OpenOption[0]);
             InputStream is = VWUtility.class.getResourceAsStream(relativePathToResources);){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        return modelPath;
    }
}

