/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;

public class AccuracyValidation
extends ProgressiveValidation {
    private final double decisionThreashold;
    private double correctPredictions = 0.0;
    private int count = 0;

    public AccuracyValidation(double decisionThreashold) {
        super("ACC", true);
        this.decisionThreashold = decisionThreashold;
    }

    @Override
    public synchronized double getScore() {
        if (this.count == 0) {
            return 0.0;
        }
        return this.correctPredictions / (double)this.count;
    }

    @Override
    public synchronized void updateScore(double prediction, double actual) {
        boolean predictionPositive;
        boolean actualPositive = actual > 1.0E-13;
        boolean bl = predictionPositive = prediction > this.decisionThreashold;
        if (actualPositive && predictionPositive || !actualPositive && !predictionPositive) {
            this.correctPredictions += 1.0;
        }
        ++this.count;
    }
}

